/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.servlet.ServletInputStream;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public class ServletInputStreamImpl
extends ServletInputStream {
    private int bytesRead = 0;
    private int mark = 0;
    private int limit = -1;
    private InputStream is;

    public ServletInputStreamImpl() {
    }

    public ServletInputStreamImpl(InputStream is) {
        this.is = is;
    }

    public void setInputStream(InputStream is) {
        this.is = is;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public void setLimit(int limit) {
        this.bytesRead = 0;
        this.mark = 0;
        this.limit = limit;
    }

    public int read() throws IOException {
        if (this.limit != -1) {
            if (this.bytesRead < this.limit) {
                ++this.bytesRead;
                return this.is.read();
            }
            return -1;
        }
        return this.is.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.limit != -1) {
            int numRead;
            if (this.bytesRead == this.limit) {
                return -1;
            }
            if (this.bytesRead + len > this.limit) {
                len = this.limit - this.bytesRead;
            }
            if ((numRead = this.is.read(b, off, len)) > 0) {
                this.bytesRead += numRead;
            }
            return numRead;
        }
        return this.is.read(b, off, len);
    }

    public String readLine() throws IOException {
        byte[] buf = new byte[1024];
        int count = this.readLine(buf, 0, buf.length);
        if (count >= 0) {
            return new String(buf, 0, count);
        }
        return "";
    }

    public int readFully(byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        for (n = 0; n < len; n += count) {
            count = this.is.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return n;
    }

    public int readWord() throws IOException {
        int b1 = this.read();
        if (b1 == -1) {
            return -1;
        }
        int b2 = this.read();
        if (b2 == -1) {
            return -1;
        }
        return (b1 << 8 | b2) & 0xFFFF;
    }

    public String readString(String def) throws IOException {
        int r;
        int len = this.readWord();
        if (len == 65535) {
            return def;
        }
        if (len == -1) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3441));
        }
        byte[] b = new byte[len];
        for (int p = 0; p < len; p += r) {
            r = this.read(b, p, len - p);
            if (r >= 0) continue;
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3442, (Object[])new String[]{String.valueOf(p), String.valueOf(len)}));
        }
        return new String(b);
    }

    public String readString(String def, String encoding) throws IOException {
        int r;
        int len = this.readWord();
        if (len == 65535) {
            return def;
        }
        if (len == -1) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3441));
        }
        byte[] b = new byte[len];
        for (int p = 0; p < len; p += r) {
            r = this.read(b, p, len - p);
            if (r >= 0) continue;
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3442, (Object[])new String[]{String.valueOf(p), String.valueOf(len)}));
        }
        String str = null;
        try {
            str = new String(b, 0, b.length, encoding);
        }
        catch (Exception e) {
            str = new String(b);
        }
        return str;
    }

    public void mark(int readLimit) {
        this.is.mark(readLimit);
        this.mark = this.bytesRead;
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public void reset() {
        try {
            this.is.reset();
            this.bytesRead = this.mark;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public final void clearPostData() throws IOException {
        int toRead = this.getRemainedLength();
        if (toRead <= 0) {
            return;
        }
        byte[] buf = new byte[1024];
        int n = 0;
        try {
            while (toRead > 0) {
                n = this.read(buf, 0, buf.length);
                if (n == -1) {
                    return;
                }
                toRead -= n;
            }
        }
        catch (InterruptedIOException iioe) {
            return;
        }
    }

    public int getRemainedLength() {
        return this.limit - this.bytesRead;
    }

    public void prepareNext() {
        this.bytesRead = 0;
        this.mark = 0;
        this.limit = -1;
    }
}

