/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import jeus.servlet.engine.InstancePool;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public class SmartInstancePool
implements InstancePool {
    private Class servletClass;
    private ServletConfig servletConfig;
    private Vector freeInstancePool;
    private Vector activeInstancePool;
    private int maxInstancePoolSize;
    private int instancePoolSize;

    public SmartInstancePool(int maxNumInstance, Class clazz, ServletConfig sc, Servlet firstObj) {
        this.maxInstancePoolSize = maxNumInstance;
        this.servletClass = clazz;
        this.servletConfig = sc;
        this.freeInstancePool = new Vector();
        this.activeInstancePool = new Vector();
        this.freeInstancePool.addElement(firstObj);
    }

    public synchronized Servlet getFreeInstance() throws ServletException {
        Servlet servlet = null;
        if (!this.freeInstancePool.isEmpty()) {
            servlet = (Servlet)this.freeInstancePool.elementAt(0);
            this.freeInstancePool.removeElementAt(0);
            this.activeInstancePool.addElement(servlet);
        } else {
            servlet = this.createFreeInstance();
        }
        return servlet;
    }

    private synchronized Servlet createFreeInstance() throws ServletException {
        try {
            Servlet servlet = (Servlet)this.servletClass.newInstance();
            servlet.init(this.servletConfig);
            if (this.maxInstancePoolSize < 0 || this.maxInstancePoolSize > this.instancePoolSize) {
                this.activeInstancePool.addElement(servlet);
                ++this.instancePoolSize;
            }
            return servlet;
        }
        catch (Throwable t) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3233, (Object)this.servletClass.getName()), t);
        }
    }

    public synchronized void putActiveInstance(Servlet servlet) {
        if (this.activeInstancePool.removeElement(servlet)) {
            this.freeInstancePool.insertElementAt(servlet, 0);
        } else {
            servlet.destroy();
        }
    }

    public synchronized void release() {
        Servlet servlet;
        int n = this.freeInstancePool.size();
        --n;
        while (n >= 0) {
            servlet = (Servlet)this.freeInstancePool.elementAt(n);
            servlet.destroy();
            --n;
        }
        this.freeInstancePool.clear();
        n = this.activeInstancePool.size();
        --n;
        while (n >= 0) {
            servlet = (Servlet)this.activeInstancePool.elementAt(n);
            servlet.destroy();
            --n;
        }
        this.activeInstancePool.clear();
    }
}

