/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import jeus.servlet.connection.TmaxConnector;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.TmaxRequestProcessor;
import jeus.servlet.engine.io.TmaxHeader;
import jeus.servlet.tcp.TCPDispatcherConfig;
import jeus.util.message.JeusMessage_WebContainer2;

public class TmaxThreadPoolManager
extends ThreadPoolManager {
    private TCPDispatcherConfig dispatcherConfig = null;
    private TmaxConnector connector;
    private int clhPort;
    private boolean processingCreatePool = false;
    private boolean tms;
    private String serverGroupName;

    public TmaxThreadPoolManager(ContextGroup ctxgrp, TmaxConnector connector, ConnectionDescriptor desc, int clhId) {
        super(ctxgrp, desc);
        this.connQueue = null;
        this.connector = connector;
        this.clhPort = connector.getClhPort(clhId);
        this.dispatcherConfig = connector.getDispatcherConfig();
        this.tms = false;
        this.serverGroupName = null;
        this.threadPoolId = desc.getListenerId() + "-clh" + clhId + "(" + desc.getWebServerAddress() + ":" + this.clhPort + ")";
        if (desc.getServerType() != null && desc.getServerType().equalsIgnoreCase("tms")) {
            this.tms = true;
        }
        this.serverGroupName = desc.getServerGroupName();
    }

    public synchronized void createPool() throws StartingException {
        if (this.isDestroyed) {
            return;
        }
        int minThreadNum = this.tpoolDesc.getMinThreadNum();
        if (minThreadNum > this.connector.getCpcCount()) {
            minThreadNum = this.connector.getCpcCount();
        }
        try {
            this.processingCreatePool = true;
            Vector vector = this.connector.getXidVector();
            String s = this.connector.getCurrentConnectionDescriptor().getXAResourceClass();
            if (s != null && !s.equals("")) {
                if (!this.connector.isRecover()) {
                    for (int j = 0; j < minThreadNum; ++j) {
                        TmaxRequestProcessor tmaxrequestprocessor = new TmaxRequestProcessor(this, this.contextGroup, this.dispatcherConfig, this.clhPort, j);
                        this.threadPool.addElement(tmaxrequestprocessor);
                        tmaxrequestprocessor.sendNotify();
                    }
                    for (int k = 0; k < minThreadNum; ++k) {
                        TmaxRequestProcessor tmaxrequestprocessor1 = (TmaxRequestProcessor)this.threadPool.elementAt(k);
                        tmaxrequestprocessor1.start();
                    }
                } else {
                    for (int l = 0; l < minThreadNum; ++l) {
                        TmaxRequestProcessor tmaxrequestprocessor2 = null;
                        tmaxrequestprocessor2 = ((Vector)vector.elementAt(l)).size() != 0 ? new TmaxRequestProcessor(this, this.contextGroup, this.dispatcherConfig, this.clhPort, l, true) : new TmaxRequestProcessor(this, this.contextGroup, this.dispatcherConfig, this.clhPort, l);
                        this.threadPool.addElement(tmaxrequestprocessor2);
                    }
                    for (int i1 = 0; i1 < minThreadNum; ++i1) {
                        TmaxRequestProcessor tmaxrequestprocessor3 = (TmaxRequestProcessor)this.threadPool.elementAt(i1);
                        if (((Vector)vector.elementAt(i1)).size() <= 0) continue;
                        tmaxrequestprocessor3.recover((Vector)vector.elementAt(i1));
                    }
                    for (int j1 = 0; j1 < minThreadNum; ++j1) {
                        TmaxRequestProcessor tmaxrequestprocessor4 = (TmaxRequestProcessor)this.threadPool.elementAt(j1);
                        tmaxrequestprocessor4.sendNotify();
                    }
                    for (int k1 = 0; k1 < minThreadNum; ++k1) {
                        TmaxRequestProcessor tmaxrequestprocessor5 = (TmaxRequestProcessor)this.threadPool.elementAt(k1);
                        tmaxrequestprocessor5.start();
                    }
                }
            } else {
                for (int l1 = 0; l1 < minThreadNum; ++l1) {
                    TmaxRequestProcessor tmaxrequestprocessor6 = new TmaxRequestProcessor(this, this.contextGroup, this.dispatcherConfig, this.clhPort, l1);
                    this.threadPool.addElement(tmaxrequestprocessor6);
                    tmaxrequestprocessor6.start();
                }
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw new StartingException(2363, new String[]{ioe.getMessage()});
        }
        finally {
            this.processingCreatePool = false;
        }
    }

    public int createThreads() {
        return 0;
    }

    public synchronized void checkThreadPool() {
        if (this.isDestroyed) {
            return;
        }
        if (this.processingCreatePool) {
            return;
        }
        int numActiveDeleted = 0;
        int numDead = 0;
        int numCreated = 0;
        int size = this.threadPool.size();
        ArrayList<Integer> deadThreads = new ArrayList<Integer>();
        for (int i = size - 1; i >= 0; --i) {
            TmaxRequestProcessor worker = (TmaxRequestProcessor)this.threadPool.elementAt(i);
            if (worker.isAlive() || worker.isDeleted()) continue;
            deadThreads.add(new Integer(worker.getCpcId()));
            this.threadPool.removeElementAt(i);
            if (!logger.isLoggable(JeusMessage_WebContainer2._3373_LEVEL)) continue;
            logger.log(JeusMessage_WebContainer2._3373_LEVEL, JeusMessage_WebContainer2._3373, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker.getThreadId(), worker.getRequestURI()});
        }
        if (deadThreads.size() > 0) {
            Iterator it = deadThreads.iterator();
            while (it.hasNext()) {
                int id = (Integer)it.next();
                TmaxRequestProcessor worker = new TmaxRequestProcessor(this, this.contextGroup, this.dispatcherConfig, this.clhPort, id);
                this.threadPool.addElement(worker);
                worker.start();
                ++numCreated;
                if (!logger.isLoggable(JeusMessage_WebContainer2._3379_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer2._3379_LEVEL, JeusMessage_WebContainer2._3379, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker.getThreadId()});
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3381_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3381_LEVEL, JeusMessage_WebContainer2._3381, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), String.valueOf(numActiveDeleted), String.valueOf(numDead), String.valueOf(numCreated)});
        }
        this.connector.checkAlivePrimary();
    }

    public void deleteAllThreads() {
    }

    public int getSpri() {
        return this.connector.getSpri();
    }

    public int getClid() {
        return this.connector.getClid();
    }

    public String getConnectionInfo() {
        return this.getThreadPoolId() + " [port: " + this.clhPort + "] live connections = " + this.threadPool.size();
    }

    public String getWebServerAddress() {
        return this.connector.getWebServerAddress();
    }

    public boolean isTms() {
        return this.tms;
    }

    public String getServerGroupName() {
        return this.serverGroupName;
    }

    public TmaxHeader getTmaxHeader() {
        return this.connector.getTmaxHeader();
    }

    public TmaxConnector getConnector() {
        return this.connector;
    }
}

