/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.ServletInputStreamImpl;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.WebtobThreadPoolManager;
import jeus.servlet.engine.io.WebtobHeader;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.StringUtil;
import jeus.util.cnet.NetUtil;
import jeus.util.message.JeusMessage_WebContainer2;
import jeus.util.trace.GID;

public class WebtobServletRequest
extends HttpServletRequestImpl
implements WebtobHeader {
    public long startTime;
    private int webtobMessageType;
    private int webtobBodySize;
    private int webtobSequenceNumber;
    private int webtobClientId;
    private int webtobEtc;
    private int webtobSvciFlags;
    private int webtobSvciCd;
    private int webtobQcount;

    WebtobServletRequest(ContextGroup ctxGroup, ThreadPoolManager manager) {
        super(ctxGroup, manager);
    }

    public void setSocket(Socket soc) throws IOException {
        try {
            this.socket = soc;
            InputStream is = soc.getInputStream();
            this.bin = new BufferedInputStream(is);
            this.in = new ServletInputStreamImpl(this.bin);
        }
        catch (IOException ioe) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3352));
        }
    }

    public void copySocket(HttpServletRequestImpl copy) {
        if (copy == null) {
            return;
        }
        this.socket = copy.socket;
        this.bin = copy.bin;
        this.in = copy.in;
    }

    private boolean isSystemMessage() {
        return this.webtobMessageType == 2105 || this.webtobMessageType == 1105 || this.webtobMessageType == 108 || this.webtobMessageType == 1124 || this.webtobMessageType == 140;
    }

    public int readRequest(int readTimeout, int postdataReadTimeout) throws IOException, InterruptedException {
        int httpHeaderSize;
        byte[] buf;
        int size;
        if (readTimeout >= 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(readTimeout);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (postdataReadTimeout > 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.webtobMessageType = 0;
        this.webtobBodySize = 0;
        this.webtobQcount = 0;
        this.parseWebtobHeader();
        if (this.isSystemMessage()) {
            return this.webtobMessageType;
        }
        if (this.webtobBodySize <= 0) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3353, (Object[])new String[]{String.valueOf(this.webtobBodySize)}));
        }
        if (this.webtobQcount > 0) {
            ((WebtobThreadPoolManager)this.tpoolManager).createThreads(this.webtobQcount);
        }
        if ((size = this.in.readFully(buf = new byte[httpHeaderSize = this.webtobBodySize - this.contentLength], 0, httpHeaderSize)) != httpHeaderSize) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3354, (Object[])new String[]{String.valueOf(size), String.valueOf(httpHeaderSize)}));
        }
        this.in.setLimit(this.contentLength);
        int mark = 0;
        int fieldSize = 0;
        block17: while (mark < httpHeaderSize) {
            if ((fieldSize = (buf[mark++] - 48) * 1000 + (buf[mark++] - 48) * 100 + (buf[mark++] - 48) * 10 + (buf[mark++] - 48)) < 0) {
                throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3355, (Object)String.valueOf(fieldSize)));
            }
            if (fieldSize == 0) break;
            byte id = buf[mark++];
            String str = null;
            try {
                str = new String(buf, mark, fieldSize, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                str = new String(buf, mark, fieldSize);
            }
            mark += fieldSize;
            switch (id) {
                case 83: {
                    if (str == null || str.indexOf(".") <= 0) continue block17;
                    this.serverName = str;
                    break;
                }
                case 67: {
                    this.contextPath = str.substring(0, str.length() - 1);
                    this.contextPath = this.contextPath.trim();
                    break;
                }
                case 82: {
                    int indexQ = str.indexOf("?");
                    int rLen = str.length();
                    if (indexQ > -1 && indexQ < rLen) {
                        this.requestURI.setString(str.substring(0, indexQ));
                        this.queryString.setString(str.substring(indexQ + 1, rLen));
                        break;
                    }
                    this.requestURI.setString(str);
                    break;
                }
                case 77: {
                    this.method.setString(str);
                    break;
                }
                case 80: {
                    this.protocol.setString(str);
                    break;
                }
                case 69: {
                    String value;
                    int pos = str.indexOf("\t");
                    if (pos > 0) {
                        String name = str.substring(0, pos);
                        value = str.substring(pos + 1);
                        if (name.equals("REMOTE_ADDR")) {
                            this.remoteAddr = value;
                            break;
                        }
                        if (name.equals("REMOTE_HOST")) {
                            this.remoteHost = value;
                            break;
                        }
                        if (name.equals("SERVER_PORT")) {
                            this.serverPort = Integer.parseInt(value);
                            break;
                        }
                        if (name.equals("REMOTE_USER")) break;
                        if (name.equals("REQUEST_SCHEME")) {
                            this.scheme = value.toLowerCase();
                            break;
                        }
                        if (!name.equals("AUTH_TYPE") || value == null || value.equals("")) continue block17;
                        if (value.equalsIgnoreCase("basic")) {
                            this.authType = "BASIC";
                            break;
                        }
                        if (value.equalsIgnoreCase("digest")) {
                            this.authType = "DIGEST";
                            break;
                        }
                        this.authType = value;
                        break;
                    }
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3358_LEVEL)) continue block17;
                    logger.log(JeusMessage_WebContainer2._3358_LEVEL, JeusMessage_WebContainer2._3358, (Object)str);
                    break;
                }
                case 72: {
                    String value;
                    int pos = str.indexOf("\t");
                    if (pos > 0) {
                        String name = str.substring(0, pos);
                        value = str.substring(pos + 1);
                        if (WebProperties.J2EE_COMPATIBLE.value) {
                            StringBuffer j2eebuf = new StringBuffer();
                            StringTokenizer st1 = new StringTokenizer(value, ",");
                            while (st1.hasMoreTokens()) {
                                j2eebuf.append(st1.nextToken().trim());
                                if (!st1.hasMoreTokens()) continue;
                                j2eebuf.append(",");
                            }
                            value = j2eebuf.toString();
                        }
                        this.addHeader(name, value);
                        break;
                    }
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3359_LEVEL)) continue block17;
                    logger.log(JeusMessage_WebContainer2._3359_LEVEL, JeusMessage_WebContainer2._3359, (Object)str);
                    break;
                }
                default: {
                    throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3356, (Object)new Byte(id).toString()));
                }
            }
        }
        if (mark > httpHeaderSize) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3357));
        }
        this.processCommonRequest(this.requestURI, this.contextPath, null);
        if (logger.isLoggable(JeusMessage_WebContainer2._3264_LEVEL)) {
            StringBuffer buf2 = new StringBuffer();
            buf2.append("\theader-len   : " + httpHeaderSize + StringUtil.lineSeparator);
            buf2.append("\tcontent-len  : " + this.contentLength + StringUtil.lineSeparator);
            buf2.append("\tcontent-type : " + this.getContentType() + StringUtil.lineSeparator);
            buf2.append("\tserver-name  : " + this.getServerName() + StringUtil.lineSeparator);
            buf2.append("\trequest-uri  : " + this.requestURI + StringUtil.lineSeparator);
            buf2.append("\tquery-string : " + this.queryString + StringUtil.lineSeparator);
            buf2.append("\tmethod       : " + this.method + StringUtil.lineSeparator);
            buf2.append("\tprotocol     : " + this.protocol + StringUtil.lineSeparator);
            buf2.append("\tcontext-path : " + this.contextPath + StringUtil.lineSeparator);
            buf2.append("\tcontext-name : " + (this.context == null ? "null" : this.context.getContextName()) + StringUtil.lineSeparator);
            Enumeration enum1 = this.headers3.keys();
            while (enum1.hasMoreElements()) {
                String name1 = (String)enum1.nextElement();
                Vector values = (Vector)this.headers3.get(name1);
                Enumeration enum2 = values.elements();
                while (enum2.hasMoreElements()) {
                    String value1 = (String)enum2.nextElement();
                    buf2.append("\theaders      : " + name1 + ":" + value1 + StringUtil.lineSeparator);
                }
            }
            logger.log(JeusMessage_WebContainer2._3264_LEVEL, JeusMessage_WebContainer2._3264, (Object)buf2.toString());
        }
        if (postdataReadTimeout > 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(postdataReadTimeout);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.webtobMessageType;
    }

    private void parseWebtobHeader() throws IOException {
        while (true) {
            byte[] header;
            int size;
            if ((size = this.in.readFully(header = new byte[96], 0, 96)) < 96) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3360_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3360_LEVEL, JeusMessage_WebContainer2._3360, (Object)String.valueOf(size));
                }
                throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3360, (Object)String.valueOf(size)));
            }
            this.startTime = System.currentTimeMillis();
            int magic = NetUtil.readInt((byte[])header, (int)0);
            this.webtobQcount = NetUtil.readInt((byte[])header, (int)20);
            this.webtobBodySize = NetUtil.readInt((byte[])header, (int)84);
            this.webtobMessageType = NetUtil.readInt((byte[])header, (int)16);
            this.webtobSequenceNumber = NetUtil.readInt((byte[])header, (int)4);
            this.webtobClientId = NetUtil.readInt((byte[])header, (int)24);
            this.webtobEtc = NetUtil.readInt((byte[])header, (int)28);
            this.webtobSvciFlags = NetUtil.readInt((byte[])header, (int)88);
            this.webtobSvciCd = NetUtil.readInt((byte[])header, (int)92);
            this.contentLength = NetUtil.readInt((byte[])header, (int)32);
            int[] id = new int[]{this.webtobClientId, this.webtobSequenceNumber};
            GID gid = new GID(id);
            GID.setCurrentGID(gid);
            GID.increaseSeqNumber();
            if (magic != 9999) {
                throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3361, (Object)String.valueOf(magic)));
            }
            if (this.webtobMessageType != 203) break;
            this.processPingRequest(header);
        }
    }

    private void processPingRequest(byte[] header) throws IOException {
        header[16] = 0;
        header[17] = 0;
        header[18] = 4;
        header[19] = -77;
        OutputStream os = this.socket.getOutputStream();
        os.write(header);
        os.flush();
        if (logger.isLoggable(JeusMessage_WebContainer2._3265_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3265_LEVEL, JeusMessage_WebContainer2._3265);
        }
    }

    public int getWebtobSequenceNumber() {
        return this.webtobSequenceNumber;
    }

    public int getWebtobClientId() {
        return this.webtobClientId;
    }

    public int getWebtobSvciFlags() {
        return this.webtobSvciFlags;
    }

    public int getWebtobEtc() {
        return this.webtobEtc;
    }

    public int getWebtobSvciCd() {
        return this.webtobSvciCd;
    }

    public int getRemotePort() {
        return -1;
    }
}

