/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.IOException;
import java.io.OutputStream;
import jeus.servlet.engine.io.FullBufferedOutputAdaptor;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.util.message.JeusMessage_WebContainer2;

public class HeadOutputAdaptor
extends FullBufferedOutputAdaptor {
    protected HeadOutputAdaptor(OutputStream out, WebServerOutputStream webServer, byte[] header, byte[] body) {
        super(out, webServer, header, body);
    }

    protected int prepareBuffer(int min, int max) throws IOException {
        this.bufferCount = 0;
        return this.httpBody.length;
    }

    protected void writeContentLength() {
        String str;
        byte[] b;
        int contentLength = this.getContentCount();
        if (this.responseHeaderInfo.contentLength >= 0) {
            contentLength = this.responseHeaderInfo.contentLength;
        }
        if ((b = (str = "Content-Length: " + String.valueOf(contentLength) + "\r\n\r\n").getBytes()).length > this.httpHeader.length - this.headerCount) {
            byte[] tmp = this.httpHeader;
            this.httpHeader = this.webServer.resizeHttpHeader(this.httpHeader.length + b.length);
            System.arraycopy(tmp, 0, this.httpHeader, 0, this.headerCount);
            tmp = null;
        }
        System.arraycopy(b, 0, this.httpHeader, this.headerCount, b.length);
        this.headerCount += b.length;
        if (logger.isLoggable(JeusMessage_WebContainer2._3273_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3273_LEVEL, JeusMessage_WebContainer2._3273, (Object)new String(this.httpHeader, this.webServerHeaderSize, this.headerCount - this.webServerHeaderSize));
        }
    }

    public boolean internalFlush(boolean forced, boolean last) throws IOException {
        try {
            if (last) {
                this.writeHeader();
                this.writeContentLength();
                this.webServer.setWebServerHeader(last, this.headerCount, 0, this.httpHeader);
                this.out.write(this.httpHeader, 0, this.headerCount);
                this.out.flush();
                this.committed = true;
                if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                }
                return true;
            }
            if (forced) {
                this.writeHeader();
                this.committed = true;
                if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                }
                return false;
            }
        }
        catch (IOException ioe) {
            this.committed = false;
            this.reset();
            throw ioe;
        }
        return false;
    }
}

