/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.io.ServletOutputStreamWriter;
import jeus.servlet.engine.io.ServletPrintWriter;

public class ServletPrintWriterWrap
extends ServletPrintWriter {
    private HttpServletResponseImpl savedResImpl;
    private boolean isFirstWriteDone = false;
    private int contentLength = -1;
    private int current = 0;

    public ServletPrintWriterWrap(ServletOutputStreamWriter out, HttpServletResponseImpl savedResImpl) {
        super(out);
        this.savedResImpl = savedResImpl;
    }

    private void checkState() {
        if (!this.isFirstWriteDone) {
            this.savedResImpl.setUsingWriter(true);
            this.isFirstWriteDone = true;
        }
    }

    private boolean allow(int _length) {
        return true;
    }

    private int howMuchAllow(int _length) {
        int _howMuch = this.contentLength - (this.current + _length);
        return _howMuch < 0 ? 0 : _howMuch;
    }

    public void write(int c) {
        this.checkState();
        if (this.allow(1)) {
            super.write(c);
            ++this.current;
        }
    }

    public void write(char[] buf, int off, int len) {
        this.checkState();
        if (this.allow(len)) {
            super.write(buf, off, len);
            this.current += len;
        } else {
            int howMuch = this.contentLength - (this.current + len);
            if (howMuch > 0) {
                howMuch = howMuch > len ? len : howMuch;
                super.write(buf, off, howMuch);
                this.current += howMuch;
            }
        }
    }

    public void write(String s, int off, int len) {
        this.checkState();
        if (this.allow(len)) {
            super.write(s, off, len);
            this.current += len;
        } else {
            int howMuch = this.contentLength - (this.current + len);
            if (howMuch > 0) {
                howMuch = howMuch > len ? len : howMuch;
                super.write(s, off, howMuch);
                this.current += howMuch;
            }
        }
    }

    public void println() {
        this.checkState();
        if (this.allow(1)) {
            super.println();
            ++this.current;
        }
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public int howMuchWrite() {
        return this.current;
    }
}

