/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import jeus.servlet.engine.io.TmaxHeader;
import jeus.servlet.engine.io.TmaxOutputAdaptor;
import jeus.servlet.engine.io.TmaxUtil;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.servlet.tcp.TmaxServletRequestImpl;
import jeus.servlet.tcp.TmaxServletResponse;
import jeus.util.message.JeusMessage_WebContainer4;

public class TmaxOutputStream
extends WebServerOutputStream {
    private TmaxOutputAdaptor tmaxAdaptor;
    private int webtobClenCount = 0;
    private TmaxHeader tmaxHeader;
    long startTime;
    long endTime;

    public TmaxOutputStream(TmaxHeader tmaxHeader, OutputStream os) {
        super(os, 0);
        this.tmaxHeader = tmaxHeader;
        this.initializeAdaptor();
    }

    public TmaxOutputStream(TmaxHeader tmaxHeader, OutputStream os, int bufsize) {
        super(os, 0);
        this.tmaxHeader = tmaxHeader;
        this.initializeAdaptor();
    }

    protected void initializeAdaptor() {
        this.tmaxAdaptor = new TmaxOutputAdaptor(this.out, this, this.httpHeader, this.httpBody);
    }

    public void selectOutputAdaptor() throws IOException {
        if (this.request == null || this.response == null) {
            throw new IOException("a request and response must be set");
        }
        if (this.adaptor != null) {
            return;
        }
        this.adaptor = this.tmaxAdaptor;
        this.bufferedMode = false;
        this.adaptor.setOutputStream(this.out);
    }

    byte[] getWebServerSpecificBody() {
        TmaxServletRequestImpl tmaxreq = (TmaxServletRequestImpl)this.request;
        if (tmaxreq == null || !tmaxreq.isHttpGW) {
            return null;
        }
        byte[] metadata = this.makeMetaData();
        if (logger.isLoggable(JeusMessage_WebContainer4._4501_LEVEL)) {
            logger.log(JeusMessage_WebContainer4._4501_LEVEL, JeusMessage_WebContainer4._4501, (Object)String.valueOf(metadata.length));
        }
        return metadata;
    }

    public int getWebServerHeaderSize() {
        TmaxServletRequestImpl tmaxreq = (TmaxServletRequestImpl)this.request;
        if (tmaxreq == null || !tmaxreq.isHttpGW) {
            if (logger.isLoggable(JeusMessage_WebContainer4._4502_LEVEL)) {
                logger.log(JeusMessage_WebContainer4._4502_LEVEL, JeusMessage_WebContainer4._4502, (Object)String.valueOf(this.tmaxHeader.TMAX_HEADER_SIZE()));
            }
            return this.tmaxHeader.TMAX_HEADER_SIZE();
        }
        if (logger.isLoggable(JeusMessage_WebContainer4._4503_LEVEL)) {
            logger.log(JeusMessage_WebContainer4._4503_LEVEL, JeusMessage_WebContainer4._4503, (Object)String.valueOf(this.tmaxHeader.TMAX_HEADER_SIZE() + 96));
        }
        return this.tmaxHeader.TMAX_HEADER_SIZE() + 96;
    }

    public void setWebServerHeader(boolean last, int totalCount, int off, byte[] buf) {
        TmaxServletRequestImpl tmaxreq = (TmaxServletRequestImpl)this.request;
        TmaxServletResponse tmaxres = (TmaxServletResponse)this.response;
        byte[] headerBytes = tmaxres.getTmaxHeader();
        this.startTime = tmaxres.getStartTime();
        this.endTime = System.currentTimeMillis();
        long processingTime = this.endTime - this.startTime;
        short sec = (short)(processingTime / 1000L);
        short msec = (short)(processingTime % 1000L);
        headerBytes[4] = (byte)(sec >> 8);
        headerBytes[5] = (byte)sec;
        headerBytes[6] = (byte)(msec >> 8);
        headerBytes[7] = (byte)msec;
        if (!tmaxreq.isHttpGW) {
            System.arraycopy(headerBytes, 0, buf, off, headerBytes.length);
            if (logger.isLoggable(JeusMessage_WebContainer4._4504_LEVEL)) {
                logger.log(JeusMessage_WebContainer4._4504_LEVEL, JeusMessage_WebContainer4._4504, (Object)String.valueOf(TmaxUtil.readInt(headerBytes, this.tmaxHeader.SVCILEN_OFFSET())));
            }
            return;
        }
        int size = totalCount - this.tmaxHeader.TMAX_HEADER_SIZE();
        int msgtype = TmaxUtil.readInt(headerBytes, this.tmaxHeader.MSGTYPE_OFFSET());
        TmaxUtil.writeInt(headerBytes, msgtype + 1000, this.tmaxHeader.MSGTYPE_OFFSET());
        TmaxUtil.writeInt(headerBytes, size, this.tmaxHeader.SVCILEN_OFFSET());
        System.arraycopy(headerBytes, 0, buf, off, headerBytes.length);
        if (logger.isLoggable(JeusMessage_WebContainer4._4505_LEVEL)) {
            logger.log(JeusMessage_WebContainer4._4505_LEVEL, JeusMessage_WebContainer4._4505, (Object)String.valueOf(TmaxUtil.readInt(headerBytes, this.tmaxHeader.SVCILEN_OFFSET())));
        }
        for (int i = off += headerBytes.length; i < off + 96; ++i) {
            buf[i] = 0;
        }
        totalCount -= this.tmaxHeader.TMAX_HEADER_SIZE();
        this.webtobClenCount += (totalCount -= 96);
        buf[off + 0] = 0;
        buf[off + 1] = 0;
        buf[off + 2] = 39;
        buf[off + 3] = 15;
        buf[off + 84] = (byte)(totalCount >> 24);
        buf[off + 84 + 1] = (byte)(totalCount >> 16);
        buf[off + 84 + 2] = (byte)(totalCount >> 8);
        buf[off + 84 + 3] = (byte)totalCount;
        int type = 1301;
        if (this.bufferedMode) {
            type = last ? 5302 : 5301;
        }
        buf[off + 16] = (byte)(type >> 24);
        buf[off + 16 + 1] = (byte)(type >> 16);
        buf[off + 16 + 2] = (byte)(type >> 8);
        buf[off + 16 + 3] = (byte)type;
        int value = tmaxreq.getWebtobSequenceNumber();
        buf[off + 4] = (byte)(value >> 24);
        buf[off + 4 + 1] = (byte)(value >> 16);
        buf[off + 4 + 2] = (byte)(value >> 8);
        buf[off + 4 + 3] = (byte)value;
        value = this.response.getStatus();
        buf[off + 20] = (byte)(value >> 24);
        buf[off + 20 + 1] = (byte)(value >> 16);
        buf[off + 20 + 2] = (byte)(value >> 8);
        buf[off + 20 + 3] = (byte)value;
        value = tmaxreq.getWebtobClientId();
        buf[off + 24] = (byte)(value >> 24);
        buf[off + 24 + 1] = (byte)(value >> 16);
        buf[off + 24 + 2] = (byte)(value >> 8);
        buf[off + 24 + 3] = (byte)value;
        value = tmaxreq.getWebtobEtc();
        buf[off + 28] = (byte)(value >> 24);
        buf[off + 28 + 1] = (byte)(value >> 16);
        buf[off + 28 + 2] = (byte)(value >> 8);
        buf[off + 28 + 3] = (byte)value;
        value = tmaxreq.getWebtobSvciFlags();
        buf[off + 88] = (byte)(value >> 24);
        buf[off + 88 + 1] = (byte)(value >> 16);
        buf[off + 88 + 2] = (byte)(value >> 8);
        buf[off + 88 + 3] = (byte)value;
        value = tmaxreq.getWebtobSvciCd();
        buf[off + 92] = (byte)(value >> 24);
        buf[off + 92 + 1] = (byte)(value >> 16);
        buf[off + 92 + 2] = (byte)(value >> 8);
        buf[off + 92 + 3] = (byte)value;
        if (last) {
            this.webtobClenCount -= this.adaptor.getHttpHeaderSize();
            buf[off + 32] = (byte)(this.webtobClenCount >> 24);
            buf[off + 32 + 1] = (byte)(this.webtobClenCount >> 16);
            buf[off + 32 + 2] = (byte)(this.webtobClenCount >> 8);
            buf[off + 32 + 3] = (byte)this.webtobClenCount;
            this.webtobClenCount = 0;
        }
    }

    protected final void webServerFinish() {
    }

    public void clearing() {
    }

    public void clearing(boolean socketReused) {
        if (!socketReused) {
            try {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private byte[] makeMetaData() {
        TmaxServletResponse tmaxres = (TmaxServletResponse)this.response;
        HashMap headerMap = tmaxres.getHeaders();
        try {
            String key2;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            for (String key2 : headerMap.keySet()) {
                ArrayList list = (ArrayList)headerMap.get(key2);
                if (list == null || list.size() == 0 || key2.equals("Content-Length")) continue;
                for (String value : list) {
                    if (key2.startsWith("X-")) {
                        bout.write(this.convertLength(key2.getBytes().length + value.getBytes().length + 1));
                        bout.write(88);
                        bout.write((key2 + "\t" + value).getBytes());
                    } else {
                        bout.write(this.convertLength(key2.getBytes().length + value.getBytes().length + 1));
                        bout.write(72);
                        bout.write((key2 + "\t" + value).getBytes());
                    }
                    if (!logger.isLoggable(JeusMessage_WebContainer4._4507_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer4._4507_LEVEL, JeusMessage_WebContainer4._4507, (Object[])new String[]{key2, value});
                }
            }
            key2 = "Content-Length";
            String value = String.valueOf(this.adaptor.getBufferCount());
            bout.write(this.convertLength(key2.getBytes().length + value.getBytes().length + 1));
            bout.write(72);
            bout.write((key2 + "\t" + value).getBytes());
            if (logger.isLoggable(JeusMessage_WebContainer4._4507_LEVEL)) {
                logger.log(JeusMessage_WebContainer4._4507_LEVEL, JeusMessage_WebContainer4._4507, (Object[])new String[]{key2, value});
            }
            String status = Integer.toString(tmaxres.getStatus());
            bout.write(this.convertLength(status.getBytes().length));
            bout.write(79);
            bout.write(status.getBytes());
            if (logger.isLoggable(JeusMessage_WebContainer4._4508_LEVEL)) {
                logger.log(JeusMessage_WebContainer4._4508_LEVEL, JeusMessage_WebContainer4._4508, (Object)status);
            }
            bout.write("0000".getBytes());
            return bout.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0000".getBytes();
        }
    }

    private byte[] convertLength(int len) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = 48;
        }
        String s = String.valueOf(len);
        byte[] bb = s.getBytes();
        int off = 4 - bb.length;
        System.arraycopy(bb, 0, b, off, bb.length);
        return b;
    }
}

