/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.servlet.engine.io.TmaxHeader;
import jeus.servlet.engine.io.TmaxHeaderVer3;
import jeus.servlet.engine.io.TmaxHeaderVer4;

public class TmaxUtil {
    public static final TmaxHeader VER3_HEADER = TmaxHeaderVer3.getInstnace();
    public static final TmaxHeader VER4_HEADER = TmaxHeaderVer4.getInstnace();
    private static final int VER3_HEADER_LEN = VER3_HEADER.TMAX_HEADER_SIZE();
    private static final int VER4_HEADER_LEN = VER4_HEADER.TMAX_HEADER_SIZE();

    public static boolean isTmaxClassicHeader(TmaxHeader hdr) {
        if (hdr == null) {
            throw new IllegalArgumentException("tmax header is null");
        }
        if (hdr == VER3_HEADER) {
            return true;
        }
        if (hdr == VER4_HEADER) {
            return false;
        }
        throw new IllegalArgumentException("can not determine tmax header version");
    }

    public static byte[] makeHeader(TmaxHeader tmHeader, int msgtype) {
        byte[] header = new byte[tmHeader.TMAX_HEADER_SIZE()];
        TmaxUtil.writeInt(header, tmHeader.MAGIC_NUMBER(), 0);
        TmaxUtil.writeInt(header, msgtype, tmHeader.MSGTYPE_OFFSET());
        return header;
    }

    public static void writeInt(byte[] array, int value, int offset) {
        array[offset + 0] = (byte)(value >> 24);
        array[offset + 1] = (byte)(value >> 16);
        array[offset + 2] = (byte)(value >> 8);
        array[offset + 3] = (byte)value;
    }

    public static int readInt(byte[] array, int offset) {
        int ch1 = array[offset] >= 0 ? array[offset] : 256 + array[offset];
        int ch2 = array[offset + 1] >= 0 ? array[offset + 1] : 256 + array[offset + 1];
        int ch3 = array[offset + 2] >= 0 ? array[offset + 2] : 256 + array[offset + 2];
        int ch4 = array[offset + 3] >= 0 ? array[offset + 3] : 256 + array[offset + 3];
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public static void writeString(TmaxHeader tmaxHeader, byte[] array, String value, int offset) {
        int len = value.length();
        if (len > tmaxHeader.TMAX_NAME_LENGTH()) {
            len = tmaxHeader.TMAX_NAME_LENGTH();
        }
        byte[] name = value.getBytes();
        System.arraycopy(name, 0, array, offset, len);
        array[offset + len] = 0;
    }

    public static String readString(byte[] array, int offset, int len) {
        return new String(array, offset, len);
    }

    public static Object[] detectHeader(InputStream in) throws IOException {
        byte[] reply1 = new byte[VER3_HEADER_LEN];
        TmaxUtil.readFully(in, reply1, reply1.length, 0);
        int magic = TmaxUtil.readInt(reply1, 0);
        if (magic == VER3_HEADER.MAGIC_NUMBER()) {
            return new Object[]{reply1, VER3_HEADER};
        }
        if (magic == VER4_HEADER.MAGIC_NUMBER()) {
            byte[] reply2 = new byte[VER4_HEADER_LEN];
            System.arraycopy(reply1, 0, reply2, 0, VER3_HEADER_LEN);
            TmaxUtil.readFully(in, reply2, VER4_HEADER_LEN - VER3_HEADER_LEN, VER3_HEADER_LEN);
            return new Object[]{reply2, VER4_HEADER};
        }
        throw new IOException("magic error : " + magic);
    }

    public static byte[] recvHeader(TmaxHeader tmHeader, InputStream in) throws IOException {
        byte[] reply = new byte[tmHeader.TMAX_HEADER_SIZE()];
        TmaxUtil.readFully(in, reply, reply.length, 0);
        return TmaxUtil.checkMagic(tmHeader, reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] recvHeader(TmaxHeader tmHeader, SocketChannel channel) throws IOException {
        byte[] reply = new byte[tmHeader.TMAX_HEADER_SIZE()];
        ByteBuffer replyByteBuffer = null;
        try {
            int n;
            replyByteBuffer = ByteBufferCreator.allocateByteBuffer((boolean)true, (int)reply.length, (boolean)true);
            int count = 0;
            do {
                if ((n = channel.read(replyByteBuffer)) != -1) continue;
                throw new EOFException("end-of-stream while reading Tmax Header");
            } while ((count += n) < tmHeader.TMAX_HEADER_SIZE());
            replyByteBuffer.flip();
            replyByteBuffer.get(reply);
        }
        finally {
            if (replyByteBuffer != null) {
                ByteBufferCreator.freeByteBuffer((ByteBuffer)replyByteBuffer);
            }
        }
        return TmaxUtil.checkMagic(tmHeader, reply);
    }

    private static byte[] checkMagic(TmaxHeader tmHeader, byte[] reply) throws IOException {
        int magic = TmaxUtil.readInt(reply, 0);
        if (magic != tmHeader.MAGIC_NUMBER()) {
            throw new IOException("magic error : " + magic);
        }
        return reply;
    }

    public static byte[] recvData(InputStream in, int datalen) throws IOException {
        byte[] data = new byte[datalen];
        TmaxUtil.readFully(in, data, data.length, 0);
        return data;
    }

    private static int readFully(InputStream in, byte[] buf, int len, int off) throws IOException {
        int n;
        int count;
        for (n = 0; n < len; n += count) {
            count = in.read(buf, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return n;
    }

    public static void unregisterConnection(TmaxHeader tmHeader, OutputStream out, InputStream in, boolean tmm, int procType) throws IOException {
        byte[] reply;
        int msgtype;
        byte[] header = TmaxUtil.makeHeader(tmHeader, 105);
        if (tmm) {
            TmaxUtil.writeInt(header, procType, tmHeader.TYPE_OFFSET());
        }
        out.write(header);
        out.flush();
        while ((msgtype = TmaxUtil.readInt(reply = TmaxUtil.recvHeader(tmHeader, in), tmHeader.MSGTYPE_OFFSET())) != 1105) {
        }
    }

    public static String byteArrayToHexString(byte[] in) {
        return TmaxUtil.byteArrayToHexString(in, 0, in.length);
    }

    public static String byteArrayToHexString(byte[] in, int offset, int len) {
        return TmaxUtil.byteArrayToHexString(in, 0, in.length, true, true);
    }

    public static String byteArrayToHexString(byte[] in, int offset, int len, boolean lineBreak, boolean hasSpace) {
        byte ch = 0;
        int i = offset;
        if (in == null || len <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(len * 2);
        int count = 0;
        while (i < len) {
            if (count != 0 && count % 8 == 0) {
                if (lineBreak) {
                    out.append('\n');
                } else {
                    out.append(':');
                }
            }
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            if (hasSpace) {
                out.append(' ');
            }
            ++i;
            ++count;
        }
        String rslt = new String(out);
        return rslt;
    }
}

