/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.CharsetEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import jeus.server.manager.JeusVersion;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.io.BufferedOutputAdaptor;
import jeus.servlet.engine.io.ChunkedOutputAdaptor;
import jeus.servlet.engine.io.FullBufferedOutputAdaptor;
import jeus.servlet.engine.io.HeadOutputAdaptor;
import jeus.servlet.engine.io.Http09OutputAdaptor;
import jeus.servlet.engine.io.ProtocolOutputAdaptor;
import jeus.servlet.engine.io.ResponseHeaderInfo;
import jeus.servlet.engine.io.ServletOutputStreamWriter;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer2;

public abstract class WebServerOutputStream
extends ServletOutputStream {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    static final int DEFAULT_HEADER_BUF_SIZE = 1024;
    static final int DEFAULT_BUF_SIZE = 8192;
    protected static final String serverInfo = "Jeus WebContainer/" + JeusVersion.getVersion();
    protected HttpServletRequestImpl request = null;
    protected HttpServletResponseImpl response = null;
    protected ProtocolOutputAdaptor adaptor = null;
    protected OutputStream out = null;
    protected boolean forceFullBuffering = false;
    protected boolean bufferedMode = false;
    protected SimpleDateFormat dateHeaderFormat = null;
    protected Calendar calendar = null;
    protected byte[] httpHeader;
    protected byte[] httpBody;
    protected boolean keepAlive = false;
    protected byte[] urgentMessage;
    private ServletOutputStreamWriter muxedWriter;
    protected ChunkedOutputAdaptor chunkedAdaptor;
    protected BufferedOutputAdaptor bufferedAdaptor;
    protected FullBufferedOutputAdaptor fullBufferedAdaptor;
    protected HeadOutputAdaptor headAdaptor;
    protected Http09OutputAdaptor http09Adaptor;
    private boolean forwardFlushPhase = false;
    private byte[] defaultHttpBody;
    protected boolean finalFlush = false;

    protected WebServerOutputStream(OutputStream out, int bufsize) {
        this.out = out;
        this.muxedWriter = null;
        Locale loc = Locale.US;
        TimeZone zone = TimeZone.getTimeZone("GMT");
        this.calendar = new GregorianCalendar(zone, loc);
        String pattern = "EEE, dd MMM yyyy HH:mm:ss z";
        this.dateHeaderFormat = new SimpleDateFormat(pattern, loc);
        this.dateHeaderFormat.setTimeZone(zone);
        int initBodyBufferSize = 0;
        if (bufsize > 0) {
            initBodyBufferSize = bufsize;
            if (initBodyBufferSize < 1024) {
                initBodyBufferSize = 1024;
            }
        } else if (bufsize == 0) {
            initBodyBufferSize = 8192;
            this.forceFullBuffering = true;
        } else {
            initBodyBufferSize = 8192;
        }
        this.httpHeader = new byte[1024];
        this.httpBody = new byte[initBodyBufferSize];
        this.defaultHttpBody = this.httpBody;
    }

    public ProtocolOutputAdaptor getAdaptor() {
        return this.adaptor;
    }

    protected void initializeAdaptor() {
        this.chunkedAdaptor = new ChunkedOutputAdaptor(this.out, this, this.httpHeader, this.httpBody);
        this.bufferedAdaptor = new BufferedOutputAdaptor(this.out, this, this.httpHeader, this.httpBody);
        this.fullBufferedAdaptor = new FullBufferedOutputAdaptor(this.out, this, this.httpHeader, this.httpBody);
        this.headAdaptor = new HeadOutputAdaptor(this.out, this, this.httpHeader, this.httpBody);
        this.http09Adaptor = new Http09OutputAdaptor(this.out, this, this.httpHeader, this.httpBody);
    }

    public void setUrgentMessage(byte[] msg) {
        this.urgentMessage = msg;
    }

    public void sendUrgentMessage() {
        if (this.urgentMessage != null && this.out != null) {
            try {
                this.out.write(this.urgentMessage);
                this.out.flush();
                this.urgentMessage = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public byte[] resizeHttpHeader(int newsize) {
        this.httpHeader = new byte[newsize];
        return this.httpHeader;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setRequestAndResponse(HttpServletRequestImpl request, HttpServletResponseImpl response) {
        this.request = request;
        this.response = response;
    }

    public void selectOutputAdaptor() throws IOException {
        if (this.request == null || this.response == null) {
            throw new IOException("both request and response must be set");
        }
        if (this.adaptor != null) {
            return;
        }
        String method = this.request.getMethod();
        if (method == null) {
            this.adaptor = this.fullBufferedAdaptor;
            this.bufferedMode = false;
        } else if (method.equals("HEAD")) {
            this.adaptor = this.headAdaptor;
            this.bufferedMode = false;
        } else {
            switch (this.request.getProtocolInt()) {
                case 9: {
                    this.adaptor = this.http09Adaptor;
                    this.bufferedMode = false;
                    break;
                }
                case 10: {
                    if (this.forceFullBuffering) {
                        this.adaptor = this.fullBufferedAdaptor;
                        this.bufferedMode = false;
                        break;
                    }
                    int contentLength = this.response.getContentLength();
                    if (contentLength != -1) {
                        this.adaptor = this.bufferedAdaptor;
                        this.bufferedMode = true;
                        this.adaptor.setMaxContentLength(contentLength);
                        break;
                    }
                    if (WebProperties.J2EE_COMPATIBLE.value) {
                        this.adaptor = this.bufferedAdaptor;
                        this.bufferedMode = true;
                        break;
                    }
                    this.adaptor = this.fullBufferedAdaptor;
                    this.bufferedMode = false;
                    break;
                }
                case 11: {
                    if (this.forceFullBuffering) {
                        this.adaptor = this.fullBufferedAdaptor;
                        this.bufferedMode = false;
                        break;
                    }
                    int contentLength = this.response.getContentLength();
                    if (contentLength != -1) {
                        this.adaptor = this.bufferedAdaptor;
                        this.bufferedMode = true;
                        this.adaptor.setMaxContentLength(contentLength);
                        break;
                    }
                    int statusCode = this.response.getStatus();
                    if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
                        this.adaptor = this.bufferedAdaptor;
                        this.bufferedMode = true;
                        break;
                    }
                    this.adaptor = this.chunkedAdaptor;
                    this.bufferedMode = true;
                    break;
                }
                default: {
                    this.adaptor = this.fullBufferedAdaptor;
                    this.bufferedMode = false;
                }
            }
        }
        if (this.adaptor == null) {
            throw new IOException("adaptor must be initialized");
        }
        this.ensureUserBody();
        this.adaptor.setOutputStream(this.out);
    }

    protected void ensureUserBody() {
        if (this.httpBody != this.defaultHttpBody) {
            this.adaptor.setBodyBuffer(this.httpBody);
        }
    }

    public int getContentCount() {
        if (this.adaptor != null) {
            return this.adaptor.getContentCount();
        }
        return 0;
    }

    public int getBufferSize() {
        if (this.adaptor != null) {
            return this.adaptor.getBufferSize();
        }
        return this.httpBody.length;
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (WebProperties.J2EE_COMPATIBLE.value && this.adaptor != null && !this.adaptor.isEmpty()) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3425);
            throw new IllegalStateException(msg);
        }
        if (size <= this.httpBody.length) {
            return;
        }
        if (!WebProperties.J2EE_COMPATIBLE.value && this.adaptor != null && !this.adaptor.isEmpty()) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3425);
            throw new IllegalStateException(msg);
        }
        int size2 = this.roundup8k(size);
        this.httpBody = new byte[size2];
        if (this.adaptor != null) {
            this.adaptor.setBodyBuffer(this.httpBody);
        }
    }

    private int roundup8k(int size) {
        int eightK = 8192;
        if (size % eightK != 0) {
            size = (size / eightK + 1) * eightK;
        }
        return size;
    }

    public void setUsingWriter(ServletOutputStreamWriter writer) {
        WebProperties props = PropertyUtil.getContextProperties();
        if (props.ENSURE_CONTENT_ORDER.value) {
            this.muxedWriter = writer;
        }
    }

    private void ensureContentOrder() throws IOException {
        if (this.muxedWriter != null) {
            this.muxedWriter.flushBuffer();
        }
    }

    public ResponseHeaderInfo getResponseHeader() {
        return this.getResponseHeader(this.response.getResponseHeader());
    }

    protected ResponseHeaderInfo getResponseHeader(ResponseHeaderInfo headerInfo) {
        WebProperties props = PropertyUtil.getContextProperties();
        if (props.RESPONSE_HEADER_INCLUDE_SERVER_INFO.value) {
            headerInfo.setHeader("Server", serverInfo);
        }
        this.calendar.setTime(new Date(System.currentTimeMillis()));
        headerInfo.setHeader("Date", this.dateHeaderFormat.format(this.calendar.getTime()));
        switch (this.request.getConnectionHeaderInt()) {
            case 0: {
                int protocolInt = this.request.getProtocolInt();
                if (protocolInt == 10) {
                    headerInfo.setHeader("Connection", "close");
                    break;
                }
                if (protocolInt != 11 || this.keepAlive) break;
                headerInfo.setHeader("Connection", "close");
                break;
            }
            case 1: {
                if (this.response.errorSent() || !this.keepAlive) {
                    headerInfo.setHeader("Connection", "close");
                    break;
                }
                headerInfo.setHeader("Connection", "Keep-Alive");
                break;
            }
            case 2: {
                headerInfo.setHeader("Connection", "close");
                break;
            }
        }
        headerInfo.processResponseHeader();
        return headerInfo;
    }

    public void write(int i) throws IOException {
        this.selectOutputAdaptor();
        if (this.adaptor != null) {
            this.ensureContentOrder();
            this.adaptor.write(i);
        }
    }

    public void write(byte[] b) throws IOException {
        this.selectOutputAdaptor();
        if (this.adaptor != null) {
            this.ensureContentOrder();
            this.adaptor.write(b, 0, b.length);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.selectOutputAdaptor();
        if (this.adaptor != null) {
            this.ensureContentOrder();
            this.adaptor.write(b, off, len);
        }
    }

    public void write(char[] cbuf, int off, int len, CharsetEncoder ctb) throws IOException {
        this.selectOutputAdaptor();
        if (this.adaptor != null) {
            this.adaptor.write(cbuf, off, len, ctb);
        }
    }

    public void flush() throws IOException {
        this.selectOutputAdaptor();
        if (this.adaptor != null) {
            this.adaptor.flush(false, false);
        }
    }

    public final void beginForwardFlush() {
        this.forwardFlushPhase = true;
    }

    public final void endForwardFlush() {
        this.forwardFlushPhase = false;
    }

    public final void forceFlush() throws IOException {
        this.selectOutputAdaptor();
        if (this.adaptor != null) {
            this.adaptor.flush(!this.forwardFlushPhase, false);
        }
    }

    public void finalFlush() throws IOException {
        if (this.finalFlush) {
            return;
        }
        this.finalFlush = true;
        this.selectOutputAdaptor();
        if (this.adaptor != null) {
            this.adaptor.flush(true, true);
        }
    }

    public boolean isCommitted() {
        return this.adaptor != null && this.adaptor.isCommitted();
    }

    public void reset() throws IllegalStateException {
        if (this.muxedWriter != null) {
            this.muxedWriter.reset();
        }
        if (this.adaptor != null) {
            this.adaptor.reset();
        }
    }

    public void resetContent() throws IllegalStateException {
        if (this.adaptor != null) {
            this.adaptor.resetContent();
        }
    }

    public void finish() {
        this.bufferedMode = false;
        this.muxedWriter = null;
        if (this.adaptor != null) {
            this.adaptor.finish();
            this.adaptor = null;
        }
        this.httpBody = this.defaultHttpBody;
        if (!this.keepAlive) {
            this.webServerFinish();
        }
        this.keepAlive = false;
        this.finalFlush = false;
    }

    public void close() throws IOException {
        if (this.adaptor != null) {
            this.adaptor.closeBuffer();
        }
    }

    public void unclose() {
        if (this.adaptor != null) {
            this.adaptor.uncloseBuffer();
        }
        this.finalFlush = false;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive() {
        this.keepAlive = true;
    }

    public void unsetKeepAlive() {
        this.keepAlive = false;
    }

    public abstract int getWebServerHeaderSize();

    public abstract void setWebServerHeader(boolean var1, int var2, int var3, byte[] var4);

    protected abstract void webServerFinish();

    public HttpServletRequestImpl getRequest() {
        return this.request;
    }
}

