/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.loader.JspReloader;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class JspServletWrapper
extends ServletWrapper {
    public static final String GENERATOR_VERSION = "_600_";
    public static String PKGNAME_PREFIX = "jeus_jspwork";
    public static boolean FILENAME_IGNORECASE = false;
    private int usedFlag = 0;

    public int getUsedFlag() {
        return this.usedFlag;
    }

    public JspServletWrapper(String jspName, ServletManager manager, JspReloader reloader) {
        super(jspName, manager, reloader, null);
        int currentUsedFlag = this.context.getVirtualHost().getContextGroup().getCurrentUsedFlag();
        this.usedFlag = currentUsedFlag == 0 ? 1 : 0;
    }

    public void setUsedFlag() {
        if (this.context.getVirtualHost().getContextGroup().getCheckJspWrapper()) {
            this.usedFlag = this.context.getVirtualHost().getContextGroup().getCurrentUsedFlag();
        }
    }

    public void executeServlet(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String requestURI = ((HttpServletRequest)request).getRequestURI();
        Servlet copy = null;
        try {
            copy = this.reloader.getServlet();
            if (RequestUtil.isJspPreCompile(request)) {
                return;
            }
            long serviceStartTime = 0L;
            if (this.serviceTimeStat != null) {
                serviceStartTime = System.currentTimeMillis();
            }
            copy.service(request, response);
            if (this.serviceTimeStat != null) {
                this.serviceTimeStat.addData(System.currentTimeMillis() - serviceStartTime);
            }
        }
        catch (ServletException se) {
            ((JspReloader)this.reloader).renameCorruptedClassFile(se.getRootCause());
            if (logger.isLoggable(JeusMessage_WebContainer5_4._5456_LEVEL)) {
                logger.log(JeusMessage_WebContainer5_4._5456_LEVEL, JeusMessage_WebContainer5_4._5456, (Object)this.servletName, (Throwable)se);
            }
            throw se;
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_WebContainer5_4._5456_LEVEL)) {
                logger.log(JeusMessage_WebContainer5_4._5456_LEVEL, JeusMessage_WebContainer5_4._5456, (Object)this.servletName, (Throwable)ioe);
            }
            throw ioe;
        }
        catch (Throwable t) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5456, (Object)this.servletName);
            if (logger.isLoggable(JeusMessage_WebContainer5_4._5456_LEVEL)) {
                logger.log(JeusMessage_WebContainer5_4._5456_LEVEL, JeusMessage_WebContainer5_4._5456, (Object)this.servletName, t);
            }
            throw new ServletException(msg, t);
        }
        finally {
            this.reloader.putServlet(copy);
        }
        ++this.numTotalRequests;
    }

    public void execute(HttpServletRequestImpl request, HttpServletResponseImpl response) throws ServletException, IOException {
        if (this.context.getVirtualHost().getContextGroup().getCheckJspWrapper()) {
            this.usedFlag = this.context.getVirtualHost().getContextGroup().getCurrentUsedFlag();
        }
        super.execute(request, response);
    }

    public void batchCompile(HttpServletRequestImpl request) throws ServletException {
        ((JspReloader)this.reloader).batchCompile();
    }

    static {
        FILENAME_IGNORECASE = System.getProperty("os.name").startsWith("Windows");
        WebProperties props = PropertyUtil.getContextProperties();
        if (props.JSP_NO_PACKAGE_PREFIX.value) {
            PKGNAME_PREFIX = null;
        }
    }
}

