/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;
import jeus.servlet.engine.io.ServletOutputStreamWriter;
import jeus.servlet.engine.io.ServletPrintWriter;
import jeus.servlet.engine.io.ServletStreamWriter;
import jeus.servlet.engine.io.UnbufferedServletStreamWriter;
import jeus.servlet.engine.io.WrappedServletStreamWriter;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class JspWriterImpl
extends JspWriter {
    private ServletStreamWriter out;
    private ServletResponse response;
    private boolean isClosed = false;

    public JspWriterImpl(ServletResponse response) {
        this(response, 8192, true);
    }

    public JspWriterImpl(ServletResponse response, int sz, boolean autoFlush) {
        super(sz, autoFlush);
        if (sz < 0) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5509));
        }
        this.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOut() throws IOException {
        if (this.out == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    PrintWriter w = this.response.getWriter();
                    if (this.bufferSize <= 0) {
                        this.out = new UnbufferedServletStreamWriter(w);
                    } else if (w instanceof ServletPrintWriter) {
                        this.out = ((ServletPrintWriter)w).getServletStreamWriter();
                        ((ServletOutputStreamWriter)this.out).jspInit(this.bufferSize);
                    } else {
                        this.out = new WrappedServletStreamWriter(w, this.bufferSize);
                    }
                }
            }
        }
    }

    private void ensureOpen() throws IOException {
        if (this.response == null) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5513));
        }
    }

    public void write(int c) throws IOException {
        this.ensureOpen();
        this.initOut();
        this.out.write(c, this.autoFlush);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        this.initOut();
        this.out.write(cbuf, off, len, this.autoFlush);
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(String s, int off, int len) throws IOException {
        this.ensureOpen();
        this.initOut();
        this.out.write(s, off, len, this.autoFlush);
    }

    public void write(String s) throws IOException {
        this.ensureOpen();
        this.initOut();
        this.out.write(s, this.autoFlush);
    }

    public void clear() throws IOException {
        this.ensureOpen();
        if (this.out != null) {
            this.out.clear();
        }
    }

    public void clearBuffer() throws IOException {
        this.ensureOpen();
        if (this.out != null) {
            this.out.clearBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.response == null) {
                return;
            }
            this.flush();
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
            this.response = null;
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5356));
            }
            if (this.out != null) {
                this.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.initOut();
            this.out.newLine(this.autoFlush);
        }
    }

    public void print(boolean b) throws IOException {
        this.write(b ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.write(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) throws IOException {
        this.write(s);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            WebProperties props = PropertyUtil.getContextProperties();
            s = props.JSP_JSPWRITER_DEFAULT_NULL_STRING.value;
        }
        this.write(s);
    }

    public void print(Object obj) throws IOException {
        if (obj == null) {
            WebProperties props = PropertyUtil.getContextProperties();
            this.write(props.JSP_JSPWRITER_DEFAULT_NULL_STRING.value);
        } else {
            this.write(String.valueOf(obj));
        }
    }

    public void println() throws IOException {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemaining() {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return this.bufferSize;
            }
            int used = this.out.getUsed();
            return this.bufferSize - used;
        }
    }

    public ServletStreamWriter getUnderlyingStream() {
        return this.out;
    }
}

