/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.logging.Level;
import javax.el.ELContext;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.JspIncludeResponseWrapper;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.engine.io.ServletStreamWriter;
import jeus.servlet.engine.io.WrappedServletStreamWriter;
import jeus.servlet.jsp.BodyContentImpl;
import jeus.servlet.jsp.JspWriterImpl;
import jeus.servlet.jsp.el.ExpressionEvaluatorImpl;
import jeus.servlet.jsp.el.VariableResolverImpl;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.servlet.util.FileUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

public final class PageContextImpl
extends PageContext
implements VariableResolver {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    private Servlet servlet;
    private ServletConfig config;
    private ServletContext context;
    private JspFactory factory;
    private boolean needsSession;
    private String errorPageURL;
    private boolean autoFlush;
    private int bufferSize;
    private transient Hashtable attributes = new Hashtable(16);
    private VariableResolverImpl variableResolver;
    private ExpressionEvaluatorImpl elExprEval = new ExpressionEvaluatorImpl(false);
    private transient ServletRequest request;
    private transient ServletResponse response;
    private transient Object page;
    private transient HttpSession session;
    private transient JspWriter out;
    Stack writerStack = new Stack();

    PageContextImpl(JspFactory factory) {
        this.factory = factory;
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.needsSession = needsSession;
        this.errorPageURL = errorPageURL;
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
        this.request = request;
        this.response = response;
        this.variableResolver = new VariableResolverImpl(this);
        if (request instanceof HttpServletRequest && needsSession) {
            this.session = ((HttpServletRequest)request).getSession();
        }
        if (needsSession && this.session == null) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5514));
        }
        this.out = this._createOut(bufferSize, autoFlush);
        if (this.out == null) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5515));
        }
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", request);
        this.setAttribute("javax.servlet.jsp.jspResponse", response);
        if (this.session != null) {
            this.setAttribute("javax.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("javax.servlet.jsp.jspPage", servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.config);
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.context);
    }

    public void release() {
        block3: {
            try {
                ServletStreamWriter sw = ((JspWriterImpl)this.out).getUnderlyingStream();
                if (sw != null) {
                    sw.flushBuffer();
                }
            }
            catch (Exception ioe) {
                if (!logger.isLoggable(JeusMessage_WebContainer5._5330_LEVEL)) break block3;
                logger.log(JeusMessage_WebContainer5._5330_LEVEL, JeusMessage_WebContainer5._5330, (Throwable)ioe);
            }
        }
        this.servlet = null;
        this.config = null;
        this.context = null;
        this.needsSession = false;
        this.errorPageURL = null;
        this.bufferSize = -1;
        this.autoFlush = true;
        this.request = null;
        this.response = null;
        this.out = null;
        this.session = null;
        this.attributes.clear();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                return this.attributes.get(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5516));
                }
                return this.session.getAttribute(name);
            }
            case 4: {
                return this.context.getAttribute(name);
            }
        }
        throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5517, (Object)String.valueOf(scope)));
    }

    public void setAttribute(String name, Object attribute) {
        if (name == null) {
            if (WebProperties.J2EE_COMPATIBLE.value) {
                throw new NullPointerException();
            }
            return;
        }
        if (attribute == null) {
            this.attributes.remove(name);
            return;
        }
        this.attributes.put(name, attribute);
    }

    public void setAttribute(String name, Object o, int scope) {
        if (name == null) {
            if (WebProperties.J2EE_COMPATIBLE.value) {
                throw new NullPointerException();
            }
            return;
        }
        switch (scope) {
            case 1: {
                if (o == null) {
                    this.attributes.remove(name);
                    break;
                }
                this.attributes.put(name, o);
                break;
            }
            case 2: {
                if (o == null) {
                    this.request.removeAttribute(name);
                    break;
                }
                this.request.setAttribute(name, o);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5516));
                }
                if (o == null) {
                    this.session.removeAttribute(name);
                    break;
                }
                this.session.setAttribute(name, o);
                break;
            }
            case 4: {
                if (o == null) {
                    this.context.removeAttribute(name);
                    break;
                }
                this.context.setAttribute(name, o);
                break;
            }
            default: {
                if (!WebProperties.J2EE_COMPATIBLE.value) break;
                throw new IllegalArgumentException();
            }
        }
    }

    public void removeAttribute(String name, int scope) {
        if (name == null) {
            if (WebProperties.J2EE_COMPATIBLE.value) {
                throw new NullPointerException();
            }
            return;
        }
        switch (scope) {
            case 1: {
                this.attributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5516));
                }
                this.session.removeAttribute(name);
                break;
            }
            case 4: {
                this.context.removeAttribute(name);
                break;
            }
            default: {
                if (!WebProperties.J2EE_COMPATIBLE.value) break;
                throw new IllegalArgumentException();
            }
        }
    }

    public int getAttributesScope(String name) {
        if (this.attributes.get(name) != null) {
            return 1;
        }
        if (this.request.getAttribute(name) != null) {
            return 2;
        }
        if (this.session != null && this.session.getAttribute(name) != null) {
            return 3;
        }
        if (this.context.getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    public Object findAttribute(String name) {
        Object o = this.attributes.get(name);
        if (o != null) {
            return o;
        }
        o = this.request.getAttribute(name);
        if (o != null) {
            return o;
        }
        if (this.session != null && (o = this.session.getAttribute(name)) != null) {
            return o;
        }
        return this.context.getAttribute(name);
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return this.attributes.keys();
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session != null) {
                    return this.session.getAttributeNames();
                }
                throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5516));
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        if (WebProperties.J2EE_COMPATIBLE.value) {
            throw new IllegalArgumentException();
        }
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    public void removeAttribute(String name) {
        if (name == null) {
            if (WebProperties.J2EE_COMPATIBLE.value) {
                throw new NullPointerException();
            }
            return;
        }
        try {
            this.removeAttribute(name, 1);
            this.removeAttribute(name, 2);
            this.removeAttribute(name, 3);
            this.removeAttribute(name, 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JspWriter getOut() {
        return this.out;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.elExprEval;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        return (Exception)this.request.getAttribute("javax.servlet.jsp.jspException");
    }

    public Object getPage() {
        return this.servlet;
    }

    private final String getAbsolutePathRelativeToContext(String relativeUrlPath) {
        String path = relativeUrlPath;
        if (!path.startsWith("/")) {
            String uri = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
            if (uri == null) {
                uri = ((HttpServletRequest)this.request).getServletPath();
            }
            path = FileUtil.catPath(uri, path);
        }
        return path;
    }

    public void include(String relativeUrlPath) throws ServletException, IOException {
        this.include(relativeUrlPath, false);
    }

    public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        if (this.out instanceof JspWriterImpl) {
            WebProperties props = PropertyUtil.getContextProperties();
            if (props.JSP_INCLUDE_FLUSH_ENABLE.value && flush) {
                this.out.flush();
                this.response.flushBuffer();
            } else {
                ServletStreamWriter sw = ((JspWriterImpl)this.out).getUnderlyingStream();
                if (sw != null && sw instanceof WrappedServletStreamWriter) {
                    sw.flushBuffer();
                }
            }
        }
        String path = this.getAbsolutePathRelativeToContext(relativeUrlPath);
        this.context.getRequestDispatcher(path).include(this.request, (ServletResponse)new JspIncludeResponseWrapper(this.response));
    }

    public void forward(String relativeUrlPath) throws ServletException, IOException {
        String path = this.getAbsolutePathRelativeToContext(relativeUrlPath);
        this.context.getRequestDispatcher(path).forward(this.request, this.response);
    }

    public JspWriter pushBody(Writer writer) {
        JspWriter previous = this.out;
        this.writerStack.push(this.out);
        this.out = new BodyContentImpl(this.out);
        BodyContentImpl bcImpl = new BodyContentImpl(this.out);
        bcImpl.setWriter(writer);
        this.out = bcImpl;
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return (BodyContent)this.out;
    }

    public BodyContent pushBody() {
        JspWriter previous = this.out;
        this.writerStack.push(this.out);
        this.out = new BodyContentImpl(previous);
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return (BodyContent)this.out;
    }

    public JspWriter popBody() {
        this.out = (JspWriter)this.writerStack.pop();
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return this.out;
    }

    public void handlePageException(Throwable t) throws ServletException, IOException {
        if (t == null) {
            throw new NullPointerException("handlePageException : argument is null");
        }
        this.request.setAttribute("javax.servlet.jsp.jspException", (Object)t);
        this.request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
        this.request.setAttribute("javax.servlet.error.request_uri", (Object)((HttpServletRequest)this.request).getRequestURI());
        this.handlePageException0(t);
    }

    public void handlePageException(Exception e) throws IOException, ServletException {
        if (e == null) {
            throw new NullPointerException("handlePageException : argument is null");
        }
        this.request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
        this.request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
        this.request.setAttribute("javax.servlet.error.request_uri", (Object)((HttpServletRequest)this.request).getRequestURI());
        this.handlePageException0(e);
    }

    private void handlePageException0(Throwable t) throws IOException, ServletException {
        Context ctx;
        if (logger.isLoggable(Level.FINE)) {
            t.printStackTrace();
        }
        if (this.checkErrorPage(ctx = (Context)this.context)) {
            if (logger.isLoggable(JeusMessage_WebContainer5_4._5456_LEVEL)) {
                logger.log(JeusMessage_WebContainer5_4._5456_LEVEL, JeusMessage_WebContainer5_4._5456, (Object)this.config.getServletName(), t);
            }
        } else {
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof JspException) {
                Throwable rc = ((JspException)t).getRootCause();
                Throwable xx = t;
                if (rc != null) {
                    xx = rc;
                }
                throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5456, (Object)this.config.getServletName()), xx);
            }
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5456, (Object)this.config.getServletName()), t);
        }
        this.forward(this.errorPageURL);
    }

    private boolean checkErrorPage(Context ctx) {
        if (this.errorPageURL == null || this.errorPageURL.equals("")) {
            return false;
        }
        this.errorPageURL = this.getAbsolutePathRelativeToContext(this.errorPageURL);
        ServletWrapper wrapper = ctx.getServletByName(this.errorPageURL);
        if (wrapper == null) {
            return true;
        }
        String errorPageServletClassName = wrapper.getReloader().getClassName();
        return !errorPageServletClassName.equals(this.servlet.getClass().getName());
    }

    private JspWriter _createOut(int bufferSize, boolean autoFlush) throws IOException, IllegalArgumentException {
        return new JspWriterImpl(this.response, bufferSize, autoFlush);
    }

    public VariableResolver getVariableResolver() {
        return this;
    }

    public Object resolveVariable(String s) throws ELException {
        return this.variableResolver.resolveVariable(s);
    }

    public ELContext getELContext() {
        return null;
    }
}

