/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import jeus.servlet.engine.Context;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.TagInfoData;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.TagFileInfoImpl;
import jeus.servlet.jsp.compiler.TagLibraryInfoImpl;
import jeus.servlet.jsp.compiler.TagLibraryValidatorWrapper;
import jeus.servlet.listener.ListenerManager;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class TLDInfo {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    private String info;
    private String jspversion;
    private String shortname;
    private TagInfoData[] tagInfoData;
    private String tlibversion;
    private String uri;
    private String urn;
    private String displayName = null;
    private String smallIcon = null;
    private String largeIcon = null;
    private String validatorClass = null;
    private HashMap validatorParams = null;
    private boolean fromZipFile = false;
    private URL realLocation;
    private Document tld;
    private Context context;
    private String jarRelativePath;
    public FunctionInfo[] functionInfos;
    private ArrayList tagFileInfos;

    private TLDInfo(Context context, String realLocation, boolean fromZipFile) throws JspEngineException {
        this.context = context;
        if (realLocation != null) {
            try {
                this.realLocation = new URL("file:///localhost" + realLocation);
            }
            catch (MalformedURLException mue) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5498, (Object)realLocation), mue);
            }
        }
        this.fromZipFile = fromZipFile;
        this.tagFileInfos = new ArrayList();
    }

    TLDInfo(Context context, InputStream in, String realLocation, boolean fromZipFile, String _jarRelativePath) throws JspEngineException {
        this(context, realLocation, fromZipFile);
        this.jarRelativePath = _jarRelativePath;
        this.parseTLD(in);
    }

    TLDInfo(Context context, InputStream in, String realLocation, boolean fromZipFile) throws JspEngineException {
        this(context, realLocation, fromZipFile);
        this.parseTLD(in);
    }

    TLDInfo(Context context, String tagpath) throws JspEngineException {
        this(context, null, false);
        if (tagpath.endsWith("/")) {
            tagpath = tagpath.substring(0, tagpath.length() - 1);
        }
        if (tagpath.equals("/WEB-INF/tags")) {
            this.shortname = "tags";
        } else {
            int pos = "/WEB-INF/tags/".length();
            tagpath = tagpath.substring(pos);
            this.shortname = tagpath = tagpath.replace('/', '-');
        }
        this.jspversion = "2.0";
        this.tlibversion = "1.0";
        this.tagInfoData = new TagInfoData[0];
        this.functionInfos = new FunctionInfo[0];
    }

    public void clean() {
        this.tld = null;
        this.context = null;
        this.tagInfoData = null;
        this.functionInfos = null;
        if (this.validatorParams != null) {
            this.validatorParams.clear();
            this.validatorParams = null;
        }
        if (this.tagFileInfos != null) {
            this.tagFileInfos.clear();
            this.tagFileInfos = null;
        }
    }

    public void addTagFileInfo(TagFileInfo info) {
        this.tagFileInfos.add(info);
    }

    public boolean isFromZipFile() {
        return this.fromZipFile;
    }

    public URL getRealLocation() {
        return this.realLocation;
    }

    public String getInfo() {
        return this.info;
    }

    public String getJspversion() {
        return this.jspversion;
    }

    public String getShortname() {
        return this.shortname;
    }

    public String getTlibversion() {
        return this.tlibversion;
    }

    public String getURI() {
        return this.uri;
    }

    public String getURN() {
        return this.urn;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public FunctionInfo[] getFunctions() {
        return this.functionInfos;
    }

    public TagLibraryValidatorWrapper getTagLibraryValidator() throws JspEngineException {
        if (this.validatorClass == null) {
            return null;
        }
        TagLibraryValidatorWrapper validator = new TagLibraryValidatorWrapper(this.validatorClass, this.validatorParams);
        validator.init();
        return validator;
    }

    public TagFileInfoImpl[] getTagFileInfo(TagLibraryInfoImpl tli) {
        TagFileInfoImpl[] result = new TagFileInfoImpl[this.tagFileInfos.size()];
        Object[] tmp = this.tagFileInfos.toArray();
        for (int i = 0; i < this.tagFileInfos.size(); ++i) {
            result[i] = (TagFileInfoImpl)((Object)tmp[i]);
        }
        return result;
    }

    public TagInfo[] getTagInfo(TagLibraryInfoImpl tli) {
        TagInfo[] info = new TagInfo[this.tagInfoData.length];
        for (int i = 0; i < info.length; ++i) {
            TagExtraInfo tei;
            block8: {
                tei = null;
                String teiclass = this.tagInfoData[i].teiClassName;
                if (teiclass != null && !teiclass.equals("")) {
                    try {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        Class<?> teiClass = cl.loadClass(teiclass);
                        tei = (TagExtraInfo)teiClass.newInstance();
                    }
                    catch (ClassNotFoundException cex) {
                        if (logger.isLoggable(JeusMessage_WebContainer5_4._5623_LEVEL)) {
                            logger.log(JeusMessage_WebContainer5_4._5623_LEVEL, JeusMessage_WebContainer5_4._5623, (Object)teiclass, (Throwable)cex);
                        }
                    }
                    catch (IllegalAccessException iae) {
                        if (logger.isLoggable(JeusMessage_WebContainer5_4._5623_LEVEL)) {
                            logger.log(JeusMessage_WebContainer5_4._5623_LEVEL, JeusMessage_WebContainer5_4._5623, (Object)teiclass, (Throwable)iae);
                        }
                    }
                    catch (InstantiationException ie) {
                        if (!logger.isLoggable(JeusMessage_WebContainer5_4._5624_LEVEL)) break block8;
                        logger.log(JeusMessage_WebContainer5_4._5624_LEVEL, JeusMessage_WebContainer5_4._5624, (Object)teiclass, (Throwable)ie);
                    }
                }
            }
            info[i] = new TagInfo(this.tagInfoData[i].tagName, this.tagInfoData[i].tagClassName, this.tagInfoData[i].bodyContent, this.tagInfoData[i].infoString, (TagLibraryInfo)tli, tei, this.tagInfoData[i].attributeInfo, this.tagInfoData[i].displayName, this.tagInfoData[i].smallIcon, this.tagInfoData[i].largeIcon, this.tagInfoData[i].tvi, this.tagInfoData[i].dynamicAttributes);
        }
        return info;
    }

    private void parseTLD(InputStream in) throws JspEngineException {
        this.tld = JspUtil.parseXMLDoc(in, false);
        if (this.context.getContextProperties().JASPER.value) {
            this.parseTLDListener();
        } else {
            this.parseFullTLD();
        }
    }

    private void parseTLDListener() throws JspEngineException {
        NodeList list = this.tld.getElementsByTagName("listener");
        for (int i = 0; i < list.getLength(); ++i) {
            Node listener = list.item(i);
            this.createListener(listener);
        }
    }

    private void parseFullTLD() throws JspEngineException {
        Vector<TagInfoData> tagVector = new Vector<TagInfoData>();
        Vector<FunctionInfo> functionVector = new Vector<FunctionInfo>();
        NodeList list = this.tld.getElementsByTagName("taglib");
        if (list.getLength() != 1) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5611, (Object[])new String[]{this.uri, this.jarRelativePath}));
        }
        Element elem = (Element)list.item(0);
        list = elem.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Text t;
            Node e = list.item(i);
            if (!(e instanceof Element)) continue;
            String tname = e.getNodeName();
            if (tname.equals("tlibversion")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.tlibversion = t.getData().trim();
                continue;
            }
            if (tname.equals("jspversion")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.jspversion = t.getData().trim();
                continue;
            }
            if (tname.equals("shortname")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.shortname = t.getData().trim();
                continue;
            }
            if (tname.equals("urn")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.urn = t.getData().trim();
                continue;
            }
            if (tname.equals("info")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.info = t.getData().trim();
                continue;
            }
            if (tname.equals("tag")) {
                tagVector.addElement(this.createTagInfoData(e));
                continue;
            }
            if (tname.equals("tlib-version")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.tlibversion = t.getData().trim();
                continue;
            }
            if (tname.equals("jsp-version")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.jspversion = t.getData().trim();
                continue;
            }
            if (tname.equals("short-name")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.shortname = t.getData().trim();
                continue;
            }
            if (tname.equals("uri")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.uri = t.getData().trim();
                continue;
            }
            if (tname.equals("display-name")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.displayName = t.getData().trim();
                continue;
            }
            if (tname.equals("small-icon")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.smallIcon = t.getData().trim();
                continue;
            }
            if (tname.equals("large-icon")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.largeIcon = t.getData().trim();
                continue;
            }
            if (tname.equals("description")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.info = t.getData().trim();
                continue;
            }
            if (tname.equals("validator")) {
                this.initTagLibraryValidator(e);
                continue;
            }
            if (tname.equals("listener")) {
                this.createListener(e);
                continue;
            }
            if (tname.equals("tag-file")) {
                this.createTagFileInfo(e);
                continue;
            }
            if (tname.equals("function")) {
                functionVector.addElement(this.createFunctionInfo(e));
                continue;
            }
            if (!logger.isLoggable(JeusMessage_WebContainer5_4._5621_LEVEL)) continue;
            logger.log(JeusMessage_WebContainer5_4._5621_LEVEL, JeusMessage_WebContainer5_4._5621, (Object[])new String[]{e.getNodeName(), this.jarRelativePath});
        }
        this.tagInfoData = new TagInfoData[tagVector.size()];
        tagVector.copyInto(this.tagInfoData);
        this.functionInfos = new FunctionInfo[functionVector.size()];
        functionVector.copyInto(this.functionInfos);
    }

    private void createListener(Node elem) throws JspEngineException {
        ListenerManager listenerManager;
        String className = null;
        NodeList list = elem.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Text t;
            Node e = list.item(i);
            String tname = e.getNodeName();
            if (!tname.equals("listener-class") || (t = (Text)e.getFirstChild()) == null) continue;
            className = t.getData().trim();
        }
        if (className == null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5612, (Object)this.jarRelativePath));
        }
        if (this.context != null && (listenerManager = this.context.getListenerManager()) != null) {
            listenerManager.addTldListener(className);
        }
    }

    private void initTagLibraryValidator(Node elem) throws JspEngineException {
        this.validatorParams = new HashMap();
        String paramName = null;
        String paramValue = null;
        NodeList list = elem.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node e = list.item(i);
            String tname = e.getNodeName();
            if (tname.equals("validator-class")) {
                Text t = (Text)e.getFirstChild();
                if (t == null) continue;
                this.validatorClass = t.getData().trim();
                continue;
            }
            if (!tname.equals("init-param")) continue;
            paramName = null;
            paramValue = null;
            NodeList list2 = e.getChildNodes();
            for (int j = 0; j < list2.getLength(); ++j) {
                Text t2;
                Node e2 = list2.item(j);
                String tname2 = e2.getNodeName();
                if (tname2.equals("param-name")) {
                    t2 = (Text)e2.getFirstChild();
                    if (t2 == null) continue;
                    paramName = t2.getData().trim();
                    continue;
                }
                if (!tname2.equals("param-value") || (t2 = (Text)e2.getFirstChild()) == null) continue;
                paramValue = t2.getData().trim();
            }
            if (paramName == null || paramValue == null) continue;
            this.validatorParams.put(paramName, paramValue);
        }
        if (this.validatorClass == null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5613, (Object)this.jarRelativePath));
        }
    }

    private void createTagFileInfo(Node elem) throws JspEngineException {
        NodeList list = elem.getChildNodes();
        String name = null;
        String path = null;
        TagFileInfoImpl _tagFile = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Text t;
            Node e = list.item(i);
            if (!(e instanceof Element)) continue;
            String tname = e.getNodeName();
            if (tname.equals("name")) {
                t = TLDInfo.getFirstTextChild(e);
                if (t == null) continue;
                name = t.getData().trim();
                continue;
            }
            if (!tname.equals("path") || (t = TLDInfo.getFirstTextChild(e)) == null) continue;
            path = t.getData().trim();
        }
        if (path != null && name != null) {
            _tagFile = new TagFileInfoImpl(name, path, null, this.context, this.jarRelativePath);
            this.tagFileInfos.add(_tagFile);
        }
    }

    private static Text getFirstTextChild(Node _elem) {
        if (_elem == null) {
            return null;
        }
        NodeList list = _elem.getChildNodes();
        int _length = list.getLength();
        for (int i = 0; i < _length; ++i) {
            Node e = list.item(i);
            if (!(e instanceof Text)) continue;
            return (Text)e;
        }
        return null;
    }

    private FunctionInfo createFunctionInfo(Node elem) throws JspEngineException {
        String name = null;
        String function_class = null;
        String function_signature = null;
        NodeList list = elem.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Text t;
            Node e = list.item(i);
            if (!(e instanceof Element)) continue;
            String tname = e.getNodeName();
            if (tname.equals("name")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                name = t.getData().trim();
                continue;
            }
            if (tname.equals("function-class")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                function_class = t.getData().trim();
                continue;
            }
            if (tname.equals("function-signature")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                function_signature = t.getData().trim();
                continue;
            }
            if (tname.equals("description") || tname.equals("example") || !logger.isLoggable(JeusMessage_WebContainer5_4._5622_LEVEL)) continue;
            logger.log(JeusMessage_WebContainer5_4._5622_LEVEL, JeusMessage_WebContainer5_4._5622, (Object[])new String[]{tname, this.jarRelativePath});
        }
        return new FunctionInfo(name, function_class, function_signature);
    }

    private TagInfoData createTagInfoData(Node elem) throws JspEngineException {
        String name = null;
        String tagclass = null;
        String teiclass = null;
        String bodycontent = "JSP";
        String info = null;
        String displayName = null;
        String smallIcon = null;
        String largeIcon = null;
        boolean dynamicAttributes = false;
        Vector<TagAttributeInfo> attributeVector = new Vector<TagAttributeInfo>();
        Vector<TagVariableInfo> variableVector = new Vector<TagVariableInfo>();
        NodeList list = elem.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Text t;
            Node e = list.item(i);
            if (!(e instanceof Element)) continue;
            String tname = e.getNodeName();
            if (tname.equals("name")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                name = t.getData().trim();
                continue;
            }
            if (tname.equals("tagclass")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                tagclass = t.getData().trim();
                continue;
            }
            if (tname.equals("teiclass")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                teiclass = t.getData().trim();
                continue;
            }
            if (tname.equals("bodycontent")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                bodycontent = t.getData().trim();
                continue;
            }
            if (tname.equals("info")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                info = t.getData().trim();
                continue;
            }
            if (tname.equals("attribute")) {
                attributeVector.addElement(this.createAttribute(e));
                continue;
            }
            if (tname.equals("tag-class")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                tagclass = t.getData().trim();
                continue;
            }
            if (tname.equals("tei-class")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                teiclass = t.getData().trim();
                continue;
            }
            if (tname.equals("body-content")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                bodycontent = t.getData().trim();
                continue;
            }
            if (tname.equals("display-name")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                displayName = t.getData().trim();
                continue;
            }
            if (tname.equals("small-icon")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                smallIcon = t.getData().trim();
                continue;
            }
            if (tname.equals("large-icon")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                largeIcon = t.getData().trim();
                continue;
            }
            if (tname.equals("description")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                info = t.getData().trim();
                continue;
            }
            if (tname.equals("variable")) {
                variableVector.addElement(this.createVariable(name, e));
                continue;
            }
            if (tname.equals("dynamic-attributes")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                dynamicAttributes = Boolean.valueOf(t.getData().trim());
                continue;
            }
            if (tname.equals("example") || !logger.isLoggable(JeusMessage_WebContainer5_4._5622_LEVEL)) continue;
            logger.log(JeusMessage_WebContainer5_4._5622_LEVEL, JeusMessage_WebContainer5_4._5622, (Object[])new String[]{tname, this.jarRelativePath});
        }
        Object[] tagAttributeInfo = new TagAttributeInfo[attributeVector.size()];
        attributeVector.copyInto(tagAttributeInfo);
        Object[] tagVariableInfo = new TagVariableInfo[variableVector.size()];
        variableVector.copyInto(tagVariableInfo);
        return new TagInfoData(name, tagclass, bodycontent, info, teiclass, (TagAttributeInfo[])tagAttributeInfo, displayName, smallIcon, largeIcon, (TagVariableInfo[])tagVariableInfo, dynamicAttributes, null);
    }

    TagVariableInfo createVariable(String tagName, Node elem) throws JspEngineException {
        String nameGiven = null;
        String nameFromAttribute = null;
        String className = "java.lang.String";
        boolean declare = true;
        int scope = 0;
        NodeList list = elem.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String v;
            Text t;
            Node e = list.item(i);
            if (e instanceof Text) continue;
            String tname = e.getNodeName();
            if (tname.equals("name-given")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                nameGiven = t.getData().trim();
                continue;
            }
            if (tname.equals("name-from-attribute")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                nameFromAttribute = t.getData().trim();
                continue;
            }
            if (tname.equals("variable-class")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                className = t.getData().trim();
                continue;
            }
            if (tname.equals("declare")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                v = t.getData().trim();
                if (v.equals("false")) {
                    declare = false;
                    continue;
                }
                declare = true;
                continue;
            }
            if (tname.equals("scope")) {
                t = (Text)e.getFirstChild();
                if (t == null || (v = t.getData()) == null) continue;
                if (v.equals("AT_BEGIN")) {
                    scope = 1;
                    continue;
                }
                if (v.equals("AT_END")) {
                    scope = 2;
                    continue;
                }
                if (v.equals("NESTED")) {
                    scope = 0;
                    continue;
                }
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5357, (Object[])new Object[]{t, this.jarRelativePath}));
            }
            if (tname.equals("description") || !logger.isLoggable(JeusMessage_WebContainer5_4._5625_LEVEL)) continue;
            logger.log(JeusMessage_WebContainer5_4._5625_LEVEL, JeusMessage_WebContainer5_4._5625, (Object[])new String[]{tname, this.jarRelativePath});
        }
        if (!(nameGiven != null && nameGiven != "" || nameFromAttribute != null && nameFromAttribute != "")) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5614, (Object[])new String[]{tagName, this.jarRelativePath}));
        }
        if (nameGiven != null && nameGiven != "" && nameFromAttribute != null && nameFromAttribute != "") {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5615, (Object[])new String[]{tagName, this.jarRelativePath}));
        }
        return new TagVariableInfo(nameGiven, nameFromAttribute, className, declare, scope);
    }

    TagAttributeInfo createAttribute(Node elem) {
        String name = null;
        boolean required = false;
        boolean rtexprvalue = false;
        boolean fragment = false;
        String type = null;
        NodeList list = elem.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Text t;
            Node e = list.item(i);
            if (e instanceof Text) continue;
            String tname = e.getNodeName();
            if (tname.equals("name")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                name = t.getData().trim();
                continue;
            }
            if (tname.equals("required")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                required = Boolean.valueOf(t.getData().trim());
                continue;
            }
            if (tname.equals("rtexprvalue")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                rtexprvalue = Boolean.valueOf(t.getData().trim());
                continue;
            }
            if (tname.equals("type")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                type = t.getData().trim();
                continue;
            }
            if (tname.equals("fragment")) {
                t = (Text)e.getFirstChild();
                if (t == null) continue;
                fragment = Boolean.valueOf(t.getData().trim());
                continue;
            }
            if (tname.equals("description") || tname.equals("deferred-value") || tname.equals("deferred-method") || !logger.isLoggable(JeusMessage_WebContainer5_4._5626_LEVEL)) continue;
            logger.log(JeusMessage_WebContainer5_4._5626_LEVEL, JeusMessage_WebContainer5_4._5626, (Object[])new String[]{tname, this.jarRelativePath});
        }
        return new TagAttributeInfo(name, required, type, rtexprvalue, fragment);
    }

    private final void print(String name, String value, PrintWriter w) {
        if (value != null) {
            w.print(name + " = {\n\t");
            w.print(value);
            w.print("\n}\n");
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.print("tlibversion", this.tlibversion, out);
        this.print("jspversion", this.jspversion, out);
        this.print("shortname", this.shortname, out);
        this.print("urn", this.urn, out);
        this.print("info", this.info, out);
        for (int i = 0; i < this.tagInfoData.length; ++i) {
            out.println(this.tagInfoData[i].toString());
        }
        return sw.toString();
    }
}

