/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.XmlCdataProcessor;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class DeclarationParser
extends Parser {
    private static final String OPEN_DECL = "<%!";
    private static final String CLOSE_DECL = "%>";
    private static final String XML_OPEN_DECL = "<jsp:declaration>";
    private static final String XML_CLOSE_DECL = "</jsp:declaration>";

    public DeclarationParser() {
    }

    public DeclarationParser(boolean _isInvalidated) {
        super(_isInvalidated);
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        boolean isJspDocument = xmlViewer == null;
        boolean isXMLDeclaration = false;
        if (reader.matches(OPEN_DECL)) {
            isXMLDeclaration = false;
            reader.advance(OPEN_DECL.length());
        } else if (reader.matches(XML_OPEN_DECL)) {
            isXMLDeclaration = true;
            reader.advance(XML_OPEN_DECL.length());
        } else {
            return false;
        }
        if (this.isInvalidated) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5681, (Object)XML_OPEN_DECL));
        }
        Mark start = reader.mark();
        Mark stop = null;
        char[] data = null;
        if (!isJspDocument) {
            stop = reader.skipUntil(isXMLDeclaration ? XML_CLOSE_DECL : CLOSE_DECL);
            if (stop == null) {
                throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)(isXMLDeclaration ? XML_CLOSE_DECL : CLOSE_DECL).substring(1)));
            }
            parser.flushCharData();
            xmlViewer.addDeclaration(reader, start, stop);
            data = reader.getChars(start, stop);
        } else {
            XmlCdataProcessor xcp = new XmlCdataProcessor(reader, isXMLDeclaration ? XML_OPEN_DECL : OPEN_DECL, isXMLDeclaration ? XML_CLOSE_DECL : CLOSE_DECL);
            data = xcp.process();
            parser.flushCharData();
            reader.skipSpaces();
        }
        DeclarationGenerator gen = new DeclarationGenerator(data, start, stop);
        codeGen.addGenerator(gen, "ClassDeclarationPhase");
        return true;
    }

    class DeclarationGenerator
    extends Generator {
        char[] chars;

        public DeclarationGenerator(char[] chars, Mark start, Mark stop) {
            this.start = start;
            this.stop = stop;
            this.chars = chars;
        }

        public boolean generate(ServletWriter writer, String phase) {
            writer.printMultiLn(new String(JspUtil.removeQuotes(this.chars)));
            return true;
        }
    }
}

