/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.HashMap;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

public final class ELFunctionParser {
    private Token curToken;
    private int index = 0;
    private String expression;
    private String defaultNamespace;
    private boolean escapeBS;
    private static final String[] reservedWords = new String[]{"and", "div", "empty", "eq", "false", "ge", "gt", "instanceof", "le", "lt", "mod", "ne", "not", "null", "or", "true"};

    private ELFunctionParser(String defaultNamespace, String expression) {
        this.defaultNamespace = defaultNamespace;
        this.expression = expression;
    }

    public static HashMap parseFunction(String defaultNamespace, String expression, boolean includeELOPEN) throws JspParseException {
        ELFunctionParser parser = new ELFunctionParser(defaultNamespace, expression);
        HashMap result = new HashMap();
        while (parser.hasNextChar()) {
            if (includeELOPEN) {
                parser.skipUntilEL();
            }
            parser.parseFunction(result);
        }
        return result;
    }

    private void parseFunction(HashMap result) throws JspParseException {
        while (this.hasNext()) {
            this.curToken = this.nextToken();
            if (this.curToken instanceof Char) {
                if (this.curToken.toChar() != '}') continue;
                break;
            }
            Function fn = this.parseFunction();
            if (fn == null) continue;
            result.put(fn.getFullName(), fn);
        }
    }

    private Function parseFunction() throws JspParseException {
        if (!(this.curToken instanceof Id) || this.isELReserved(this.curToken.toString())) {
            return null;
        }
        String s1 = null;
        String s2 = this.curToken.toString();
        if (this.hasNext()) {
            Token t2;
            Token t = this.nextToken();
            if (t.toChar() == ':' && this.hasNext() && (t2 = this.nextToken()) instanceof Id) {
                s1 = s2;
                s2 = t2.toString();
                if (this.hasNext()) {
                    t = this.nextToken();
                }
            }
            if (t.toChar() == '(') {
                if (this.defaultNamespace == null && s1 == null) {
                    throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5675, (Object)s2));
                }
                return new Function(s1, s2);
            }
        }
        return null;
    }

    private boolean isELReserved(String id) {
        int i = 0;
        int j = reservedWords.length;
        while (i < j) {
            int k = (i + j) / 2;
            int result = reservedWords[k].compareTo(id);
            if (result == 0) {
                return true;
            }
            if (result < 0) {
                i = k + 1;
                continue;
            }
            j = k;
        }
        return false;
    }

    private String skipUntilEL() {
        int prev = 0;
        StringBuffer buf = new StringBuffer();
        while (this.hasNextChar()) {
            int ch = this.nextChar();
            if (prev == 92) {
                prev = 0;
                if (ch == 92) {
                    buf.append('\\');
                    if (this.escapeBS) continue;
                    prev = 92;
                    continue;
                }
                if (ch != 36) continue;
                buf.append('$');
                continue;
            }
            if (prev == 36) {
                if (ch == 123) {
                    prev = 0;
                    break;
                }
                buf.append('$');
                buf.append((char)ch);
                continue;
            }
            if (ch == 92 || ch == 36) {
                prev = ch;
                continue;
            }
            buf.append((char)ch);
        }
        if (prev != 0) {
            buf.append((char)prev);
        }
        return buf.toString();
    }

    private boolean hasNext() {
        this.skipSpaces();
        return this.hasNextChar();
    }

    private Token nextToken() {
        this.skipSpaces();
        if (this.hasNextChar()) {
            char ch = this.nextChar();
            if (Character.isJavaIdentifierStart(ch)) {
                StringBuffer buf = new StringBuffer();
                buf.append(ch);
                while ((ch = this.peekChar()) != '\uffffffff' && Character.isJavaIdentifierPart(ch)) {
                    buf.append(ch);
                    this.nextChar();
                }
                return new Id(buf.toString());
            }
            if (ch == '\'' || ch == '\"') {
                return this.parseQuotedChars(ch);
            }
            return new Char(ch);
        }
        return null;
    }

    private Token parseQuotedChars(char quote) {
        StringBuffer buf = new StringBuffer();
        buf.append(quote);
        while (this.hasNextChar()) {
            char ch = this.nextChar();
            if (ch == '\\') {
                ch = this.nextChar();
                if (ch != '\\' && ch != quote) continue;
                buf.append(ch);
                continue;
            }
            if (ch == quote) {
                buf.append(ch);
                break;
            }
            buf.append(ch);
        }
        return new QuotedString(buf.toString());
    }

    private void skipSpaces() {
        while (this.hasNextChar() && this.expression.charAt(this.index) <= ' ') {
            ++this.index;
        }
    }

    private boolean hasNextChar() {
        return this.index < this.expression.length();
    }

    private char nextChar() {
        if (this.index >= this.expression.length()) {
            return '\uffff';
        }
        return this.expression.charAt(this.index++);
    }

    private char peekChar() {
        if (this.index >= this.expression.length()) {
            return '\uffff';
        }
        return this.expression.charAt(this.index);
    }

    private static class QuotedString
    extends Token {
        private String value;

        QuotedString(String v) {
            this.value = v;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class Char
    extends Token {
        private char ch;

        Char(char ch) {
            this.ch = ch;
        }

        char toChar() {
            return this.ch;
        }

        public String toString() {
            return new Character(this.ch).toString();
        }
    }

    private static class Id
    extends Token {
        String id;

        Id(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }

    private static class Token {
        private Token() {
        }

        char toChar() {
            return '\u0000';
        }

        public String toString() {
            return "";
        }
    }

    public class Function {
        public String prefix;
        public String functionName;

        public Function(String s1, String s2) {
            this.prefix = s1;
            this.functionName = s2;
            if (this.prefix == null) {
                this.prefix = ELFunctionParser.this.defaultNamespace;
            }
        }

        public String getFullName() {
            return this.prefix + ":" + this.functionName;
        }
    }
}

