/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Attribute;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.ExpressionEvaluatorParser;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspAttribute;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.JspattributeParser;
import jeus.servlet.jsp.compiler.JspbodyParser;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.StringAttribute;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class ElementParser
extends Parser {
    private static final String OPEN_ELEMENT = "<jsp:element";
    private static final String END_OPEN_ELEMENT = ">";
    private static final String CLOSE_ELEMENT = "</jsp:element>";
    private static final String[] validAttributes = new String[]{"name", "xmlns:jsp"};

    ElementParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        boolean isJspDocument = xmlViewer == null;
        String elementName = null;
        Hashtable elementAttributes = new Hashtable();
        Object elementBody = null;
        if (reader.matches(OPEN_ELEMENT)) {
            parser.flushCharData();
            Mark start = reader.mark();
            reader.advance(OPEN_ELEMENT.length());
            Hashtable attrs = reader.parseTagAttributes();
            reader.skipSpaces();
            boolean isSelfClosing = false;
            if (reader.matches("/>")) {
                reader.advance(2);
                isSelfClosing = true;
            }
            JspParser.checkAttributes("element", attrs.keys(), validAttributes);
            elementName = (String)attrs.get("name");
            if (elementName == null) {
                throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5373));
            }
            if (!isSelfClosing) {
                if (!reader.matches(END_OPEN_ELEMENT)) {
                    throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:element>"));
                }
                reader.advance(END_OPEN_ELEMENT.length());
                reader.skipSpaces();
                Hashtable<String, Attribute> jspAttributes = new Hashtable<String, Attribute>();
                Attribute jspAttribute = null;
                JspElementJspAttributeInfo rtmap = new JspElementJspAttributeInfo();
                while ((jspAttribute = JspattributeParser.parse(xmlViewer, reader, parser, codeGen, this, rtmap)) != null) {
                    jspAttributes.put(jspAttribute.attributeName, jspAttribute);
                }
                elementAttributes.putAll(jspAttributes);
                ElementGenerator gen = new ElementGenerator(elementName, elementAttributes, start, null, isJspDocument, codeGen);
                JspbodyParser.parse(this, xmlViewer, reader, parser, codeGen, gen, "jsp:element", null, null, jspAttributes.size() > 0);
                codeGen.addGenerator(gen, "ServiceMethodPhase");
                gen.stop = reader.mark();
                if (!isJspDocument) {
                    xmlViewer.addElement(reader, start, gen.stop);
                }
                parser.flushCharData();
                return true;
            }
            Mark stop = reader.mark();
            if (!isJspDocument) {
                xmlViewer.addElement(reader, start, stop);
            }
            parser.flushCharData();
            ElementGenerator gen = new ElementGenerator(elementName, elementAttributes, start, stop, isJspDocument, codeGen);
            codeGen.addGenerator(gen, "ServiceMethodPhase");
            return true;
        }
        return false;
    }

    class ElementGenerator
    extends Generator {
        private String name;
        private Hashtable attributes;
        private String ieClassId;
        boolean isJspDocument;
        private CodeGenerator codeGen;
        private String elIgnore;

        public ElementGenerator(String name, Hashtable attributes, Mark start, Mark stop, boolean isJspDocument, CodeGenerator codeGen) {
            this.start = start;
            this.stop = stop;
            this.name = name;
            this.attributes = attributes;
            this.isJspDocument = isJspDocument;
            this.codeGen = codeGen;
            this.elIgnore = codeGen.isELIgnored;
        }

        public void init(JspEngine ctxt) {
            this.ieClassId = ctxt.getJspConfig().ieClassId();
        }

        public boolean generate(ServletWriter writer, String phase) throws JspEngineException {
            writer.indent();
            writer.print("out.print(\"<");
            StringBuffer sb = new StringBuffer();
            if (ExpressionEvaluatorParser.checkEL(this.name, this.elIgnore)) {
                writer.print("\" + ");
                writer.print(ExpressionEvaluatorParser.generate(this.name, null, null));
                writer.print(" + \"");
            } else if (JspUtil.isExpression(this.name, this.isJspDocument)) {
                writer.print(JspUtil.removeQuotation(JspUtil.getExpr(this.name, this.isJspDocument)));
            } else {
                writer.print(this.name);
            }
            Enumeration _enum = this.attributes.keys();
            while (_enum.hasMoreElements()) {
                String _name = (String)_enum.nextElement();
                Object obj = this.attributes.get(_name);
                String _value = null;
                if (obj instanceof JspAttribute) {
                    ((JspAttribute)obj).generate(writer, this.codeGen, CodeGenerator.getPageContextName(this.parent), null);
                    _value = ((JspAttribute)obj).variableName;
                } else {
                    _value = obj instanceof String ? (String)obj : ((StringAttribute)obj).getAttributeValue();
                }
                if (_value == null) continue;
                writer.print(" " + _name + "=\\\"" + _value + "\\\"");
            }
            if (this.children.size() > 0) {
                writer.printlnNoIndent(">\");");
                for (int i = 0; i < this.children.size(); ++i) {
                    Generator gen = (Generator)this.children.get(i);
                    gen.generateCode(writer, phase);
                }
                writer.indent();
                writer.print("out.print(\"</");
            } else {
                writer.print("></");
            }
            if (ExpressionEvaluatorParser.checkEL(this.name, this.elIgnore)) {
                writer.print("\" + ");
                writer.print(ExpressionEvaluatorParser.generate(this.name, String.class, "null"));
                writer.print(" + \"");
            } else if (JspUtil.isExpression(this.name, this.isJspDocument)) {
                writer.print(JspUtil.removeQuotation(JspUtil.getExpr(this.name, this.isJspDocument)));
            } else {
                writer.print(this.name);
            }
            writer.print(ElementParser.END_OPEN_ELEMENT);
            writer.print("\");");
            return true;
        }
    }

    private class JspElementJspAttributeInfo
    implements JspattributeParser.JspAttributeInfo {
        private JspElementJspAttributeInfo() {
        }

        public boolean isRTExprAttribute(String attrname) {
            return false;
        }

        public boolean isEnableScript(String attrname) {
            return true;
        }

        public boolean isJspFragment(String attrname) {
            return false;
        }
    }
}

