/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.XmlCdataProcessor;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class ExpressionParser
extends Parser {
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";
    private static final String XML_OPEN_EXPR = "<jsp:expression>";
    private static final String XML_CLOSE_EXPR = "</jsp:expression>";

    public ExpressionParser() {
    }

    public ExpressionParser(boolean _isInvalidated) {
        super(_isInvalidated);
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        String close;
        String open;
        boolean isJspDocument;
        boolean bl = isJspDocument = xmlViewer == null;
        if (reader.matches(XML_OPEN_EXPR)) {
            open = XML_OPEN_EXPR;
            close = XML_CLOSE_EXPR;
        } else if (reader.matches(OPEN_EXPR)) {
            open = OPEN_EXPR;
            close = CLOSE_EXPR;
        } else {
            return false;
        }
        if (this.isInvalidated) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5681, (Object)XML_OPEN_EXPR));
        }
        reader.advance(open.length());
        Mark start = reader.mark();
        Mark stop = null;
        char[] data = null;
        if (!isJspDocument) {
            stop = reader.skipUntil(close);
            if (stop == null) {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)open));
            }
            parser.flushCharData();
            xmlViewer.addExpression(reader, start, stop);
            data = reader.getChars(start, stop);
        } else {
            XmlCdataProcessor xcp = new XmlCdataProcessor(reader, open, close);
            data = xcp.process();
            parser.flushCharData();
        }
        ExpressionGenerator gen = new ExpressionGenerator(data, start, stop);
        codeGen.addGenerator(gen, "ServiceMethodPhase");
        return true;
    }

    class ExpressionGenerator
    extends Generator {
        char[] chars;

        public ExpressionGenerator(char[] chars, Mark start, Mark stop) {
            this.start = start;
            this.stop = stop;
            this.chars = chars;
            for (int i = chars.length - 1; i >= 0; --i) {
                if (chars[i] == ';') {
                    chars[i] = 32;
                }
                if (chars[i] > ' ') break;
            }
        }

        public boolean generate(ServletWriter writer, String phase) {
            writer.println("out.print(" + new String(JspUtil.removeQuotes(this.chars)) + ");");
            return true;
        }
    }
}

