/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Enumeration;
import java.util.Vector;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ServletWriter;

public abstract class Generator {
    protected Mark start;
    protected Mark stop;
    protected Generator parent;
    protected Vector children = new Vector();
    private boolean obsolete = false;

    public void init(JspEngine engine) throws JspEngineException {
    }

    public void setObsolete() {
        this.obsolete = true;
        Enumeration enum1 = this.children.elements();
        while (enum1.hasMoreElements()) {
            Generator gen = (Generator)enum1.nextElement();
            gen.setObsolete();
        }
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void generateCode(ServletWriter out, String phase) throws JspEngineException {
        if (this.obsolete) {
            return;
        }
        if (this.generateCode2(out, phase)) {
            out.println();
        }
    }

    private boolean generateCode2(ServletWriter out, String phase) throws JspEngineException {
        boolean result;
        boolean somethingWritten = false;
        if (this.start != null && this.stop != null) {
            if (this.start.fileid == this.stop.fileid) {
                out.println("// jsp code [from=" + this.start.toShortString() + ";to=" + this.stop.toShortString() + "]");
            } else {
                out.println("// jsp code [from=" + this.start + ";to=" + this.stop + "]");
            }
            somethingWritten = true;
        }
        return (result = this.generate(out, phase)) || somethingWritten;
    }

    public void addChild(Generator gen) {
        gen.parent = this;
        this.children.add(gen);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public abstract boolean generate(ServletWriter var1, String var2) throws JspEngineException;
}

