/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Hashtable;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.BeanCache;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class GetPropertyParser
extends Parser {
    private static final String OPEN_GETPROPERTY = "<jsp:getProperty";
    private static final String CLOSE_GETPROPERTY = "/>";
    private static final String[] validAttributes = new String[]{"name", "property"};

    GetPropertyParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (reader.matches(OPEN_GETPROPERTY)) {
            Mark start = reader.mark();
            reader.advance(OPEN_GETPROPERTY.length());
            Hashtable attrs = reader.parseTagAttributes();
            JspParser.checkAttributes("getProperty", attrs.keys(), validAttributes);
            reader.skipSpaces();
            if (!reader.matches(CLOSE_GETPROPERTY)) {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:getProperty>"));
            }
            reader.advance(CLOSE_GETPROPERTY.length());
            Mark stop = reader.mark();
            parser.flushCharData();
            if (xmlViewer != null) {
                xmlViewer.addGetProperty(reader, start, stop);
            }
            BeanCache beanInfo = codeGen.getBeanCache();
            GetPropertyGenerator gen = new GetPropertyGenerator(attrs, beanInfo, start, stop);
            codeGen.addGenerator(gen, "ServiceMethodPhase");
            return true;
        }
        return false;
    }

    class GetPropertyGenerator
    extends Generator {
        Hashtable attrs;
        BeanCache beanInfo;

        public GetPropertyGenerator(Hashtable attrs, BeanCache beanInfo, Mark start, Mark stop) {
            this.start = start;
            this.stop = stop;
            this.attrs = attrs;
            this.beanInfo = beanInfo;
        }

        public boolean generate(ServletWriter writer, String phase) throws JspEngineException {
            String name = null;
            String property = null;
            if (this.attrs != null) {
                name = (String)this.attrs.get("name");
                property = (String)this.attrs.get("property");
            }
            String modProperty = property.substring(0, 1).toUpperCase() + property.substring(1);
            writer.println("out.print(jeus.servlet.jsp.JspMethodProxy.getProperty(\"" + name + "\", pageContext.findAttribute(\"" + name + "\"), \"" + property + "\"));");
            return true;
        }
    }
}

