/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CharDataGenerator;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.ExpressionEvaluatorParser;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ParamParser;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.VariableCharDataGenerator;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class IncludeParser
extends Parser {
    private static final String OPEN_INCLUDE = "<jsp:include";
    private static final String CLOSE_INCLUDE_NO_BODY = "/>";
    private static final String CLOSE_INCLUDE_BODY = ">";
    private static final String CLOSE_INCLUDE = "</jsp:include>";
    private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param";
    private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
    private static final String[] validAttributes = new String[]{"page", "flush"};

    IncludeParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        boolean isJspDocument;
        boolean bl = isJspDocument = xmlViewer == null;
        if (reader.matches(OPEN_INCLUDE)) {
            IncludeGenerator gen = null;
            Hashtable param = new Hashtable();
            Mark start = reader.mark();
            Mark stop = null;
            reader.advance(OPEN_INCLUDE.length());
            Hashtable attrs = reader.parseTagAttributes();
            JspParser.checkAttributes("Include", attrs.keys(), validAttributes);
            reader.skipSpaces();
            if (!reader.matches("/>")) {
                if (!reader.matches(CLOSE_INCLUDE_BODY)) {
                    throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:include>"));
                }
                reader.advance(CLOSE_INCLUDE_BODY.length());
                reader.skipSpaces();
                if (!reader.matches(CLOSE_INCLUDE)) {
                    gen = new IncludeGenerator(attrs, param, start, stop, isJspDocument, codeGen.isELIgnored);
                    reader.skipSpaces();
                    parser.flushCharData();
                    codeGen.pushParentGeneratorStack(gen);
                    parser.parse(this, CLOSE_INCLUDE, ParamParser.ACCEPT_JSPPARAM, null, true);
                    parser.flushCharData();
                    codeGen.popParentGeneratorStack();
                    reader.skipSpaces();
                    if (!reader.matches(CLOSE_INCLUDE)) {
                        throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:include>"));
                    }
                    reader.advance(CLOSE_INCLUDE.length());
                    gen.stop = stop = reader.mark();
                    parser.flushCharData();
                } else {
                    reader.advance(CLOSE_INCLUDE.length());
                    stop = reader.mark();
                    parser.flushCharData();
                    gen = new IncludeGenerator(attrs, param, start, stop, isJspDocument, codeGen.isELIgnored);
                }
            } else {
                reader.advance("/>".length());
                stop = reader.mark();
                parser.flushCharData();
                gen = new IncludeGenerator(attrs, param, start, stop, isJspDocument, codeGen.isELIgnored);
            }
            if (!isJspDocument) {
                xmlViewer.addInclude(reader, start, stop);
            }
            codeGen.addGenerator(gen, "ServiceMethodPhase");
            return true;
        }
        return false;
    }

    class IncludeGenerator
    extends Generator {
        String page;
        boolean isExpression = false;
        boolean doFlush = false;
        Hashtable params;
        boolean isJspDocument = false;
        private String elIgnore;

        public IncludeGenerator(Hashtable attrs, Hashtable param, Mark start, Mark stop, boolean isJspDocument, String elIgnore) throws JspEngineException {
            this.start = start;
            this.stop = stop;
            this.elIgnore = elIgnore;
            this.page = (String)attrs.get("page");
            if (this.page == null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5577));
            }
            String flush = (String)attrs.get("flush");
            this.doFlush = false;
            if (flush == null) {
                this.doFlush = false;
            } else if (flush.equals("true")) {
                this.doFlush = true;
            }
            this.params = param;
            this.isJspDocument = isJspDocument;
            this.isExpression = JspUtil.isExpression(this.page, isJspDocument);
        }

        public boolean generate(ServletWriter writer, String phase) throws JspEngineException {
            Enumeration<Object> enum1;
            String includedPage = null;
            includedPage = ExpressionEvaluatorParser.checkEL(this.page, this.elIgnore) ? ExpressionEvaluatorParser.generate(this.page, null, null) : (this.isExpression ? JspUtil.getExpr(this.page, this.isJspDocument) : ServletWriter.quoteString(JspUtil.trimTrailingSpace(this.page)));
            writer.indent();
            writer.print("pageContext.include(" + includedPage);
            boolean hasQstr = includedPage.indexOf("?") >= 0;
            boolean initial = true;
            String sep = "?";
            if (this.params.size() > 0) {
                enum1 = this.params.keys();
                while (enum1.hasMoreElements()) {
                    String key = (String)enum1.nextElement();
                    String[] value = (String[])this.params.get(key);
                    if (initial) {
                        sep = hasQstr ? "&" : "?";
                        initial = false;
                    } else {
                        sep = "&";
                    }
                    writer.print(" + \"" + sep + "\"");
                    if (JspUtil.isExpression(key, this.isJspDocument)) {
                        throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5375));
                    }
                    if (ExpressionEvaluatorParser.checkEL(key, this.elIgnore)) {
                        throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5375));
                    }
                    writer.print(" + \"" + key + "=\"");
                    WebProperties props = PropertyUtil.getContextProperties();
                    for (int i = 0; i < value.length; ++i) {
                        String tmpStr;
                        if (JspUtil.isExpression(value[i], this.isJspDocument)) {
                            tmpStr = null;
                            tmpStr = props.URL_ENCODE_JSP_PARAM.value ? "java.net.URLEncoder.encode(\"\" + (" + JspUtil.getExpr(value[i], this.isJspDocument) + "))" : "(" + JspUtil.getExpr(value[i], this.isJspDocument) + ")";
                            writer.print(" + " + tmpStr);
                            continue;
                        }
                        if (ExpressionEvaluatorParser.checkEL(value[i], this.elIgnore)) {
                            tmpStr = null;
                            tmpStr = props.URL_ENCODE_JSP_PARAM.value ? "java.net.URLEncoder.encode(\"\" + (" + ExpressionEvaluatorParser.generate(value[i], null, null) + "))" : "(" + ExpressionEvaluatorParser.generate(value[i], null, null) + ")";
                            writer.print(" + " + tmpStr);
                            continue;
                        }
                        tmpStr = null;
                        tmpStr = props.URL_ENCODE_JSP_PARAM.value ? "\"" + URLEncoder.encode(value[i]) + "\"" : "\"" + value[i] + "\"";
                        writer.print(" + " + tmpStr);
                    }
                }
            }
            if (this.hasChildren()) {
                enum1 = this.children.elements();
                while (enum1.hasMoreElements()) {
                    if (initial) {
                        sep = hasQstr ? "&" : "?";
                        initial = false;
                    } else {
                        sep = "&";
                    }
                    writer.print(" + \"" + sep + "\"");
                    Generator gen = (Generator)enum1.nextElement();
                    if (gen instanceof ParamParser.ParamGenerator) {
                        gen.generate(writer, phase);
                        continue;
                    }
                    if (gen instanceof VariableCharDataGenerator) {
                        gen.setObsolete();
                        continue;
                    }
                    if (gen instanceof CharDataGenerator) {
                        gen.setObsolete();
                        continue;
                    }
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5573));
                }
            }
            writer.println(", " + this.doFlush + ");");
            return true;
        }
    }
}

