/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.jsp.tagext.TagVariableInfo;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Attribute;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.JspattributeParser;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.StringAttribute;
import jeus.servlet.jsp.compiler.TagFileCodeGenerator;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class InvokeParser
extends Parser {
    private static final String OPEN_INVOKE = "<jsp:invoke";
    private static final String CLOSE_INVOKE = "/>";
    private static final String CLOSE_INVOKE_2 = "</jsp:invoke>";
    private static final String CLOSE_INVOKE_3 = ">";
    private static final String[] validAttributes = new String[]{"fragment", "var", "varReader", "scope"};

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        boolean isJspDocument;
        boolean bl = isJspDocument = xmlViewer == null;
        if (reader.matches(OPEN_INVOKE)) {
            Mark start = reader.mark();
            reader.advance(OPEN_INVOKE.length());
            Hashtable attrs = reader.parseTagAttributes();
            JspParser.checkAttributes("Invoke", attrs.keys(), validAttributes);
            this.internalValidate(attrs);
            reader.skipSpaces();
            if (reader.matches(CLOSE_INVOKE)) {
                reader.advance(CLOSE_INVOKE.length());
            } else if (reader.matches(CLOSE_INVOKE_3)) {
                reader.advance(CLOSE_INVOKE_3.length());
                reader.skipSpaces();
                Hashtable<String, String> jspAttributes = new Hashtable<String, String>();
                Attribute jspAttribute = null;
                JspInvokeJspAttributeInfo rtmap = new JspInvokeJspAttributeInfo();
                while ((jspAttribute = JspattributeParser.parse(xmlViewer, reader, parser, codeGen, this, rtmap)) != null) {
                    jspAttributes.put(jspAttribute.attributeName, ((StringAttribute)jspAttribute).getAttributeValue());
                }
                if (jspAttributes.size() > 0) {
                    attrs.putAll(jspAttributes);
                    this.internalValidate(attrs);
                    JspParser.checkAttributes("Invoke", attrs.keys(), validAttributes);
                }
                reader.skipSpaces();
                if (!reader.matches(CLOSE_INVOKE_2)) {
                    throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:invoke>"));
                }
                reader.advance(CLOSE_INVOKE_2.length());
            } else {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:invoke>"));
            }
            if (!parser.isTagFile()) {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5572, (Object)"<jsp:invoke>"));
            }
            Mark stop = reader.mark();
            parser.flushCharData();
            if (!isJspDocument) {
                xmlViewer.addInvoke(reader, start, stop);
            }
            InvokeGenerator gen = new InvokeGenerator(attrs, start, stop, isJspDocument, ((TagFileCodeGenerator)codeGen).getTagVariables());
            codeGen.addGenerator(gen, "ServiceMethodPhase");
            return true;
        }
        return false;
    }

    private void internalValidate(Hashtable attrs) throws JspParseException {
        boolean isScope = false;
        boolean isVar = false;
        boolean isVarReader = false;
        Enumeration enum1 = attrs.keys();
        while (enum1.hasMoreElements()) {
            String attrName = (String)enum1.nextElement();
            if (attrName == null) continue;
            if (attrName.equalsIgnoreCase("var")) {
                isVar = true;
                continue;
            }
            if (attrName.equalsIgnoreCase("varReader")) {
                isVarReader = true;
                continue;
            }
            if (!attrName.equalsIgnoreCase("scope")) continue;
            String value = (String)attrs.get(attrName);
            if (!(value.equals("page") || value.equals("request") || value.equals("session") || value.equals("application"))) {
                throw new JspParseException("invalid 'scope' value : " + value);
            }
            isScope = true;
        }
        if (isScope && !isVar && !isVarReader) {
            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5376));
        }
    }

    private static String getScope(String _scope) {
        if (_scope.equalsIgnoreCase("page")) {
            return "PageContext.PAGE_SCOPE";
        }
        if (_scope.equalsIgnoreCase("request")) {
            return "PageContext.REQUEST_SCOPE";
        }
        if (_scope.equalsIgnoreCase("application")) {
            return "PageContext.APPLICATION_SCOPE";
        }
        if (_scope.equalsIgnoreCase("session")) {
            return "PageContext.SESSION_SCOPE";
        }
        return "PageContext.PAGE_SCOPE";
    }

    class InvokeGenerator
    extends Generator {
        private String fragment;
        private String var;
        private String varReader;
        private String scope;
        private ArrayList tagVariables;
        private Hashtable attrs;
        private boolean isJspDocument = false;

        public InvokeGenerator(Hashtable attrs, Mark start, Mark stop, boolean isJspDocument, ArrayList tagVariables) throws JspEngineException {
            this.start = start;
            this.stop = stop;
            this.attrs = attrs;
            this.tagVariables = tagVariables;
            this.fragment = (String)attrs.get("fragment");
            if (this.fragment == null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5300));
            }
            this.var = (String)attrs.get("var");
            this.varReader = (String)attrs.get("varReader");
            this.scope = (String)attrs.get("scope");
            if (this.var != null & this.varReader != null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5377));
            }
            this.isJspDocument = isJspDocument;
        }

        public boolean generate(ServletWriter writer, String phase) {
            for (TagVariableInfo info : this.tagVariables) {
                int scope = info.getScope();
                String name = info.getNameGiven();
                if (scope != 1 && scope != 0) continue;
                writer.println("if ((jspValue = jspContext.getAttribute(\"" + name + "\")) != null) {");
                writer.pushIndent();
                writer.println("_jspParentContext.setAttribute(\"" + name + "\", jspValue);");
                writer.popIndent();
                writer.println("} else {");
                writer.pushIndent();
                writer.println("_jspParentContext.removeAttribute(\"" + name + "\", PageContext.PAGE_SCOPE);");
                writer.popIndent();
                writer.println("}");
            }
            char[] n = this.fragment.toCharArray();
            n[0] = Character.toUpperCase(n[0]);
            String fragmentMethod = "get" + new String(n) + "()";
            if (this.varReader != null || this.var != null) {
                writer.println("_jspSout = new java.io.StringWriter();");
                writer.println(fragmentMethod + ".invoke(_jspSout);");
            } else {
                writer.println(fragmentMethod + ".invoke(null);");
            }
            if (this.varReader != null) {
                if (this.scope == null) {
                    writer.println("jspContext.setAttribute(\"" + this.varReader + "\", new StringReader(_jspSout.toString()));");
                } else {
                    writer.println("jspContext.setAttribute(\"" + this.varReader + "\", new StringReader(_jspSout.toString()), " + InvokeParser.getScope(this.scope) + ");");
                }
            } else if (this.var != null) {
                if (this.scope == null) {
                    writer.println("jspContext.setAttribute(\"" + this.var + "\", _jspSout.toString());");
                } else {
                    writer.println("jspContext.setAttribute(\"" + this.var + "\", _jspSout.toString(), " + InvokeParser.getScope(this.scope) + ");");
                }
            }
            return true;
        }
    }

    private class JspInvokeJspAttributeInfo
    implements JspattributeParser.JspAttributeInfo {
        private JspInvokeJspAttributeInfo() {
        }

        public boolean isRTExprAttribute(String attrname) {
            return false;
        }

        public boolean isEnableScript(String attrname) {
            return true;
        }

        public boolean isJspFragment(String attrname) {
            return false;
        }
    }
}

