/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.JspProperty;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.CommentParser;
import jeus.servlet.jsp.compiler.JspCodeGenerator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.TagFileCodeGenerator;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

final class JspDocumentStartParser
extends Parser {
    private static final String DEFAULT_TAGLIB_NAME = "xmlns:jsp";
    private static final String DEFAULT_TAGLIB_VALUE = "http://java.sun.com/JSP/Page";
    private static final String OPEN_XML_TAG = "<?xml ";
    private static final String CLOSE_XML_TAG = "?>";
    private static final String OPEN_ROOT_TAG = "<jsp:root";
    private static final String CLOSE_ROOT_TAG = ">";
    private static final CommentParser commentParser = new CommentParser();
    boolean _isNoJspNameSpace = false;
    boolean jspRoot = false;

    JspDocumentStartParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        Mark m = reader.mark();
        Mark xmlEndMark = null;
        reader.skipSpaces();
        Object docElement = null;
        String _currentRootElementName = "";
        boolean startXmlDeclaration = false;
        if (!reader.matches(OPEN_XML_TAG)) {
            boolean isXMLform = false;
            reader.skipSpaces();
            while (reader.matches("<%--")) {
                reader.advance(4);
                Mark _end = reader.skipUntil("--%>");
                if (_end == null) {
                    reader.reset(m);
                    return false;
                }
                reader.reset(_end);
                reader.advance(4);
                reader.skipSpaces();
            }
        } else {
            startXmlDeclaration = true;
            if (!this.doXMLDeclaration(reader, codeGen, m)) {
                return false;
            }
            xmlEndMark = reader.mark();
        }
        reader.skipSpaces();
        this.skipComment(reader, parser);
        this.jspRoot = reader.matches(OPEN_ROOT_TAG);
        if (this.jspRoot && !parser.isXml && parser.getJspProperty() != null && !parser.getJspProperty().isPropertyXml()) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5580));
        }
        if (!this.jspRoot) {
            if (!parser.isXml) {
                reader.reset(m);
                return false;
            }
            try {
                Mark tmpMark = reader.mark();
                int ch = reader.peekChar();
                if (ch != 60) {
                    reader.reset(m);
                    return false;
                }
                ch = reader.nextChar();
                while (ch != 10 && ch != 32 && ch != 9 && ch != 62) {
                    if (ch != 60) {
                        _currentRootElementName = _currentRootElementName + (char)ch;
                    }
                    ch = reader.nextChar();
                }
                reader.reset(tmpMark);
            }
            catch (Exception ee) {
                ee.printStackTrace();
                reader.reset(m);
                return false;
            }
        }
        if (this.jspRoot) {
            _currentRootElementName = "jsp:root";
            this._isNoJspNameSpace = false;
        } else {
            this._isNoJspNameSpace = true;
        }
        reader.advance(1 + _currentRootElementName.length());
        reader.skipSpaces();
        Hashtable attrs = null;
        try {
            attrs = reader.parseTagAttributes();
        }
        catch (Exception jee) {
            reader.reset(m);
            return false;
        }
        if (!this._isNoJspNameSpace) {
            this.checkRootAttribute(attrs);
        }
        reader.skipSpaces();
        if (!reader.matches(CLOSE_ROOT_TAG)) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:root>"));
        }
        reader.advance(CLOSE_ROOT_TAG.length());
        reader.skipSpaces();
        boolean isCustomTag = false;
        if (this._isNoJspNameSpace) {
            int pos = _currentRootElementName.indexOf(":");
            String prefix = null;
            if (pos > 0) {
                reader.reset(m);
                prefix = _currentRootElementName.substring(0, pos);
            } else {
                prefix = _currentRootElementName;
            }
            if (attrs.get("xmlns:" + prefix) == null) {
                codeGen.setRootNoNameSpace(true, _currentRootElementName);
                this.isAnotherJspNameSpace(_currentRootElementName, attrs, codeGen);
                isCustomTag = false;
            } else {
                isCustomTag = true;
                if (xmlEndMark == null) {
                    reader.reset(m);
                } else {
                    reader.reset(xmlEndMark);
                }
                return false;
            }
        }
        codeGen.setExistRoot(true);
        if (this._isNoJspNameSpace && isCustomTag) {
            reader.reset(m);
        } else {
            codeGen.handleXmlRoot(attrs);
        }
        return this.jspRoot;
    }

    public boolean _accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        String _currentRootElementName;
        Element docElement;
        Mark m;
        block26: {
            m = reader.mark();
            reader.skipSpaces();
            docElement = null;
            _currentRootElementName = null;
            boolean startXmlDeclaration = false;
            if (!reader.matches(OPEN_XML_TAG)) {
                boolean isXMLform;
                block25: {
                    isXMLform = false;
                    reader.skipSpaces();
                    while (reader.matches("<%--")) {
                        reader.advance(4);
                        Mark _end = reader.skipUntil("--%>");
                        if (_end == null) {
                            reader.reset(m);
                            return false;
                        }
                        reader.reset(_end);
                        reader.advance(4);
                        reader.skipSpaces();
                    }
                    try {
                        docElement = reader.getDocumentElement();
                        isXMLform = true;
                    }
                    catch (SAXException e) {
                        try {
                            docElement = reader.getDocumentElement2();
                            isXMLform = true;
                            if (!this.doXMLDeclaration(reader, codeGen, m)) {
                                return false;
                            }
                        }
                        catch (SAXException e1) {
                            // empty catch block
                        }
                        if (docElement != null) break block25;
                        reader.reset(m);
                        return false;
                    }
                }
                if (!isXMLform) {
                    reader.reset(m);
                    return false;
                }
            } else {
                startXmlDeclaration = true;
                if (!this.doXMLDeclaration(reader, codeGen, m)) {
                    return false;
                }
            }
            reader.skipSpaces();
            this.skipComment(reader, parser);
            try {
                if (docElement == null) {
                    docElement = reader.getDocumentElement();
                }
            }
            catch (SAXException e) {
                if (!startXmlDeclaration) break block26;
                reader.reset(m);
                return false;
            }
        }
        if (_currentRootElementName == null) {
            _currentRootElementName = docElement.getTagName();
        }
        this._isNoJspNameSpace = !_currentRootElementName.equalsIgnoreCase("jsp:root");
        if (codeGen instanceof TagFileCodeGenerator && _currentRootElementName.equalsIgnoreCase("jsp:element")) {
            codeGen.setSpecialXmlDocument(true);
            return true;
        }
        reader.advance(1 + _currentRootElementName.length());
        reader.skipSpaces();
        Hashtable attrs = null;
        try {
            attrs = reader.parseTagAttributes();
        }
        catch (Exception jee) {
            reader.reset(m);
            return false;
        }
        if (!this._isNoJspNameSpace) {
            this.checkRootAttribute(attrs);
        }
        reader.skipSpaces();
        if (!reader.matches(CLOSE_ROOT_TAG)) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:root>"));
        }
        reader.advance(CLOSE_ROOT_TAG.length());
        reader.skipSpaces();
        JspProperty jspProperty = ((JspCodeGenerator)codeGen).getCtxt().getReloader().getJspProperty();
        boolean isCustomTag = false;
        if (this._isNoJspNameSpace) {
            int pos = _currentRootElementName.indexOf(":");
            String prefix = null;
            prefix = pos > 0 ? _currentRootElementName.substring(0, pos) : _currentRootElementName;
            if (attrs.get("xmlns:" + prefix) == null) {
                codeGen.setRootNoNameSpace(true, _currentRootElementName);
                this.isAnotherJspNameSpace(_currentRootElementName, attrs, codeGen);
                isCustomTag = false;
            } else {
                isCustomTag = true;
            }
        }
        codeGen.setExistRoot(true);
        if (this._isNoJspNameSpace && isCustomTag) {
            reader.reset(m);
        } else {
            codeGen.handleXmlRoot(attrs);
        }
        return true;
    }

    private boolean doXMLDeclaration(JspReader reader, CodeGenerator codeGen, Mark m) throws JspParseException {
        reader.advance(OPEN_XML_TAG.length());
        reader.skipSpaces();
        this.checkXmlAttribute(reader, codeGen);
        Mark stop = reader.skipUntil(CLOSE_XML_TAG);
        if (stop == null) {
            if (WebProperties.J2EE_COMPATIBLE.value) {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5303));
            }
            reader.reset(m);
            return false;
        }
        return true;
    }

    private boolean isAnotherJspNameSpace(String currentRootElementName, Hashtable attrs, CodeGenerator codeGen) {
        if (currentRootElementName == null || currentRootElementName.startsWith("jsp:") || attrs == null || attrs.size() == 0) {
            return false;
        }
        int _pos = currentRootElementName.indexOf(58);
        if (_pos == -1 || currentRootElementName.length() == _pos + 1) {
            return false;
        }
        String prefix = currentRootElementName.substring(0, _pos);
        String _namespace = (String)attrs.get("xmlns:" + prefix);
        if (_namespace != null && _namespace.equalsIgnoreCase(DEFAULT_TAGLIB_VALUE)) {
            codeGen.setNameSpace(prefix);
            return true;
        }
        return false;
    }

    private void skipComment(JspReader reader, JspParser parser) throws JspEngineException {
        reader.skipSpaces();
        while (commentParser.accept(null, reader, parser, null, null)) {
            reader.skipSpaces();
        }
        reader.skipSpaces();
    }

    private void checkXmlAttribute(JspReader reader, CodeGenerator codeGen) throws JspParseException {
        Hashtable attrs = reader.parseTagAttributesInXmlDeclaration();
        Object _obj = attrs.remove("encoding");
        if (_obj != null) {
            codeGen.pageEncodingInXml = (String)_obj;
            String _realXMLencoding = reader.getXmlEncoding();
            if (_realXMLencoding != null) {
                codeGen.pageEncodingInXml = _realXMLencoding;
            }
        }
    }

    private void checkRootAttribute(Hashtable attrs) throws JspParseException {
        String _version;
        Object version = attrs.remove("version");
        if (!this._isNoJspNameSpace && version == null) {
            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5304));
        }
        if (version != null && !"1.2".equalsIgnoreCase(_version = (String)version) && !"2.0".equalsIgnoreCase(_version)) {
            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5389));
        }
        String defaultTaglib = (String)attrs.remove(DEFAULT_TAGLIB_NAME);
        Enumeration enum1 = attrs.keys();
        while (enum1.hasMoreElements()) {
            String name = (String)enum1.nextElement();
            if (name.equals("version") || name.startsWith("xmlns:") && name.length() >= 7) continue;
            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5306, (Object)name));
        }
    }
}

