/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.jsp.tagext.PageData;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.PageDataImpl;
import jeus.servlet.jsp.compiler.TagLibraryInfoImpl;
import jeus.util.logging.JeusLogger;

public class JspXmlViewer {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    private static final String JSP_NAMESPACE = "http://java.sun.com/JSP/Page";
    private static final String JSP_VERSION = "2.0";
    private String jspURI;
    private StringBuffer sbuf;
    private StringBuffer rootAttribute;
    private boolean textStarted;
    private Hashtable tagLibraries;
    private int jspId;

    public JspXmlViewer(String jspURI) {
        this.jspURI = jspURI;
        this.tagLibraries = new Hashtable();
        this.sbuf = new StringBuffer();
        this.rootAttribute = new StringBuffer();
        this.addRootAttribute("xmlns:jsp", JSP_NAMESPACE);
        this.addRootAttribute("version", JSP_VERSION);
        this.textStarted = false;
    }

    private void addRootAttribute(String name, String value) {
        this.rootAttribute.append("  " + name + "=\"" + value + "\"\n");
    }

    private void addAttribute(String name, String value) {
        this.sbuf.append(" " + name + "=\"" + value + "\"");
    }

    public void appendText(char ch) {
        if (!this.textStarted) {
            this.textStarted = true;
            this.sbuf.append("<jsp:text jsp:id='" + ++this.jspId + "' ><![CDATA[");
        }
        this.sbuf.append(ch);
    }

    public void appendText(String str) {
        if (!this.textStarted) {
            this.textStarted = true;
            this.sbuf.append("<jsp:text jsp:id='" + ++this.jspId + "' ><![CDATA[");
        }
        this.sbuf.append(str);
    }

    public void textEnd() {
        if (this.textStarted) {
            this.sbuf.append("]]></jsp:text>\n");
            this.textStarted = false;
        }
    }

    public void addDirective(String directive, Hashtable attrs) {
        this.textEnd();
        if (directive.equals("taglib")) {
            Vector uris = (Vector)attrs.get("uri");
            Vector prefixes = (Vector)attrs.get("prefix");
            if (uris != null && prefixes != null) {
                String uri = (String)uris.elementAt(0);
                String prefix = (String)prefixes.elementAt(0);
                if (uri != null && prefix != null) {
                    this.addRootAttribute("xmlns:" + prefix, uri);
                }
            }
            Vector tagdirs = (Vector)attrs.get("tagdir");
            prefixes = (Vector)attrs.get("prefix");
            if (tagdirs != null && prefixes != null) {
                String tagdir = (String)tagdirs.elementAt(0);
                String prefix = (String)prefixes.elementAt(0);
                if (tagdir != null && prefix != null) {
                    this.addRootAttribute("xmlns:" + prefix, tagdir);
                }
            }
        } else if (directive.equals("page")) {
            this.addPageDirective(attrs);
        } else if (directive.equals("include")) {
            // empty if block
        }
    }

    private void addPageDirective(Hashtable attrs) {
        if (attrs.size() > 0) {
            this.sbuf.append("<jsp:directive.page jsp:id='" + ++this.jspId + "'");
            Enumeration enum1 = attrs.keys();
            while (enum1.hasMoreElements()) {
                String attr = (String)enum1.nextElement();
                Vector values = (Vector)attrs.get(attr);
                if (values == null) continue;
                int size = values.size();
                for (int i = 0; i < size; ++i) {
                    String value = (String)values.elementAt(i);
                    if (attr == null || value == null) continue;
                    this.addAttribute(attr, value);
                }
            }
            this.sbuf.append("/>\n");
        }
    }

    public void addInclude(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        String body = new String(reader.getChars(start, stop));
        body = body.replaceAll("<%=", "%=");
        body = body.replaceAll("%>", "%");
        this.sbuf.append(body);
    }

    public void addForward(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        this.sbuf.append(reader.getChars(start, stop));
    }

    public void addDeclaration(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        this.sbuf.append("<jsp:declaration jsp:id='" + ++this.jspId + "' > <![CDATA[ ");
        this.sbuf.append(reader.getChars(start, stop));
        this.sbuf.append(" ]]> </jsp:declaration>\n");
    }

    public void addExpression(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        this.sbuf.append("<jsp:expression jsp:id='" + ++this.jspId + "' > ");
        this.sbuf.append("<![CDATA[");
        this.sbuf.append(reader.getChars(start, stop));
        this.sbuf.append("]]>");
        this.sbuf.append(" </jsp:expression>\n");
    }

    public void addScriptlet(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        this.sbuf.append("<jsp:scriptlet jsp:id='" + ++this.jspId + "' > <![CDATA[ ");
        this.sbuf.append(reader.getChars(start, stop));
        this.sbuf.append(" ]]> </jsp:scriptlet>\n");
    }

    public void addBean(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        this.sbuf.append(reader.getChars(start, stop));
        this.sbuf.append("\n");
    }

    public void addGetProperty(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        this.sbuf.append(reader.getChars(start, stop));
        this.sbuf.append("\n");
    }

    public void addSetProperty(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        this.sbuf.append(reader.getChars(start, stop));
        this.sbuf.append("\n");
    }

    public void addCustomTag(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        char[] old_tag = reader.getChars(start, stop);
        int count = 0;
        char[] newtag = new char[old_tag.length * 2];
        if (old_tag != null && old_tag.length > 0) {
            boolean attribute_setting = false;
            for (int i = 0; i < old_tag.length; ++i) {
                if (old_tag[i] == '<' && i + 2 < old_tag.length && old_tag[i + 1] == '%' && old_tag[i + 2] == '=' || old_tag[i] == '>' && i > 0 && old_tag[i - 1] == '%') continue;
                if (old_tag[i] == '\"') {
                    attribute_setting = !attribute_setting;
                }
                if (!attribute_setting && old_tag[i] == '\"' && old_tag[i + 1] != ' ') {
                    newtag[count++] = 34;
                    newtag[count++] = 32;
                    continue;
                }
                if (old_tag[i] == '&' && old_tag[i + 1] == '&') {
                    newtag[count++] = 38;
                    newtag[count++] = 97;
                    newtag[count++] = 109;
                    newtag[count++] = 112;
                    newtag[count++] = 59;
                    newtag[count++] = 38;
                    newtag[count++] = 97;
                    newtag[count++] = 109;
                    newtag[count++] = 112;
                    newtag[count++] = 59;
                    ++i;
                    continue;
                }
                if (attribute_setting && old_tag[i] == '<') {
                    newtag[count++] = 38;
                    newtag[count++] = 108;
                    newtag[count++] = 116;
                    newtag[count++] = 59;
                    continue;
                }
                if (attribute_setting && old_tag[i] == '>') {
                    newtag[count++] = 38;
                    newtag[count++] = 103;
                    newtag[count++] = 116;
                    newtag[count++] = 59;
                    continue;
                }
                newtag[count++] = old_tag[i];
            }
        }
        char[] tag = new char[count];
        System.arraycopy(newtag, 0, tag, 0, count);
        if (tag != null && tag.length > 0) {
            CharArrayWriter cWriter = new CharArrayWriter();
            boolean _isFirstBlankFound = false;
            for (int i = 0; i < tag.length; ++i) {
                if (tag[i] == '<' && i + 2 < tag.length && tag[i + 1] == '%' && tag[i + 2] == '=' || tag[i] == '>' && i > 0 && tag[i - 1] == '%') continue;
                if (!_isFirstBlankFound && tag[i] == ' ') {
                    _isFirstBlankFound = true;
                    cWriter.write(32);
                    try {
                        cWriter.write("jsp:id='" + ++this.jspId + "' ");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                cWriter.write(tag[i]);
            }
            cWriter.flush();
            char[] _data = cWriter.toCharArray();
            this.sbuf.append(_data);
            this.sbuf.append("\n");
        }
    }

    public void addCustomTagEnd(String tagEnd) {
        this.textEnd();
        this.sbuf.append(tagEnd);
        this.sbuf.append("\n");
    }

    public void addPlugin(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        this.sbuf.append(reader.getChars(start, stop));
        this.sbuf.append("\n");
    }

    public void addElement(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        this.sbuf.append(reader.getChars(start, stop));
        this.sbuf.append("\n");
    }

    public void addText(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        this.sbuf.append("<jsp:text jsp:id='" + ++this.jspId + "' > ");
        this.sbuf.append(reader.getChars(start, stop));
        this.sbuf.append(" </jsp:text>\n");
    }

    public void addInvoke(JspReader reader, Mark start, Mark stop) {
        this.textEnd();
        this.sbuf.append(reader.getChars(start, stop));
    }

    private PageData getPageData() {
        StringBuffer buff = new StringBuffer();
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buff.append("<jsp:root jsp:id='" + ++this.jspId + "' \n");
        buff.append(this.rootAttribute.toString());
        buff.append(">\n");
        this.textEnd();
        buff.append(this.sbuf.toString());
        buff.append("</jsp:root>");
        String outstr = buff.toString();
        byte[] outbytes = outstr.getBytes();
        PageDataImpl pageData = new PageDataImpl(outstr);
        return pageData;
    }

    void addTagLibraryInfo(TagLibraryInfoImpl tli) {
        if (tli == null || tli.getURI() == null) {
            return;
        }
        if (this.tagLibraries.get(tli.getURI()) == null) {
            this.tagLibraries.put(tli.getURI(), tli);
        }
    }

    public void validate() throws JspEngineException {
        if (this.tagLibraries.size() <= 0) {
            return;
        }
        Enumeration enum1 = this.tagLibraries.elements();
        while (enum1.hasMoreElements()) {
            TagLibraryInfoImpl tli = (TagLibraryInfoImpl)((Object)enum1.nextElement());
            tli.validate(this.getPageData());
        }
    }

    public static class ByteArrayInputStreamImpl
    extends ByteArrayInputStream {
        public ByteArrayInputStreamImpl(byte[] buf) {
            super(buf);
        }

        public void close() throws IOException {
            this.pos = 0;
            this.count = this.buf.length;
        }
    }
}

