/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Attribute;
import jeus.servlet.jsp.compiler.CharDataGenerator;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.ExpressionEvaluatorParser;
import jeus.servlet.jsp.compiler.FallbackParser;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.JspattributeParser;
import jeus.servlet.jsp.compiler.JspbodyParser;
import jeus.servlet.jsp.compiler.JspparamsParser;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ParamParser;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.StringAttribute;
import jeus.servlet.jsp.compiler.VariableCharDataGenerator;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class PluginParser
extends Parser {
    public static final String PLUGIN_GEN_PHASE1 = "PluginGenPhase1";
    public static final String PLUGIN_GEN_PHASE2 = "PluginGenPhase2";
    private static final String OPEN_PLUGIN = "<jsp:plugin";
    private static final String END_OPEN_PLUGIN = ">";
    private static final String END_OPEN_PLUGIN_2 = "/>";
    private static final String CLOSE_PLUGIN = "</jsp:plugin>";
    private static final String[] validAttributes = new String[]{"type", "code", "codebase", "align", "archive", "height", "hspace", "jreversion", "name", "title", "vspace", "width", "nspluginurl", "iepluginurl", "params", "fallback"};
    private static final Vector JSPPLUGIN_ACCEPT_SET = new Vector();
    private static final Vector JSPPLUGIN_NOT_ACCEPT_SET;

    PluginParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        boolean isJspDocument;
        boolean bl = isJspDocument = xmlViewer == null;
        if (reader.matches(OPEN_PLUGIN)) {
            Mark start = reader.mark();
            reader.advance(OPEN_PLUGIN.length());
            Hashtable attrs = reader.parseTagAttributes();
            reader.skipSpaces();
            this.checkAttributes(attrs);
            if (reader.matches(END_OPEN_PLUGIN_2)) {
                reader.advance(END_OPEN_PLUGIN_2.length());
                Mark stop = reader.mark();
                PluginGenerator gen = new PluginGenerator(attrs, start, stop, isJspDocument, codeGen.isELIgnored);
                parser.flushCharData();
                if (!isJspDocument) {
                    xmlViewer.addPlugin(reader, start, stop);
                }
                codeGen.addGenerator(gen, "ServiceMethodPhase");
                return true;
            }
            if (!reader.matches(END_OPEN_PLUGIN)) {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:plugin>"));
            }
            reader.advance(END_OPEN_PLUGIN.length());
            reader.skipSpaces();
            boolean jspAttrExist = false;
            Attribute jspAttribute = null;
            JspPluginJspAttributeInfo rtmap = new JspPluginJspAttributeInfo();
            while ((jspAttribute = JspattributeParser.parse(xmlViewer, reader, parser, codeGen, this, rtmap)) != null) {
                attrs.put(jspAttribute.attributeName, ((StringAttribute)jspAttribute).getAttributeValue());
                jspAttrExist = true;
            }
            JspParser.checkAttributes("plugin", attrs.keys(), validAttributes);
            reader.skipSpaces();
            parser.flushCharData();
            Mark stop = null;
            PluginGenerator gen = new PluginGenerator(attrs, start, stop, isJspDocument, codeGen.isELIgnored);
            JspbodyParser.parse(this, xmlViewer, reader, parser, codeGen, gen, "jsp:plugin", JSPPLUGIN_ACCEPT_SET, JSPPLUGIN_NOT_ACCEPT_SET, jspAttrExist);
            reader.skipSpaces();
            parser.flushCharData();
            gen.stop = stop = reader.mark();
            parser.flushCharData();
            if (!isJspDocument) {
                xmlViewer.addPlugin(reader, start, stop);
            }
            codeGen.addGenerator(gen, "ServiceMethodPhase");
            return true;
        }
        return false;
    }

    private void checkAttributes(Hashtable attrs) throws JspEngineException {
        if (attrs == null) {
            return;
        }
        String _type = (String)attrs.get("type");
        if (_type != null && !_type.equalsIgnoreCase("applet") && !_type.equalsIgnoreCase("bean")) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5200));
        }
    }

    static {
        JSPPLUGIN_ACCEPT_SET.add(new JspparamsParser());
        JSPPLUGIN_ACCEPT_SET.add(new FallbackParser());
        JSPPLUGIN_NOT_ACCEPT_SET = new Vector();
        JSPPLUGIN_NOT_ACCEPT_SET.add(new ParamParser(true));
    }

    class PluginGenerator
    extends Generator {
        Hashtable attrs;
        String ieClassId;
        boolean isJspDocument;
        private String elIgnore;

        public PluginGenerator(Hashtable attrs, Mark start, Mark stop, boolean isJspDocument, String elIgnore) {
            this.start = start;
            this.stop = stop;
            this.attrs = attrs;
            this.isJspDocument = isJspDocument;
            this.elIgnore = elIgnore;
        }

        public void init(JspEngine ctxt) {
            this.ieClassId = ctxt.getJspConfig().ieClassId();
        }

        public boolean generate(ServletWriter writer, String phase) throws JspEngineException {
            Generator gen;
            Enumeration enum1;
            String type = this.getAttribute("type");
            String code = this.getAttribute("code");
            String codebase = this.getAttribute("codebase");
            String archive = this.getAttribute("archive");
            String jreversion = this.getAttribute("jreversion");
            String nspluginurl = this.getAttribute("nspluginurl");
            String iepluginurl = this.getAttribute("iepluginurl");
            if (nspluginurl != null) {
                nspluginurl = nspluginurl.trim();
            }
            if (iepluginurl != null) {
                iepluginurl = iepluginurl.trim();
            }
            if (type == null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5602));
            }
            if (code == null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5603));
            }
            writer.popIndent();
            writer.println("/* Code generated for plugin */");
            writer.indent();
            writer.print("out.println (\"<OBJECT classid=\\\"");
            writer.print(this.ieClassId);
            writer.print("\\\"");
            this.generateCommon(writer, true);
            writer.print(" codebase=\\\"");
            if (iepluginurl == null) {
                writer.print("http://java.sun.com/products/plugin/1.2.2/jinstall-1_2_2-win.cab#Version=1,2,2,0");
            } else {
                if (JspUtil.isExpression(iepluginurl, this.isJspDocument)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5201));
                }
                if (ExpressionEvaluatorParser.checkEL(iepluginurl, this.elIgnore)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5201));
                }
                writer.print(iepluginurl);
            }
            writer.print("\\\"");
            writer.print(">\");");
            writer.println();
            writer.indent();
            writer.print("out.println (\"<PARAM name=\\\"java_code\\\"");
            writer.print(" value=\\\"");
            if (JspUtil.isExpression(code, this.isJspDocument)) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5202));
            }
            if (ExpressionEvaluatorParser.checkEL(code, this.elIgnore)) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5202));
            }
            writer.print(code);
            writer.print("\\\"");
            writer.print(">\");");
            writer.println();
            if (codebase != null) {
                writer.indent();
                writer.print("out.println (\"<PARAM name=\\\"java_codebase\\\"");
                writer.print(" value=\\\"");
                if (JspUtil.isExpression(codebase, this.isJspDocument)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5203));
                }
                if (ExpressionEvaluatorParser.checkEL(codebase, this.elIgnore)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5203));
                }
                writer.print(codebase);
                writer.print("\\\"");
                writer.print(">\");");
                writer.println();
            }
            if (archive != null) {
                writer.indent();
                writer.print("out.println (\"<PARAM name=\\\"java_archive\\\"");
                writer.print(" value=\\\"");
                if (JspUtil.isExpression(archive, this.isJspDocument)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5204));
                }
                if (ExpressionEvaluatorParser.checkEL(archive, this.elIgnore)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5204));
                }
                writer.print(archive);
                writer.print("\\\"");
                writer.print(">\");");
                writer.println();
            }
            writer.indent();
            writer.print("out.println (\"<PARAM name=\\\"type\\\"");
            writer.print(" value=\\\"");
            if (JspUtil.isExpression(type, this.isJspDocument)) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5205));
            }
            if (ExpressionEvaluatorParser.checkEL(type, this.elIgnore)) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5205));
            }
            if (type.equals("applet")) {
                writer.print("application/x-java-applet;");
            } else if (type.equals("bean")) {
                writer.print("application/x-java-bean;");
            }
            if (jreversion != null) {
                writer.print("version=");
                if (JspUtil.isExpression(jreversion, this.isJspDocument)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5206));
                }
                if (ExpressionEvaluatorParser.checkEL(jreversion, this.elIgnore)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5206));
                }
                writer.print(jreversion);
            }
            writer.print("\\\"");
            writer.print(">\");");
            writer.println();
            FallbackParser.FallbackGenerator fallback = null;
            if (this.hasChildren()) {
                enum1 = this.children.elements();
                while (enum1.hasMoreElements()) {
                    gen = (Generator)enum1.nextElement();
                    if (gen instanceof FallbackParser.FallbackGenerator) {
                        fallback = (FallbackParser.FallbackGenerator)gen;
                        continue;
                    }
                    if (gen instanceof JspparamsParser.JspparamsGenerator) {
                        gen.generate(writer, PluginParser.PLUGIN_GEN_PHASE1);
                        continue;
                    }
                    if (gen instanceof VariableCharDataGenerator) {
                        gen.setObsolete();
                        continue;
                    }
                    if (gen instanceof CharDataGenerator) {
                        gen.setObsolete();
                        continue;
                    }
                    throw new JspParseException(this.start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5680));
                }
            }
            writer.println("out.println (\"<COMMENT>\");");
            writer.indent();
            writer.print("out.print (\"<EMBED type=\\\"");
            if (type.equals("applet")) {
                writer.print("application/x-java-applet;");
            } else if (type.equals("bean")) {
                writer.print("application/x-java-bean;");
            }
            if (jreversion != null) {
                writer.print("version=");
                writer.print(jreversion);
            }
            writer.print("\\\" ");
            this.generateCommon(writer, false);
            writer.print("pluginspage=\\\"");
            if (nspluginurl == null) {
                writer.print("http://java.sun.com/products/plugin/");
            } else {
                if (JspUtil.isExpression(nspluginurl, this.isJspDocument)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5207));
                }
                if (ExpressionEvaluatorParser.checkEL(nspluginurl, this.elIgnore)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5207));
                }
                writer.print(nspluginurl);
            }
            writer.print("\\\" ");
            writer.print("java_code=\\\"");
            writer.print(code);
            writer.print("\\\" ");
            if (codebase != null) {
                writer.print("java_codebase=\\\"");
                writer.print(codebase);
                writer.print("\\\" ");
            }
            if (archive != null) {
                writer.print("java_archive=\\\"");
                writer.print(archive);
                writer.print("\\\" ");
            }
            if (this.hasChildren()) {
                enum1 = this.children.elements();
                while (enum1.hasMoreElements()) {
                    gen = (Generator)enum1.nextElement();
                    if (gen instanceof FallbackParser.FallbackGenerator) {
                        fallback = (FallbackParser.FallbackGenerator)gen;
                        continue;
                    }
                    if (gen instanceof JspparamsParser.JspparamsGenerator) {
                        gen.generate(writer, PluginParser.PLUGIN_GEN_PHASE2);
                        continue;
                    }
                    if (gen instanceof VariableCharDataGenerator) {
                        gen.setObsolete();
                        continue;
                    }
                    if (gen instanceof CharDataGenerator) {
                        gen.setObsolete();
                        continue;
                    }
                    throw new JspParseException(this.start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5680));
                }
            }
            writer.print(">\");");
            writer.println();
            writer.println("out.println (\"<NOEMBED>\");");
            writer.println("out.println (\"</COMMENT>\");");
            if (fallback != null) {
                fallback.generate(writer, phase);
            }
            writer.println("out.println (\"</NOEMBED></EMBED>\");");
            writer.println("out.println (\"</OBJECT>\");");
            writer.pushIndent();
            return true;
        }

        private void generateCommon(ServletWriter writer, boolean objectTag) throws JspEngineException {
            String align = this.getAttribute("align");
            String width = this.getAttribute("width");
            String height = this.getAttribute("height");
            String hspace = this.getAttribute("hspace");
            String vspace = this.getAttribute("vspace");
            String title = this.getAttribute("title");
            String name = this.getAttribute("name");
            if (objectTag && title != null) {
                writer.print(" title=\\\"");
                writer.print(title);
                writer.print("\\\" ");
            }
            if (name != null) {
                writer.print(" name=\\\"");
                if (JspUtil.isExpression(name, this.isJspDocument)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5208));
                }
                if (ExpressionEvaluatorParser.checkEL(name, this.elIgnore)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5208));
                }
                writer.print(name);
                writer.print("\\\" ");
            }
            if (width != null) {
                writer.print(" width=\\\"");
                if (JspUtil.isExpression(width, this.isJspDocument)) {
                    writer.print("\" + (" + JspUtil.getExpr(width, this.isJspDocument) + ") + \"");
                } else if (ExpressionEvaluatorParser.checkEL(width, this.elIgnore)) {
                    writer.print("\" + (" + ExpressionEvaluatorParser.generate(width, null, null) + ") + \"");
                } else {
                    writer.print(width);
                }
                writer.print("\\\" ");
            }
            if (height != null) {
                writer.print(" height=\\\"");
                if (JspUtil.isExpression(height, this.isJspDocument)) {
                    writer.print("\" + (" + JspUtil.getExpr(height, this.isJspDocument) + ") + \"");
                } else if (ExpressionEvaluatorParser.checkEL(height, this.elIgnore)) {
                    writer.print("\" + (" + ExpressionEvaluatorParser.generate(height, null, null) + ") + \"");
                } else {
                    writer.print(height);
                }
                writer.print("\\\" ");
            }
            if (hspace != null) {
                writer.print(" hspace=\\\"");
                if (JspUtil.isExpression(hspace, this.isJspDocument)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5209));
                }
                if (ExpressionEvaluatorParser.checkEL(hspace, this.elIgnore)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5209));
                }
                writer.print(hspace);
                writer.print("\\\" ");
            }
            if (vspace != null) {
                writer.print(" vspace=\\\"");
                if (JspUtil.isExpression(vspace, this.isJspDocument)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5210));
                }
                if (ExpressionEvaluatorParser.checkEL(vspace, this.elIgnore)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5210));
                }
                writer.print(vspace);
                writer.print("\\\" ");
            }
            if (align != null) {
                writer.print(" align=\\\"");
                if (JspUtil.isExpression(align, this.isJspDocument)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5211));
                }
                if (ExpressionEvaluatorParser.checkEL(align, this.elIgnore)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5211));
                }
                writer.print(align);
                writer.print("\\\" ");
            }
        }

        public String getAttribute(String name) {
            return this.attrs != null ? (String)this.attrs.get(name) : null;
        }
    }

    private class JspPluginJspAttributeInfo
    implements JspattributeParser.JspAttributeInfo {
        private JspPluginJspAttributeInfo() {
        }

        public boolean isRTExprAttribute(String attrname) {
            return false;
        }

        public boolean isEnableScript(String attrname) {
            return true;
        }

        public boolean isJspFragment(String attrname) {
            return false;
        }
    }
}

