/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Enumeration;
import java.util.Vector;
import jeus.servlet.jsp.compiler.Checker;

final class ScriptingVariableGroup {
    public static int AT_CHILD = -1;
    private ScriptingVariableGroup parent;
    private int depth;
    private Vector varList;

    ScriptingVariableGroup(ScriptingVariableGroup parent, int depth) {
        this.parent = parent;
        this.depth = depth;
        this.varList = new Vector();
    }

    ScriptingVariableGroup getParent() {
        return this.parent;
    }

    boolean isDeclarable(String name, int scope, Checker bc, Checker ctc) {
        boolean declarable = true;
        Enumeration enum1 = this.varList.elements();
        while (enum1.hasMoreElements()) {
            ScriptingVariableInfo already = (ScriptingVariableInfo)enum1.nextElement();
            if (!already.name.equals(name)) continue;
            if (already.scope != 0) {
                if (scope == AT_CHILD) {
                    return false;
                }
                if (bc != null && already.braceChecker != null && bc.isAncestorOf(already.braceChecker)) continue;
                return false;
            }
            if (scope != AT_CHILD || ctc == null || already.customTagChecker == null || ctc.isAncestorOf(already.customTagChecker)) continue;
            return false;
        }
        if (this.parent != null) {
            declarable = this.parent.isDeclarable(name, AT_CHILD, bc, ctc);
        }
        if (declarable) {
            if (scope != AT_CHILD) {
                ScriptingVariableInfo info = new ScriptingVariableInfo(name, scope, bc, ctc);
                this.varList.add(info);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "<SVGroup(" + super.toString() + ") [depth = " + this.depth + ", parent = " + this.parent + "]";
    }

    private class ScriptingVariableInfo {
        String name;
        int scope;
        Checker braceChecker;
        Checker customTagChecker;

        ScriptingVariableInfo(String name, int scope, Checker braceChecker, Checker customTagChecker) {
            this.name = name;
            this.scope = scope;
            this.braceChecker = braceChecker;
            this.customTagChecker = customTagChecker;
        }

        public String toString() {
            return "<SVInfo:name[" + this.name + "] scope[" + this.scope + "]";
        }
    }
}

