/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.CharArrayWriter;
import java.util.Hashtable;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Checker;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class ScriptletParser
extends Parser {
    private static final String OPEN_SCRIPTLET = "<%";
    private static final String CLOSE_SCRIPTLET = "%>";
    private static final String XML_OPEN_SCRIPTLET = "<jsp:scriptlet";
    private static final String XML_CLOSE_SCRIPTLET = "</jsp:scriptlet>";

    public ScriptletParser() {
    }

    public ScriptletParser(boolean _isInvalidated) {
        super(_isInvalidated);
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        char[] data;
        String close;
        String open;
        boolean isJspDocument;
        boolean bl = isJspDocument = xmlViewer == null;
        if (isJspDocument) {
            open = XML_OPEN_SCRIPTLET;
            close = XML_CLOSE_SCRIPTLET;
        } else {
            open = OPEN_SCRIPTLET;
            close = CLOSE_SCRIPTLET;
        }
        boolean xmlOpen = false;
        if (!reader.matches(XML_OPEN_SCRIPTLET)) {
            if (!reader.matches(OPEN_SCRIPTLET)) {
                return false;
            }
            xmlOpen = false;
            open = OPEN_SCRIPTLET;
            close = CLOSE_SCRIPTLET;
        } else {
            xmlOpen = true;
            open = XML_OPEN_SCRIPTLET;
            close = XML_CLOSE_SCRIPTLET;
        }
        if (this.isInvalidated) {
            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5212));
        }
        Mark start = null;
        Mark stop = null;
        reader.advance(open.length());
        if (xmlOpen) {
            Hashtable attrs = reader.parseTagAttributes();
            if (!reader.matches(">")) {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)open));
            }
            reader.advance(1);
        }
        start = reader.mark();
        if (xmlOpen) {
            XmlScriptletParser xsp = new XmlScriptletParser(reader);
            data = xsp.process();
            parser.flushCharData();
        } else {
            start = reader.mark();
            stop = reader.skipUntil(close);
            if (stop == null) {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)open));
            }
            parser.flushCharData();
            xmlViewer.addScriptlet(reader, start, stop);
            data = reader.getChars(start, stop);
            codeGen.currentBrace = Checker.checkBrace(codeGen.currentBrace, data);
        }
        ScriptletGenerator gen = new ScriptletGenerator(data, start, stop);
        codeGen.addGenerator(gen, "ServiceMethodPhase");
        return true;
    }

    class ScriptletGenerator
    extends Generator {
        char[] chars;

        public ScriptletGenerator(char[] chars, Mark start, Mark stop) {
            this.start = start;
            this.stop = stop;
            this.chars = chars;
        }

        public boolean generate(ServletWriter writer, String phase) {
            writer.printMultiLn(new String(JspUtil.removeQuotes(this.chars)));
            return true;
        }
    }

    class XmlScriptletParser {
        private static final String CDATA_START = "<![CDATA[";
        private static final String CDATA_END = "]]>";
        private static final String TEXT_START = "<jsp:text>";
        private static final String TEXT_END = "</jsp:text>";
        private JspReader reader;

        XmlScriptletParser(JspReader reader) {
            this.reader = reader;
        }

        char[] process() throws JspParseException {
            CharArrayWriter caw = new CharArrayWriter();
            Mark start = this.reader.mark();
            while (true) {
                if (this.reader.matches(CDATA_START)) {
                    this.reader.advance(CDATA_START.length());
                    this.processCdata(caw);
                    continue;
                }
                if (this.reader.matches(TEXT_START)) {
                    this.reader.advance(TEXT_START.length());
                    this.processText(caw);
                    continue;
                }
                if (this.reader.matches(ScriptletParser.XML_CLOSE_SCRIPTLET)) break;
                int ch = this.reader.nextChar();
                if (ch < 0) {
                    throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)ScriptletParser.XML_OPEN_SCRIPTLET));
                }
                caw.write(ch);
            }
            this.reader.advance(ScriptletParser.XML_CLOSE_SCRIPTLET.length());
            return caw.toCharArray();
        }

        private void processText(CharArrayWriter caw) throws JspParseException {
            Mark start = this.reader.mark();
            while (true) {
                if (this.reader.matches(CDATA_START)) {
                    this.reader.advance(CDATA_START.length());
                    this.processCdata(caw);
                    continue;
                }
                if (this.reader.matches(TEXT_END)) {
                    this.reader.advance(TEXT_END.length());
                    return;
                }
                int ch = this.reader.nextChar();
                if (ch < 0) {
                    throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)TEXT_START));
                }
                caw.write(ch);
            }
        }

        private void processCdata(CharArrayWriter caw) throws JspParseException {
            Mark start = this.reader.mark();
            while (true) {
                if (this.reader.matches(CDATA_END)) {
                    this.reader.advance(CDATA_END.length());
                    return;
                }
                int ch = this.reader.nextChar();
                if (ch < 0) {
                    throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)CDATA_START));
                }
                caw.write(ch);
            }
        }
    }
}

