/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import jeus.servlet.jsp.JspEngineException;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class TagCache {
    String shortTagName;
    Hashtable methodMaps;
    Hashtable lowerMethodMaps;
    Hashtable propertyEditorMaps;
    BeanInfo tagClassInfo;
    Class tagHandlerClass;

    TagCache(String shortTagName) {
        this.shortTagName = shortTagName;
        this.methodMaps = new Hashtable();
        this.lowerMethodMaps = new Hashtable();
        this.propertyEditorMaps = new Hashtable();
    }

    private void addSetterMethod(String attrName, Method m) {
        this.methodMaps.put(attrName, m);
    }

    private void addLowerSetterMethod(String attrName, Method m) {
        this.lowerMethodMaps.put(attrName, m);
    }

    private void addPropertyEditor(String attrName, Class peClass) {
        this.propertyEditorMaps.put(attrName, peClass);
    }

    Method getSetterMethod(String attrName) {
        Method m = (Method)this.methodMaps.get(attrName);
        if (m != null) {
            return m;
        }
        m = (Method)this.lowerMethodMaps.get(attrName.toLowerCase());
        if (m != null) {
            return m;
        }
        char[] tmp = attrName.toCharArray();
        if (tmp.length > 0) {
            tmp[0] = Character.toUpperCase(tmp[0]);
            String methodName = "set" + new String(tmp);
            Class<String> type = String.class;
            try {
                m = this.tagHandlerClass.getMethod(methodName, type);
                if (m != null) {
                    this.methodMaps.put(attrName, m);
                }
            }
            catch (NoSuchMethodException nme) {
                m = null;
            }
        }
        return m;
    }

    Class getPropertyEditorClass(String attrName) {
        return (Class)this.propertyEditorMaps.get(attrName);
    }

    void setTagHandlerClass(Class tagHandlerClass) throws JspEngineException {
        try {
            this.tagClassInfo = Introspector.getBeanInfo(tagHandlerClass);
            this.tagHandlerClass = tagHandlerClass;
            PropertyDescriptor[] pd = this.tagClassInfo.getPropertyDescriptors();
            for (int i = 0; i < pd.length; ++i) {
                String name = pd[i].getName();
                String lowerName = pd[i].getName();
                lowerName = lowerName.toLowerCase();
                if (pd[i].getWriteMethod() != null) {
                    this.addSetterMethod(name, pd[i].getWriteMethod());
                    this.addLowerSetterMethod(lowerName, pd[i].getWriteMethod());
                }
                if (pd[i].getPropertyEditorClass() == null) continue;
                this.addPropertyEditor(name, pd[i].getPropertyEditorClass());
            }
        }
        catch (IntrospectionException ex) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5609, (Object[])new String[]{tagHandlerClass.getName(), ex.getMessage()}));
        }
    }

    Class getTagHandlerClass() {
        return this.tagHandlerClass;
    }

    BeanInfo getTagClassInfo() {
        return this.tagClassInfo;
    }
}

