/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.File;
import java.io.InputStream;
import java.util.StringTokenizer;
import jeus.servlet.engine.Context;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.TagInfoData;
import jeus.servlet.jsp.compiler.TagFileInfoImpl;
import jeus.servlet.loader.JspReloader;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;

public class TagFileClassHandler {
    private static final String GENERATOR_VERSION = "_600_";
    public static final String TAGWORK_DIR = "jeus_tagwork";
    private static final String PKGNAME_PREFIX = "jeus_tagfile";
    private JspEngine jspEngine;
    private Context context;
    private TagFileInfoImpl tagFileInfo;
    private String tagFileRelativePath;
    private String jarFileName;
    private File realTagFile;
    private String handlerClassName;
    private String handlerPackageName;
    private String fqnClassName;
    private String handlerJavaFileName;
    private String handlerClassFileName;
    private File handlerClassFile;

    public TagFileClassHandler(JspEngine engine, TagFileInfoImpl tagFileInfo, String tagFileRelativePath, String jarFileName) throws JspEngineException {
        this.jspEngine = engine;
        this.context = engine.getContext();
        this.tagFileInfo = tagFileInfo;
        this.tagFileRelativePath = tagFileRelativePath;
        this.jarFileName = jarFileName;
        this.init();
    }

    private void init() throws JspEngineException {
        if (this.jarFileName == null) {
            String realpath = this.context.getRealPath(this.tagFileRelativePath);
            this.realTagFile = new File(realpath);
            if (!this.realTagFile.exists()) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5214, (Object)realpath));
            }
            int pos = "/WEB-INF/tags/".length();
            String tmp = this.tagFileRelativePath.substring(pos);
            this.generateClassName(tmp);
        } else {
            String realpath = this.context.getRealPath(this.jarFileName);
            this.realTagFile = new File(realpath);
            if (!this.realTagFile.exists()) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5214, (Object)realpath));
            }
            InputStream in = this.context.getResourceAsStream(this.jarFileName);
            if (in == null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5215, (Object)this.jarFileName));
            }
            int pos = "/META-INF/tags/".length();
            String tmp = this.tagFileRelativePath.substring(pos);
            this.generateClassName(tmp);
        }
    }

    private void generateClassName(String pathName) {
        String compileoutdir;
        int pos;
        if ((pathName = pathName.replace('-', '_')).charAt(0) == '/') {
            pathName = pathName.substring(1);
        }
        if ((pos = pathName.lastIndexOf(46)) >= 0) {
            String _extension = pathName.substring(pos + 1);
            pathName = _extension != null && _extension.length() != 0 ? pathName.substring(0, pos) + "_" + _extension : pathName.substring(0, pos);
        }
        StringBuffer fullName = new StringBuffer();
        StringTokenizer parser = new StringTokenizer(pathName, "/");
        fullName.append("jeus_tagfile.");
        if (parser.hasMoreTokens()) {
            String token;
            while (true) {
                token = parser.nextToken();
                if (!parser.hasMoreTokens()) break;
                token = "_" + JspReloader.convertSpecialCharacter(token) + ".";
                fullName.append(token);
            }
            token = GENERATOR_VERSION + JspReloader.convertSpecialCharacter(token);
            fullName.append(token);
        }
        String tmp = fullName.toString();
        pos = tmp.lastIndexOf(".");
        this.fqnClassName = tmp;
        this.handlerClassName = tmp.substring(pos + 1);
        this.handlerPackageName = tmp.substring(0, pos);
        String jspworkdir = this.jspEngine.getJspConfig().getJspWorkDir().getPath();
        if (jspworkdir.endsWith("/") || jspworkdir.endsWith("\\")) {
            jspworkdir = jspworkdir.substring(0, jspworkdir.length() - 1);
        }
        if ((compileoutdir = this.jspEngine.getJspConfig().getCompileOutputDir()).endsWith("/") || compileoutdir.endsWith("\\")) {
            compileoutdir = compileoutdir.substring(0, compileoutdir.length() - 1);
        }
        tmp = tmp.replace('.', File.separatorChar);
        this.handlerJavaFileName = jspworkdir + File.separator + TAGWORK_DIR + File.separator + tmp + ".java";
        this.handlerClassFileName = compileoutdir + File.separator + TAGWORK_DIR + File.separator + tmp + ".class";
        this.handlerClassFile = new File(this.handlerClassFileName);
    }

    public void setTagInfoData(TagInfoData info) {
        this.tagFileInfo.setTagInfoData(info);
    }

    public TagFileInfoImpl getTagFileInfo() {
        return this.tagFileInfo;
    }

    public String getFQNClassName() {
        return this.fqnClassName;
    }

    public String getHandlerClassName() {
        return this.handlerClassName;
    }

    public String getHandlerPackageName() {
        return this.handlerPackageName;
    }

    public String getHandlerJavaFileName() {
        return this.handlerJavaFileName;
    }

    public String getHandlerClassFileName() {
        return this.handlerClassFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkHandlerClass(String _contentType) throws JspEngineException {
        if (this.tagFileInfo.getTagInfoData() == null || !this.handlerClassFile.exists() || this.handlerClassFile.lastModified() < this.realTagFile.lastModified()) {
            TagFileClassHandler tagFileClassHandler = this;
            synchronized (tagFileClassHandler) {
                if (!this.handlerClassFile.exists() || this.handlerClassFile.lastModified() < this.realTagFile.lastModified()) {
                    this.jspEngine.parseAndCompileTagFile(this, _contentType);
                } else if (this.tagFileInfo.getTagInfoData() == null) {
                    this.jspEngine.parseTagFile(this, null, _contentType);
                }
            }
        }
    }
}

