/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import jeus.servlet.jsp.JspDefaultConstants;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspEngineContext;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.TagInfoData;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.TagFileClassHandler;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;

public class TagFileCodeGenerator
extends CodeGenerator {
    private HashMap tagAttributes = new HashMap();
    private ArrayList tagVariables = new ArrayList();
    private HashMap tagVarAliases = new HashMap();
    private TagFileClassHandler tagFileClassHandler;
    private String bodyContent = "scriptless";
    private String displayName = null;
    private boolean dynamicAttributes = false;
    private String dynamicAttributesName = null;
    private String smallIcon = null;
    private String largeIcon = null;
    private String description = null;
    private String example = null;

    public TagFileCodeGenerator(JspEngine engine, JspReader reader, ServletWriter writer, TagFileClassHandler handler) {
        super(engine, null, reader, writer);
        this.tagFileClassHandler = handler;
    }

    public ArrayList getTagVariables() {
        return this.tagVariables;
    }

    private void setTagInfoData() {
        TagAttributeInfo[] tai = new TagAttributeInfo[this.tagAttributes.size()];
        Iterator it = this.tagAttributes.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            TagAttributeInfo info = (TagAttributeInfo)it.next();
            tai[i++] = info;
        }
        TagVariableInfo[] tvi = new TagVariableInfo[this.tagVariables.size()];
        for (i = 0; i < tvi.length; ++i) {
            tvi[i] = (TagVariableInfo)this.tagVariables.get(i);
        }
        this.tagFileClassHandler.setTagInfoData(new TagInfoData(this.tagFileClassHandler.getTagFileInfo().getName(), this.tagFileClassHandler.getFQNClassName(), this.bodyContent, this.description, null, tai, this.displayName, this.smallIcon, this.largeIcon, tvi, this.dynamicAttributes, this.example));
    }

    public void beginPageProcessing() throws JspEngineException {
        for (int i = 0; i < JspDefaultConstants.STANDARD_IMPORTS.length; ++i) {
            this.imports.addElement(JspDefaultConstants.STANDARD_IMPORTS[i]);
        }
    }

    public void endPageProcessing() throws JspEngineException {
        this.generateHeader();
        this.writer.println();
        this.generateAll("ServiceMethodPhase");
        this.writer.println();
        this.generateFooter();
        this.setTagInfoData();
        this.checkNameDuplication();
    }

    private void checkNameDuplication() throws JspEngineException {
        for (TagVariableInfo vi : this.tagVariables) {
            String viName = vi.getNameGiven();
            Object dup = this.tagAttributes.get(viName);
            if (dup == null) continue;
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5216, (Object)viName));
        }
    }

    private void generateHeader() throws JspEngineException {
        String pkgname = this.tagFileClassHandler.getHandlerPackageName();
        String clsname = this.tagFileClassHandler.getHandlerClassName();
        this.writer.println("package " + pkgname + ";");
        this.writer.println();
        Enumeration e = this.imports.elements();
        Hashtable<String, Boolean> dup = new Hashtable<String, Boolean>();
        while (e.hasMoreElements()) {
            String imp = (String)e.nextElement();
            if (dup.get(imp) != null) continue;
            dup.put(imp, new Boolean(true));
            this.writer.println("import " + imp + ";");
        }
        this.writer.println();
        this.writer.println();
        this.writer.println("public class " + clsname);
        this.writer.println("    extends javax.servlet.jsp.tagext.SimpleTagSupport");
        if (this.dynamicAttributes) {
            this.writer.println("    implements javax.servlet.jsp.tagext.DynamicAttributes");
        }
        this.writer.println("{");
        this.writer.pushIndent();
        this.writer.println();
        this.generateAttributes();
        if (this.dynamicAttributes) {
            this.generateSetDynamic();
        }
        this.generateAll("ClassDeclarationPhase");
        this.writer.println();
        this.writer.println("protected JspContext jspContext;");
        this.writer.println("public void setJspContext(JspContext ctx) {");
        this.writer.pushIndent();
        this.writer.println("super.setJspContext(ctx);");
        this.writer.println("this.jspContext = new jeus.servlet.jsp.JspContextWrapper(ctx);");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("public JspContext getJspContext() {");
        this.writer.pushIndent();
        this.writer.println("return this.jspContext;");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println();
        this.writer.println("public void doTag() throws JspException, IOException {");
        this.writer.pushIndent();
        this.writer.println("java.lang.Object jspValue;");
        this.writer.println("JspContext jspContext = getJspContext();");
        this.writer.println("PageContext pageContext = (PageContext)getJspContext();");
        this.writer.println("PageContext _jspParentContext = (PageContext)super.getJspContext();");
        this.writer.println("HttpServletRequest request = null;");
        this.writer.println("HttpServletResponse response = null;");
        this.writer.println("HttpSession session = null;");
        this.writer.println("ServletContext application = null;");
        this.writer.println("ServletConfig config = null;");
        this.writer.println("javax.servlet.jsp.JspWriter out = null;");
        this.writer.println("java.io.Writer _jspSout = null;");
        this.writer.println();
        this.writer.println("try {");
        this.writer.pushIndent();
        this.writer.println("request = (HttpServletRequest)_jspParentContext.getRequest();");
        this.writer.println("response = (HttpServletResponse)_jspParentContext.getResponse();");
        this.writer.println("session = _jspParentContext.getSession();");
        this.writer.println("application = _jspParentContext.getServletContext();");
        this.writer.println("config = _jspParentContext.getServletConfig();");
        this.writer.println("out = jspContext.getOut();");
        for (TagAttributeInfo info : this.tagAttributes.values()) {
            String name = info.getName();
            char[] n = name.toCharArray();
            n[0] = Character.toUpperCase(n[0]);
            String name2 = new String(n);
            this.writer.println("if (get" + name2 + "() != null) ");
            this.writer.pushIndent();
            this.writer.println("jspContext.setAttribute(\"" + name + "\", get" + name2 + "());");
            this.writer.popIndent();
        }
    }

    private void generateAttributes() {
        this.writer.println();
        this.writer.println("// attributes");
        for (TagAttributeInfo info : this.tagAttributes.values()) {
            this.writer.println("private " + info.getTypeName() + " " + info.getName() + ";");
        }
        Iterator it = this.tagAttributes.values().iterator();
        this.writer.println();
        this.writer.println("// setters and getters for attributes");
        while (it.hasNext()) {
            TagAttributeInfo info;
            info = (TagAttributeInfo)it.next();
            String type = info.getTypeName();
            String name = info.getName();
            char[] n = name.toCharArray();
            n[0] = Character.toUpperCase(n[0]);
            String name2 = new String(n);
            this.writer.println("public void set" + name2 + "(" + type + " " + name + ") {");
            this.writer.pushIndent();
            this.writer.println("this." + name + " = " + name + ";");
            this.writer.popIndent();
            this.writer.println("}");
            this.writer.println();
            this.writer.println("public " + type + " get" + name2 + "() {");
            this.writer.pushIndent();
            this.writer.println("return " + name + ";");
            this.writer.popIndent();
            this.writer.println("}");
            this.writer.println();
        }
    }

    private void generateSetDynamic() {
        this.writer.println("public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {");
        this.writer.pushIndent();
        this.writer.println("if (uri != null) return;");
        this.writer.println("Map map = (Map)jspContext.getAttribute(\"" + this.dynamicAttributesName + "\");");
        this.writer.println("if (map == null) {");
        this.writer.pushIndent();
        this.writer.println("map = new java.util.HashMap();");
        this.writer.println("jspContext.setAttribute(\"" + this.dynamicAttributesName + "\", map);");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("map.put(localName, value);");
        this.writer.popIndent();
        this.writer.println("}");
    }

    private void generateFooter() throws JspEngineException {
        this.writer.popIndent();
        this.writer.println("} catch (Throwable t) {");
        this.writer.pushIndent();
        this.writer.println("if (t instanceof JspException)");
        this.writer.pushIndent();
        this.writer.println("throw (JspException)t;");
        this.writer.popIndent();
        this.writer.println("else if (t instanceof IllegalStateException)");
        this.writer.pushIndent();
        this.writer.println("throw (IllegalStateException)t;");
        this.writer.popIndent();
        this.writer.println("else");
        this.writer.pushIndent();
        this.writer.println("throw new JspException(t);");
        this.writer.popIndent();
        this.writer.println("} finally {");
        this.writer.pushIndent();
        for (TagVariableInfo info : this.tagVariables) {
            if (info.getScope() != 1 && info.getScope() != 2) continue;
            String name = info.getNameGiven();
            this.writer.println("if ((jspValue = jspContext.getAttribute(\"" + name + "\")) != null) {");
            this.writer.pushIndent();
            this.writer.println("_jspParentContext.setAttribute(\"" + name + "\", jspValue);");
            this.writer.popIndent();
            this.writer.println("} else {");
            this.writer.pushIndent();
            this.writer.println("_jspParentContext.removeAttribute(\"" + name + "\", PageContext.PAGE_SCOPE);");
            this.writer.popIndent();
            this.writer.println("}");
        }
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.generateSplittedFunctions();
        this.generateAll("TemplateStringDeclarationPhase");
        this.writer.popIndent();
        this.writer.println("}");
    }

    public void handleDirective(String directive, Mark start, Mark stop, Hashtable attrs) throws JspEngineException {
        if (directive.equals("tag")) {
            this.handleTagDirective(start, stop, attrs);
        }
        if (directive.equals("taglib")) {
            this.handleTaglibDirective(start, stop, attrs);
        }
        if (directive.equals("include")) {
            this.handleIncludeDirective(start, stop, attrs);
        }
        if (directive.equals("attribute")) {
            this.handleAttributeDirective(start, stop, attrs);
        }
        if (directive.equals("variable")) {
            this.handleVariableDirective(start, stop, attrs);
        }
    }

    private void handleTagDirective(Mark start, Mark stop, Hashtable attrs) throws JspEngineException {
        Enumeration e = attrs.keys();
        while (e.hasMoreElements()) {
            Vector value;
            String attr = (String)e.nextElement();
            if (attr.equalsIgnoreCase("display-name")) {
                value = (Vector)attrs.get(attr);
                this.displayName = (String)value.get(0);
                continue;
            }
            if (attr.equalsIgnoreCase("body-content")) {
                value = (Vector)attrs.get(attr);
                this.bodyContentHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("dynamic-attributes")) {
                value = (Vector)attrs.get(attr);
                this.dynamicAttributesHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("small-icon")) {
                value = (Vector)attrs.get(attr);
                this.smallIcon = (String)value.get(0);
                continue;
            }
            if (attr.equalsIgnoreCase("large-icon")) {
                value = (Vector)attrs.get(attr);
                this.largeIcon = (String)value.get(0);
                continue;
            }
            if (attr.equalsIgnoreCase("description")) {
                value = (Vector)attrs.get(attr);
                this.description = (String)value.get(0);
                continue;
            }
            if (attr.equalsIgnoreCase("example")) {
                value = (Vector)attrs.get(attr);
                this.example = (String)value.get(0);
                continue;
            }
            if (attr.equalsIgnoreCase("language")) {
                value = (Vector)attrs.get(attr);
                this.languageHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("import")) {
                value = (Vector)attrs.get(attr);
                this.importHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("pageEncoding")) {
                value = (Vector)attrs.get(attr);
                this.pageEncodingHandler(value);
                continue;
            }
            if (!attr.equalsIgnoreCase("isELIgnored")) continue;
            value = (Vector)attrs.get(attr);
            this.isELIgnoredHandler(value);
        }
    }

    private void handleAttributeDirective(Mark start, Mark stop, Hashtable attrs) throws JspEngineException {
        TagAttributeInfo info;
        TagAttributeInfo old;
        Enumeration e = attrs.keys();
        String name = null;
        boolean required = false;
        boolean fragment = false;
        boolean rtexprvalue = true;
        String type = "java.lang.String";
        while (e.hasMoreElements()) {
            Vector value;
            String attr = (String)e.nextElement();
            if (attr.equalsIgnoreCase("name")) {
                value = (Vector)attrs.get(attr);
                name = (String)value.get(0);
                continue;
            }
            if (attr.equalsIgnoreCase("required")) {
                value = (Vector)attrs.get(attr);
                required = Boolean.valueOf((String)value.get(0));
                continue;
            }
            if (attr.equalsIgnoreCase("fragment")) {
                value = (Vector)attrs.get(attr);
                fragment = Boolean.valueOf((String)value.get(0));
                continue;
            }
            if (attr.equalsIgnoreCase("rtexprvalue")) {
                value = (Vector)attrs.get(attr);
                rtexprvalue = Boolean.valueOf((String)value.get(0));
                continue;
            }
            if (!attr.equalsIgnoreCase("type")) continue;
            value = (Vector)attrs.get(attr);
            type = (String)value.get(0);
        }
        if (name == null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5217));
        }
        if (fragment) {
            type = "javax.servlet.jsp.tagext.JspFragment";
        }
        if ((old = this.tagAttributes.put(name, info = new TagAttributeInfo(name, required, type, rtexprvalue, fragment))) != null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5218, (Object)name));
        }
    }

    private void dynamicAttributesHandler(Vector value) {
        this.dynamicAttributesName = (String)value.get(0);
        if (this.dynamicAttributesName != null) {
            this.dynamicAttributes = true;
        }
    }

    private void bodyContentHandler(Vector value) throws JspEngineException {
        this.bodyContent = (String)value.get(0);
        if (!(this.bodyContent.equals("scriptless") || this.bodyContent.equals("empty") || this.bodyContent.equals("tagdependent"))) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5219, (Object)this.bodyContent));
        }
    }

    private void handleVariableDirective(Mark start, Mark stop, Hashtable attrs) throws JspEngineException {
        Enumeration e = attrs.keys();
        String nameGiven = null;
        String nameFromAttribute = null;
        String alias = null;
        String variableClass = "java.lang.String";
        boolean declare = true;
        int scope = 0;
        while (e.hasMoreElements()) {
            Vector value;
            String attr = (String)e.nextElement();
            if (attr.equalsIgnoreCase("name-given")) {
                value = (Vector)attrs.get(attr);
                nameGiven = (String)value.get(0);
                continue;
            }
            if (attr.equalsIgnoreCase("name-from-attribute")) {
                value = (Vector)attrs.get(attr);
                nameFromAttribute = (String)value.get(0);
                continue;
            }
            if (attr.equalsIgnoreCase("alias")) {
                value = (Vector)attrs.get(attr);
                alias = (String)value.get(0);
                continue;
            }
            if (attr.equalsIgnoreCase("variable-class")) {
                value = (Vector)attrs.get(attr);
                variableClass = (String)value.get(0);
                continue;
            }
            if (attr.equalsIgnoreCase("declare")) {
                value = (Vector)attrs.get(attr);
                declare = Boolean.valueOf((String)value.get(0));
                continue;
            }
            if (!attr.equalsIgnoreCase("scope")) continue;
            value = (Vector)attrs.get(attr);
            String v = (String)value.get(0);
            if (v.equals("AT_BEGIN")) {
                scope = 1;
                continue;
            }
            if (v.equals("AT_END")) {
                scope = 2;
                continue;
            }
            scope = 0;
        }
        if (nameGiven == null && nameFromAttribute == null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5220));
        }
        if (nameGiven != null && nameFromAttribute != null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5220));
        }
        if (alias != null && nameFromAttribute == null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5221));
        }
        TagVariableInfo info = new TagVariableInfo(nameGiven, nameFromAttribute, variableClass, declare, scope);
        this.tagVariables.add(info);
        if (alias != null) {
            this.tagVarAliases.put(alias, info);
        }
    }

    public TagFileClassHandler getTagFileClassHandler() {
        return this.tagFileClassHandler;
    }

    public JspEngineContext getCtxt() {
        return null;
    }
}

