/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.server.RootClassLoader;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.manager.JeusVersion;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.WebContainerDescriptor;
import jeus.servlet.deployment.descriptor.bind.WebMainDescriptorJB;
import jeus.servlet.jsp.compiler.JavacJavaCompiler;
import jeus.servlet.jsp.compiler.JspCompileException;
import jeus.servlet.jsp.compiler.batch.CompileFailedException;
import jeus.servlet.jsp.compiler.batch.CompileManager;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusException;
import jeus.util.JeusRootClassLoader;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.util.properties.JeusAppProperties;

public class BatchCompiler {
    public static final String WEBADMIN_CTXGRP_NAME = "classes";
    private boolean standaloneMode = false;
    private boolean multiEngineMode = false;
    private String engineName = null;
    private String contextGroupName = null;
    private String contextName = null;
    private String contextSubPath = null;
    private String listFile = null;
    private String classPaths = null;
    private String rootDir = null;
    private String outputDir = null;
    private String jspSource = null;
    private CompileManager compiler = null;
    private String currentDirectory = null;
    private File source = null;
    private boolean compileWebAdmin = false;
    private static final String JSP_MAPS_JAVA_FILE = "WebAdminJsps.java";
    private String compileOption;
    public static boolean EXIT_ON_ERROR = false;

    public BatchCompiler() throws StartingException {
        if (JeusBootstrapProperties.JEUS_HOME == null) {
            throw new StartingException(2110);
        }
        File file = new File(".");
        this.currentDirectory = file.getAbsolutePath();
    }

    public void configure() throws StartingException, Throwable {
        this.compiler = new CompileManager(this.compileOption);
        this.compiler.initConstants(this.engineName, this.standaloneMode, false);
        this.compiler.setConfigByXML(true);
        String configPath = null;
        configPath = this.compiler.CONFIG_DIR + File.separator + "WEBMain.xml";
        File tmpConfigPath = new File(configPath);
        if (!tmpConfigPath.exists()) {
            throw new StartingException(2115, new String[]{configPath});
        }
        if (tmpConfigPath.isDirectory()) {
            throw new StartingException(2116, new String[]{configPath});
        }
        this.compiler.setConfigFile(tmpConfigPath);
        WebContainerDescriptor desc = WebMainDescriptorJB.getWebMainDescriptor(this.engineName);
        this.compiler.setWebContainerDescriptor(desc);
        this.compiler.startContainer(this.compileWebAdmin, this.contextGroupName, this.contextName);
        try {
            if (this.contextName != null && this.contextGroupName != null && this.contextSubPath != null) {
                this.compiler.startCompile(this.contextGroupName, this.contextName, (PrintWriter)null, this.contextSubPath);
            } else if (this.contextName != null && this.contextGroupName != null && this.listFile != null) {
                this.compiler.startCompile(this.contextGroupName, this.contextName, null, new File(this.listFile));
            } else if (this.contextName != null && this.contextGroupName != null) {
                this.compiler.startCompile(this.contextGroupName, this.contextName, null);
            } else if (this.contextGroupName != null) {
                this.compiler.startCompile(this.contextGroupName);
            } else {
                this.compiler.startCompile();
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    private void compileJspMapsFile() throws JspCompileException {
        String classpath = JeusBootstrapProperties.JEUS_HOME + File.separator + WEBADMIN_CTXGRP_NAME;
        String mapJava = JeusBootstrapProperties.JEUS_HOME + File.separator + WEBADMIN_CTXGRP_NAME + File.separator + "jeus" + File.separator + "tool" + File.separator + "webadmin" + File.separator + "init" + File.separator + JSP_MAPS_JAVA_FILE;
        System.out.println("[BatchCompiler] compiling " + mapJava + "...");
        String fs = File.separator;
        JavacJavaCompiler compiler = null;
        compiler = fs.startsWith("/") ? new JavacJavaCompiler(classpath, null, classpath, JeusAppProperties.APP_COMPILER_OPTION, mapJava) : new JavacJavaCompiler("\"" + classpath + "\"", null, classpath, JeusAppProperties.APP_COMPILER_OPTION, mapJava);
        compiler.compile();
    }

    public void parseArgs(String[] args) throws StartingException {
        Object arg = null;
        Object argName = null;
        Object argValue = null;
        if (args.length <= 0) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-webadmin")) {
                this.compileWebAdmin = true;
                continue;
            }
            if (args[i].equals("-q")) {
                EXIT_ON_ERROR = true;
                continue;
            }
            if (args[i].equals("-e")) {
                if (++i == args.length) {
                    throw new StartingException(2118);
                }
                this.engineName = args[i];
                continue;
            }
            if (args[i].equals("-g")) {
                if (++i == args.length) {
                    throw new StartingException("no context group name");
                }
                this.contextGroupName = args[i];
                continue;
            }
            if (args[i].equals("-c")) {
                if (++i == args.length) {
                    throw new StartingException("no context name");
                }
                this.contextName = args[i];
                continue;
            }
            if (args[i].equals("-p")) {
                if (++i == args.length) {
                    throw new StartingException("no sub-path");
                }
                if (!args[i].startsWith("/")) {
                    throw new StartingException("-p path must start with '/'");
                }
                this.contextSubPath = args[i];
                continue;
            }
            if (args[i].equals("-l")) {
                if (++i == args.length) {
                    throw new StartingException("no listfile");
                }
                this.listFile = args[i];
                continue;
            }
            if (args[i].equals("-k")) {
                if (++i == args.length) {
                    throw new StartingException("no classpaths");
                }
                this.classPaths = args[i];
                continue;
            }
            if (args[i].equals("-r")) {
                if (++i == args.length) {
                    throw new StartingException("no rootdir");
                }
                this.rootDir = args[i];
                continue;
            }
            if (args[i].equals("-d")) {
                if (++i == args.length) {
                    throw new StartingException("no outdir");
                }
                this.outputDir = args[i];
                continue;
            }
            if (args[i].equals("-co")) {
                if (++i == args.length) {
                    throw new StartingException("no extra compile option");
                }
                this.compileOption = args[i];
                this.compileOption = this.compileOption.replace(',', ' ');
                continue;
            }
            if (args[i].equals("-s")) {
                if (++i == args.length) {
                    throw new StartingException("no jsp_source");
                }
                this.jspSource = args[i];
                continue;
            }
            if (args[i].equals("-h") || args[i].equals("-?") || args[i].equals("-help")) {
                BatchCompiler.printUsage();
                continue;
            }
            if (!args[i].equals("-v") && !args[i].equals("-ver") && !args[i].equals("-version")) continue;
            BatchCompiler.printVersion();
        }
        if (this.engineName == null) {
            throw new StartingException("-e engine_name required");
        }
        if (this.compileWebAdmin) {
            this.jspSource = "/jeus/tool/webadmin/jsps";
            this.rootDir = JeusBootstrapProperties.JEUS_HOME + File.separator + WEBADMIN_CTXGRP_NAME + File.separator;
            this.outputDir = JeusBootstrapProperties.JEUS_HOME + File.separator + WEBADMIN_CTXGRP_NAME + File.separator;
        }
        if (this.jspSource == null && this.engineName == null) {
            throw new StartingException(2810);
        }
        if (this.jspSource != null) {
            if (!this.jspSource.startsWith("/")) {
                throw new StartingException(2811, File.separator);
            }
            if (this.rootDir == null) {
                this.rootDir = this.currentDirectory;
            }
            if (this.outputDir == null) {
                this.outputDir = this.currentDirectory;
            }
        }
        this.setContainerMode("true");
    }

    private void setContainerMode(String mode) throws StartingException {
        if (mode != null && mode.equals("true")) {
            this.standaloneMode = true;
        }
        if (this.engineName == null) {
            this.engineName = "precompile_servlet_engine1";
        }
    }

    private static void printUsage() {
        System.out.println("JEUS Web Container version: " + JeusVersion.getVersion());
        System.out.println("jspc -e engine_name [-g grpname [-c ctxname [-p path | -l listfile]]] ");
        System.out.println("     [-q] [-co \"javac options\"]");
        System.out.println("  * pre-compile the jsp files of context ctxname of contextGroup grpname");
        System.out.println("  * if path omitted, entire jsp file of ctxname will be pre-compiled");
        System.out.println("  * if ctxname omitted, entire contexts of grpname will be pre-compiled");
        System.out.println("  * if ctxname and grpname omitted, entire contexts of engine_name will ");
        System.out.println("  * be pre-compiled");
        System.out.println("    -e                servlet engine name");
        System.out.println("    -g                context group name to compile");
        System.out.println("    -c                context name to compile");
        System.out.println("    -p                context relative path to compile (must start with '/')");
        System.out.println("    -l                filename of jsp file list to compile");
        System.out.println("    -q                stop compilation on compile error");
        System.out.println("    -co               extra javac compile option. space must be replaced by ','");
        System.out.println("    -h                this message");
        System.out.println("    -v                version information");
        System.exit(0);
    }

    private static void printVersion() {
        System.out.println("JEUS Web Container version: " + JeusVersion.getVersion());
        System.exit(0);
    }

    public static void main(String[] args) throws JeusException {
        JeusRootClassLoader.loader = BatchCompiler.class.getClassLoader();
        JeusRootClassLoader.inServer = true;
        JeusRootClassLoader.inModuleCompiler = true;
        Thread.currentThread().setContextClassLoader(JeusRootClassLoader.loader);
        EJBRootClassLoader ejbLoader = (EJBRootClassLoader)((RootClassLoader)JeusRootClassLoader.loader).getEJBRootClassLoader();
        if (ejbLoader == null) {
            ejbLoader = new EJBRootClassLoader(new URL[0], JeusRootClassLoader.loader, "JspBatchContainer");
            ((RootClassLoader)JeusRootClassLoader.loader).registerEJBRootClassLoader(ejbLoader);
            EngineContainer.rootClassLoader = ejbLoader;
        }
        BatchCompiler batchCompiler = null;
        if (args.length == 0 || args[0] == null) {
            BatchCompiler.printUsage();
        }
        try {
            batchCompiler = new BatchCompiler();
        }
        catch (StartingException se) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1222));
            se.printStackTrace();
            System.exit(1);
        }
        try {
            batchCompiler.parseArgs(args);
        }
        catch (StartingException se) {
            se.printStackTrace(System.out);
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1222));
            System.exit(1);
        }
        catch (Throwable t) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1222));
            t.printStackTrace(System.out);
            System.exit(1);
        }
        try {
            batchCompiler.configure();
        }
        catch (StartingException se) {
            System.out.println(ErrorMsgManager.getLocalizedString((Throwable)((Object)se)));
            se.printStackTrace(System.out);
            Throwable rootCause = se.getCause();
            if (rootCause != null) {
                rootCause.printStackTrace(System.out);
            }
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1222));
            System.exit(1);
        }
        catch (CompileFailedException ce) {
            try {
                new File("jspc.failed").createNewFile();
            }
            catch (IOException e) {
                // empty catch block
            }
            System.exit(1);
        }
        catch (Throwable t) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1222));
            t.printStackTrace(System.out);
            System.exit(1);
        }
        System.exit(0);
    }
}

