/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler.batch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.management.JMXUtility;
import jeus.management.RemoteMBeanServerFactory;
import jeus.security.util.LoginUtil;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.ContextGroupDescriptor;
import jeus.servlet.jsp.compiler.batch.CompileContextGroup;
import jeus.servlet.jsp.compiler.batch.CompileTarget;
import jeus.servlet.loader.ClassLoadManager;
import jeus.servlet.util.URLResolver;
import jeus.util.ErrorMsgManager;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.JeusBootstrapProperties;
import jeus.util.SecurityUtil;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_WebContainer5_4;
import jeus.xml.binding.jeusDD.EngineCommandType;
import jeus.xml.binding.jeusDD.EngineContainerType;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusSystemType;

public class CompileManager
extends WebContainerManager {
    private String compileOption = null;

    CompileManager() {
        this.compileOption = null;
    }

    CompileManager(String compileOption) {
        this.compileOption = compileOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startContainer(boolean isWebAdmin, String ctxGroup, String ctxName) throws StartingException {
        Class<?> sunJavac = null;
        try {
            sunJavac = Class.forName("sun.tools.javac.Main");
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            this.classLoadManager = new ClassLoadManager(this.getClass().getClassLoader(), URLResolver.resolve(JeusBootstrapProperties.JEUS_HOME), this.ENGINE_NAME, true);
        }
        catch (MalformedURLException mue) {
            throw new StartingException(2014, JeusBootstrapProperties.JEUS_HOME, (Throwable)mue);
        }
        Hashtable descs = this.webContainerDesc.getContextGroupDescriptor();
        this.ctxGroupNames = this.webContainerDesc.getContextGroupNames();
        Enumeration names = this.ctxGroupNames.elements();
        while (names.hasMoreElements()) {
            String groupName = (String)names.nextElement();
            if (ctxGroup != null && !ctxGroup.equals(groupName)) continue;
            ContextGroupDescriptor ctxGroupDesc = (ContextGroupDescriptor)descs.get(groupName);
            String nodeName = null;
            try {
                nodeName = StringUtil.getNodeNameFromEngineName((String)this.ENGINE_NAME);
            }
            catch (IllegalJeusSystemNameException e2) {
                e2.printStackTrace();
                continue;
            }
            String containerName = null;
            try {
                JeusMainDescriptor jeusMainDesc = JeusMainDescriptorJB.getJeusMainDescriptor(nodeName);
                JeusSystemType jeusSystem = jeusMainDesc.getJeusSystem();
                for (JeusNodeType jeusNodeType : jeusSystem.getNode()) {
                    if (!nodeName.equals(jeusNodeType.getName())) continue;
                    block15: for (EngineContainerType engineContainerType : jeusNodeType.getEngineContainer()) {
                        for (EngineCommandType engCommandType : engineContainerType.getEngineCommand()) {
                            String engineName;
                            if (!engCommandType.getType().value().equals("servlet") || !this.ENGINE_NAME.equals(engineName = nodeName + '_' + engCommandType.getType().value() + '_' + engCommandType.getName())) continue;
                            containerName = nodeName + '_' + engineContainerType.getName();
                            continue block15;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            MBeanServerConnection connector = null;
            try {
                SecurityUtil.installClientSecurity(nodeName);
                LoginUtil.loginCodeSubjectWithRuntimeException();
                connector = containerName.endsWith("default") ? RemoteMBeanServerFactory.getDedicatedMBeanServer(nodeName, true) : RemoteMBeanServerFactory.getDedicatedMBeanServer(containerName, false);
                ObjectName[] objectNames = JMXUtility.queryWebModules(connector);
                for (int i = 0; i < objectNames.length; ++i) {
                    String webEngine = objectNames[i].getKeyProperty("WebEngine");
                    if (!this.ENGINE_NAME.equals(webEngine)) continue;
                    String contextGroup = objectNames[i].getKeyProperty("ContextGroup");
                    if (ctxGroup != null && !ctxGroup.equals(contextGroup)) continue;
                    String contextName = objectNames[i].getKeyProperty("name");
                    String j2eeApp = objectNames[i].getKeyProperty("J2EEApplication");
                    if (!"null".equals(j2eeApp)) {
                        contextName = j2eeApp + "_" + contextName;
                    }
                    if (ctxName != null && !ctxName.equals(contextName)) continue;
                    String docbase = (String)connector.getAttribute(objectNames[i], "RealDocBase");
                    ContextDescriptor ctxDesc = new ContextDescriptor();
                    ctxDesc.setContextName(contextName);
                    ctxDesc.setContextPath("/" + contextName);
                    ctxDesc.setDocBase(docbase);
                    ctxDesc.setWarDeploy(true);
                    ctxGroupDesc.addContextDescriptorToDefaultVHostDesc(ctxDesc);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                continue;
            }
            finally {
                LoginUtil.logoutWithRuntimeException();
                continue;
            }
            if (this.compileOption != null) {
                Hashtable<String, String> jspconf = ctxGroupDesc.getJspConfig();
                if (jspconf == null) {
                    jspconf = new Hashtable<String, String>();
                }
                jspconf.put("CompileOption", this.compileOption);
                ctxGroupDesc.setJspConfig(jspconf);
            }
            CompileContextGroup contextGroup = new CompileContextGroup(ctxGroupDesc, this, isWebAdmin);
            contextGroup.setConfigByXML(this.configByXML);
            contextGroup.initLogger();
            contextGroup.init();
            this.contextGroups.put(groupName, contextGroup);
        }
    }

    public void startContainer(boolean isWebAdmin) throws StartingException {
        Class<?> sunJavac = null;
        try {
            sunJavac = Class.forName("sun.tools.javac.Main");
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            this.classLoadManager = new ClassLoadManager(this.getClass().getClassLoader(), URLResolver.resolve(JeusBootstrapProperties.JEUS_HOME), this.ENGINE_NAME, true);
        }
        catch (MalformedURLException mue) {
            throw new StartingException(2014, JeusBootstrapProperties.JEUS_HOME, (Throwable)mue);
        }
        Hashtable descs = this.webContainerDesc.getContextGroupDescriptor();
        this.ctxGroupNames = this.webContainerDesc.getContextGroupNames();
        Enumeration names = this.ctxGroupNames.elements();
        while (names.hasMoreElements()) {
            String groupName = (String)names.nextElement();
            ContextGroupDescriptor ctxGroupDesc = (ContextGroupDescriptor)descs.get(groupName);
            if (this.compileOption != null) {
                Hashtable<String, String> jspconf = ctxGroupDesc.getJspConfig();
                if (jspconf == null) {
                    jspconf = new Hashtable<String, String>();
                }
                jspconf.put("CompileOption", this.compileOption);
                ctxGroupDesc.setJspConfig(jspconf);
            }
            CompileContextGroup contextGroup = new CompileContextGroup(ctxGroupDesc, this, isWebAdmin);
            contextGroup.setConfigByXML(this.configByXML);
            contextGroup.initLogger();
            contextGroup.init();
            this.contextGroups.put(groupName, contextGroup);
        }
    }

    void startCompile() throws FileNotFoundException, ServletException {
        Enumeration enum1 = this.contextGroups.elements();
        while (enum1.hasMoreElements()) {
            CompileContextGroup contextGroup = (CompileContextGroup)enum1.nextElement();
            contextGroup.preCompile();
        }
    }

    void startCompile(String grpName) throws FileNotFoundException, ServletException {
        if (grpName == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5668, (Object)grpName));
            return;
        }
        CompileContextGroup group = (CompileContextGroup)this.contextGroups.get(grpName);
        if (group == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5669, (Object)grpName));
            return;
        }
        group.preCompile();
    }

    void startCompile(String grpName, String ctxName) throws FileNotFoundException, ServletException {
        if (grpName == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5668, (Object)grpName));
            return;
        }
        CompileContextGroup group = (CompileContextGroup)this.contextGroups.get(grpName);
        if (group == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5669, (Object)grpName));
            return;
        }
        group.preCompile(ctxName);
    }

    void startCompile(String grpName, String ctxName, PrintWriter writer) throws FileNotFoundException, ServletException {
        if (grpName == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5668, (Object)grpName));
            return;
        }
        CompileContextGroup group = (CompileContextGroup)this.contextGroups.get(grpName);
        if (group == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5669, (Object)grpName));
            return;
        }
        group.preCompile(ctxName, writer);
    }

    void startCompile(CompileTarget target) throws FileNotFoundException, ServletException {
        CompileContextGroup group = (CompileContextGroup)this.contextGroups.get(target.getContextGroupName());
        if (group == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5669, (Object)target.getContextGroupName()));
            return;
        }
        group.preCompile(target);
    }

    void startCompile(String grpName, String ctxName, PrintWriter writer, String srcRoot) throws FileNotFoundException, ServletException {
        if (grpName == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5668, (Object)grpName));
            return;
        }
        CompileContextGroup group = (CompileContextGroup)this.contextGroups.get(grpName);
        if (group == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5669, (Object)grpName));
            return;
        }
        group.preCompile(ctxName, writer, srcRoot);
    }

    void startCompile(String grpName, String ctxName, PrintWriter writer, File listFile) throws FileNotFoundException, ServletException {
        if (grpName == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5668, (Object)grpName));
            return;
        }
        CompileContextGroup group = (CompileContextGroup)this.contextGroups.get(grpName);
        if (group == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5669, (Object)grpName));
            return;
        }
        group.preCompile(ctxName, writer, listFile);
    }
}

