/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.jsp.compiler.batch.NormalCompileTarget;
import jeus.tool.util.JarManager;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class WarCompileTarget
extends NormalCompileTarget {
    private static final String UNJAR_PATH = "." + File.separator + "__jspctmp";
    public static final String DEFAULT_OUTWAR = "." + File.separator + "jspcout.war";
    private boolean iswar = false;
    private String outwar;

    public WarCompileTarget(String ctxroot, String outwar) throws StartingException {
        super(ctxroot, "/", null, null);
        this.outwar = outwar == null ? DEFAULT_OUTWAR : outwar;
    }

    public void initTarget() throws StartingException {
        File file = new File(this.ctxroot);
        if (!file.exists()) {
            throw new StartingException(JeusMessage_WebContainer5_4._5671, this.ctxroot);
        }
        if (file.isFile()) {
            this.iswar = true;
            try {
                File destdir = new File(UNJAR_PATH);
                if (!destdir.exists()) {
                    destdir.mkdirs();
                }
                String warfilename = this.ctxroot;
                this.ctxroot = destdir.getCanonicalPath();
                if (this.ctxroot.endsWith(File.separator)) {
                    this.ctxroot = this.ctxroot.substring(0, this.ctxroot.length() - 1);
                }
                JarManager.unJar(warfilename, this.ctxroot);
                this.jspworkdir = this.getDefaultJspWorkDir();
                this.compileoutdir = this.getDefaultJspWorkDir();
            }
            catch (Exception e) {
                throw new StartingException(JeusMessage_WebContainer5_4._5672, this.ctxroot, (Throwable)e);
            }
        } else {
            throw new StartingException("ctxroot is not a file");
        }
    }

    public void start() throws IOException {
    }

    public String getDefaultJspWorkDir() {
        return this.getContextRoot() + File.separator + "WEB-INF" + File.separator + ".warjspwork";
    }

    public void finish() throws IOException {
        if (this.iswar) {
            Set resources = this.context.getResourcePathsAll("/");
            this.context.execTerminate();
            this.context = null;
            this.batchCompiler2.destroy();
            String targetwar = this.outwar;
            File f = new File(targetwar);
            if (f.exists()) {
                f.delete();
            }
            Iterator it = resources.iterator();
            String item = null;
            ArrayList<String> items = new ArrayList<String>();
            while (it.hasNext()) {
                item = (String)it.next();
                if ((item = item.substring(1).trim()) == null || item.length() <= 0 || item.equals("")) continue;
                items.add(item);
            }
            if (items.size() > 0) {
                int size = items.size();
                String[] contents = new String[size];
                String[] entries = new String[size];
                for (int i = 0; i < size; ++i) {
                    entries[i] = (String)items.get(i);
                    contents[i] = this.getContextRoot() + File.separator + entries[i].replace('/', File.separatorChar);
                }
                JarManager.jar(targetwar, contents, entries);
            }
            this.deleteDirectory(new File(this.ctxroot));
        }
    }

    private boolean deleteDirectory(File dir) {
        if (dir.isFile()) {
            return dir.delete();
        }
        boolean result = false;
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null || (result = this.deleteDirectory(files[i]))) continue;
                System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5673, (Object)files[i].getAbsolutePath()));
                return false;
            }
        }
        if (!(result = dir.delete())) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5673, (Object)dir.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public boolean isSameName() {
        return false;
    }
}

