/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.el;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import jeus.servlet.jsp.el.BeanInfoManager;
import jeus.servlet.jsp.el.BeanInfoProperty;
import jeus.servlet.jsp.el.Coercions;
import jeus.servlet.jsp.el.ExceptionHandler;
import jeus.servlet.jsp.el.Expression;
import jeus.servlet.jsp.el.Logger;
import jeus.servlet.jsp.el.ValueSuffix;
import jeus.util.message.JeusMessage_WebContainer6;

public class ArraySuffix
extends ValueSuffix {
    static Object[] sNoArgs = new Object[0];
    Expression mIndex;

    public Expression getIndex() {
        return this.mIndex;
    }

    public void setIndex(Expression pIndex) {
        this.mIndex = pIndex;
    }

    public ArraySuffix(Expression pIndex) {
        this.mIndex = pIndex;
    }

    Object evaluateIndex(VariableResolver pResolver, FunctionMapper functions, Logger pLogger) throws ELException {
        return this.mIndex.evaluate(pResolver, functions, pLogger);
    }

    String getOperatorSymbol() {
        return "[]";
    }

    public String getExpressionString() {
        return "[" + this.mIndex.getExpressionString() + "]";
    }

    public Object evaluate(Object pValue, VariableResolver pResolver, FunctionMapper functions, Logger pLogger) throws ELException {
        if (pValue == null) {
            if (logger.isLoggable(JeusMessage_WebContainer6._6007_LEVEL)) {
                logger.log(JeusMessage_WebContainer6._6007_LEVEL, JeusMessage_WebContainer6._6007, (Object)this.getOperatorSymbol());
            }
            return null;
        }
        Object indexVal = this.evaluateIndex(pResolver, functions, pLogger);
        if (indexVal == null) {
            if (logger.isLoggable(JeusMessage_WebContainer6._6008_LEVEL)) {
                logger.log(JeusMessage_WebContainer6._6008_LEVEL, JeusMessage_WebContainer6._6008, (Object)this.getOperatorSymbol());
            }
            return null;
        }
        if (pValue instanceof Map) {
            Map val = (Map)pValue;
            return val.get(indexVal);
        }
        if (pValue instanceof List || pValue.getClass().isArray()) {
            Integer indexObj = Coercions.coerceToInteger(indexVal, pLogger);
            if (indexObj == null) {
                ExceptionHandler.handle(JeusMessage_WebContainer6._6010, new Object[]{this.getOperatorSymbol(), indexVal.getClass().getName()});
                return null;
            }
            if (pValue instanceof List) {
                try {
                    return ((List)pValue).get(indexObj);
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    if (logger.isLoggable(JeusMessage_WebContainer6._6011_LEVEL)) {
                        logger.log(JeusMessage_WebContainer6._6011_LEVEL, JeusMessage_WebContainer6._6011, (Object)indexObj, (Throwable)exc);
                    }
                    return null;
                }
                catch (IndexOutOfBoundsException exc) {
                    if (logger.isLoggable(JeusMessage_WebContainer6._6011_LEVEL)) {
                        logger.log(JeusMessage_WebContainer6._6011_LEVEL, JeusMessage_WebContainer6._6011, (Object)indexObj, (Throwable)exc);
                    }
                    return null;
                }
                catch (Exception exc) {
                    ExceptionHandler.handle(JeusMessage_WebContainer6._6011, indexObj, (Throwable)exc);
                    return null;
                }
            }
            try {
                return Array.get(pValue, indexObj);
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                if (logger.isLoggable(JeusMessage_WebContainer6._6012_LEVEL)) {
                    logger.log(JeusMessage_WebContainer6._6012_LEVEL, JeusMessage_WebContainer6._6012, (Object)indexObj, (Throwable)exc);
                }
                return null;
            }
            catch (IndexOutOfBoundsException exc) {
                if (logger.isLoggable(JeusMessage_WebContainer6._6012_LEVEL)) {
                    logger.log(JeusMessage_WebContainer6._6012_LEVEL, JeusMessage_WebContainer6._6012, (Object)indexObj, (Throwable)exc);
                }
                return null;
            }
            catch (Exception exc) {
                ExceptionHandler.handle(JeusMessage_WebContainer6._6012, indexObj, (Throwable)exc);
                return null;
            }
        }
        String indexStr = Coercions.coerceToString(indexVal, pLogger);
        if (indexStr == null) {
            return null;
        }
        BeanInfoProperty property = BeanInfoManager.getBeanInfoProperty(pValue.getClass(), indexStr, pLogger);
        if (property != null && property.getReadMethod() != null) {
            try {
                return property.getReadMethod().invoke(pValue, sNoArgs);
            }
            catch (InvocationTargetException exc) {
                ExceptionHandler.handle(JeusMessage_WebContainer6._6006, new Object[]{indexStr, pValue.getClass().getName()}, exc.getTargetException());
                return null;
            }
            catch (Exception exc) {
                ExceptionHandler.handle(JeusMessage_WebContainer6._6006, new Object[]{indexStr, pValue.getClass().getName()}, (Throwable)exc);
                return null;
            }
        }
        ExceptionHandler.handle(JeusMessage_WebContainer6._6013, new Object[]{indexVal, pValue.getClass().getName(), this.getOperatorSymbol()});
        return null;
    }
}

