/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.el;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import jeus.servlet.jsp.el.BeanInfoIndexedProperty;
import jeus.servlet.jsp.el.BeanInfoProperty;
import jeus.servlet.jsp.el.Logger;
import jeus.servlet.loader.ContextLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer6;

public class BeanInfoManager {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp.el");
    Class mBeanClass;
    BeanInfo mBeanInfo;
    Map mPropertyByName;
    Map mIndexedPropertyByName;
    Map mEventSetByName;
    boolean mInitialized;
    static Map mBeanInfoManagerByClass = new HashMap();

    public Class getBeanClass() {
        return this.mBeanClass;
    }

    BeanInfoManager(Class pBeanClass) {
        this.mBeanClass = pBeanClass;
    }

    public static BeanInfoManager getBeanInfoManager(Class pClass) {
        BeanInfoManager ret = (BeanInfoManager)mBeanInfoManagerByClass.get(pClass);
        if (ret == null) {
            ret = BeanInfoManager.createBeanInfoManager(pClass);
        }
        return ret;
    }

    static synchronized BeanInfoManager createBeanInfoManager(Class pClass) {
        BeanInfoManager ret = (BeanInfoManager)mBeanInfoManagerByClass.get(pClass);
        if (ret == null) {
            ret = new BeanInfoManager(pClass);
            mBeanInfoManagerByClass.put(pClass, ret);
        }
        return ret;
    }

    public static BeanInfoProperty getBeanInfoProperty(Class pClass, String pPropertyName, Logger pLogger) throws ELException {
        return BeanInfoManager.getBeanInfoManager(pClass).getProperty(pPropertyName, pLogger);
    }

    public static BeanInfoIndexedProperty getBeanInfoIndexedProperty(Class pClass, String pIndexedPropertyName, Logger pLogger) throws ELException {
        return BeanInfoManager.getBeanInfoManager(pClass).getIndexedProperty(pIndexedPropertyName, pLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInitialized(Logger pLogger) throws ELException {
        if (!this.mInitialized) {
            BeanInfoManager beanInfoManager = this;
            synchronized (beanInfoManager) {
                if (!this.mInitialized) {
                    this.initialize(pLogger);
                    this.mInitialized = true;
                }
            }
        }
    }

    void initialize(Logger pLogger) throws ELException {
        block5: {
            try {
                this.mBeanInfo = Introspector.getBeanInfo(this.mBeanClass);
                this.mPropertyByName = new HashMap();
                this.mIndexedPropertyByName = new HashMap();
                PropertyDescriptor[] pds = this.mBeanInfo.getPropertyDescriptors();
                for (int i = 0; pds != null && i < pds.length; ++i) {
                    PropertyDescriptor pd = pds[i];
                    if (pd instanceof IndexedPropertyDescriptor) {
                        IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                        Method readMethod = BeanInfoManager.getPublicMethod(ipd.getIndexedReadMethod());
                        Method writeMethod = BeanInfoManager.getPublicMethod(ipd.getIndexedWriteMethod());
                        BeanInfoIndexedProperty property = new BeanInfoIndexedProperty(readMethod, writeMethod, ipd);
                        this.mIndexedPropertyByName.put(ipd.getName(), property);
                    }
                    Method readMethod = BeanInfoManager.getPublicMethod(pd.getReadMethod());
                    Method writeMethod = BeanInfoManager.getPublicMethod(pd.getWriteMethod());
                    BeanInfoProperty property = new BeanInfoProperty(readMethod, writeMethod, pd);
                    this.mPropertyByName.put(pd.getName(), property);
                }
                this.mEventSetByName = new HashMap();
                EventSetDescriptor[] esds = this.mBeanInfo.getEventSetDescriptors();
                for (int i = 0; esds != null && i < esds.length; ++i) {
                    EventSetDescriptor esd = esds[i];
                    this.mEventSetByName.put(esd.getName(), esd);
                }
            }
            catch (IntrospectionException exc) {
                if (!logger.isLoggable(JeusMessage_WebContainer6._6000_LEVEL)) break block5;
                logger.log(JeusMessage_WebContainer6._6000_LEVEL, JeusMessage_WebContainer6._6000, (Object)this.mBeanClass.getName(), (Throwable)exc);
            }
        }
    }

    BeanInfo getBeanInfo(Logger pLogger) throws ELException {
        this.checkInitialized(pLogger);
        return this.mBeanInfo;
    }

    public BeanInfoProperty getProperty(String pPropertyName, Logger pLogger) throws ELException {
        this.checkInitialized(pLogger);
        return (BeanInfoProperty)this.mPropertyByName.get(pPropertyName);
    }

    public BeanInfoIndexedProperty getIndexedProperty(String pIndexedPropertyName, Logger pLogger) throws ELException {
        this.checkInitialized(pLogger);
        return (BeanInfoIndexedProperty)this.mIndexedPropertyByName.get(pIndexedPropertyName);
    }

    public EventSetDescriptor getEventSet(String pEventSetName, Logger pLogger) throws ELException {
        this.checkInitialized(pLogger);
        return (EventSetDescriptor)this.mEventSetByName.get(pEventSetName);
    }

    static Method getPublicMethod(Method pMethod) {
        if (pMethod == null) {
            return null;
        }
        Class<?> cl = pMethod.getDeclaringClass();
        if (Modifier.isPublic(cl.getModifiers())) {
            return pMethod;
        }
        Method ret = BeanInfoManager.getPublicMethod(cl, pMethod);
        if (ret != null) {
            return ret;
        }
        return pMethod;
    }

    static Method getPublicMethod(Class pClass, Method pMethod) {
        Method m;
        Class superclass;
        Class<?>[] interfaces;
        if (Modifier.isPublic(pClass.getModifiers())) {
            try {
                Method m2;
                try {
                    m2 = pClass.getDeclaredMethod(pMethod.getName(), pMethod.getParameterTypes());
                }
                catch (AccessControlException ex) {
                    m2 = pClass.getMethod(pMethod.getName(), pMethod.getParameterTypes());
                }
                if (Modifier.isPublic(m2.getModifiers())) {
                    return m2;
                }
            }
            catch (NoSuchMethodException exc) {
                // empty catch block
            }
        }
        if ((interfaces = pClass.getInterfaces()) != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                Method m3 = BeanInfoManager.getPublicMethod(interfaces[i], pMethod);
                if (m3 == null) continue;
                return m3;
            }
        }
        if ((superclass = pClass.getSuperclass()) != null && (m = BeanInfoManager.getPublicMethod(superclass, pMethod)) != null) {
            return m;
        }
        return null;
    }

    public static synchronized void releaseBeanInfoManagers(ContextLoader contextLoader) {
        ArrayList<Class> classList = new ArrayList<Class>();
        for (Class clazz : mBeanInfoManagerByClass.keySet()) {
            if (contextLoader != clazz.getClassLoader()) continue;
            classList.add(clazz);
        }
        Iterator<Object> iter = classList.iterator();
        while (iter.hasNext()) {
            mBeanInfoManagerByClass.remove(iter.next());
        }
    }
}

