/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.servlet.jsp.el.ELException;
import jeus.servlet.jsp.el.Logger;
import jeus.servlet.jsp.el.RelationalOperator;

public class LessThanOrEqualsOperator
extends RelationalOperator {
    public static final LessThanOrEqualsOperator SINGLETON = new LessThanOrEqualsOperator();

    public String getOperatorSymbol() {
        return "<=";
    }

    public Object apply(Object pLeft, Object pRight, Logger pLogger) throws ELException {
        if (pLeft == pRight) {
            return Boolean.TRUE;
        }
        if (pLeft == null || pRight == null) {
            return Boolean.FALSE;
        }
        return super.apply(pLeft, pRight, pLogger);
    }

    public boolean apply(double pLeft, double pRight) {
        return pLeft <= pRight;
    }

    public boolean apply(long pLeft, long pRight) {
        return pLeft <= pRight;
    }

    public boolean apply(String pLeft, String pRight) {
        return pLeft.compareTo(pRight) <= 0;
    }

    public boolean apply(BigDecimal pLeft, BigDecimal pRight) {
        return this.isLess(pLeft.compareTo(pRight)) || this.isEqual(pLeft.compareTo(pRight));
    }

    public boolean apply(BigInteger pLeft, BigInteger pRight) {
        return this.isLess(pLeft.compareTo(pRight)) || this.isEqual(pLeft.compareTo(pRight));
    }
}

