/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2.compiler;

import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.compiler.ErrorHandler;
import jeus.servlet.jsp2.compiler.JavacErrorDetail;
import jeus.servlet.jsp2.compiler.Localizer;

class DefaultErrorHandler
implements ErrorHandler {
    DefaultErrorHandler() {
    }

    public void jspError(String fname, int line, int column, String errMsg, Exception ex) throws Jsp2EngineException {
        throw new Jsp2EngineException(fname + "(" + line + "," + column + ")" + " " + errMsg, ex);
    }

    public void jspError(String errMsg, Exception ex) throws Jsp2EngineException {
        throw new Jsp2EngineException(errMsg, ex);
    }

    public void javacError(JavacErrorDetail[] details) throws Jsp2EngineException {
        if (details == null) {
            return;
        }
        Object[] args = null;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < details.length; ++i) {
            if (details[i].getJspBeginLineNumber() >= 0) {
                args = new Object[]{new Integer(details[i].getJspBeginLineNumber()), details[i].getJspFileName()};
                buf.append(Localizer.getMessage("jsp.error.single.line.number", args));
                buf.append("\n");
            }
            buf.append(Localizer.getMessage("jsp.error.corresponding.servlet"));
            buf.append(details[i].getErrorMessage());
            buf.append("\n\n");
        }
        throw new Jsp2EngineException(Localizer.getMessage("jsp.error.unable.compile") + "\n\n" + buf);
    }

    public void javacError(String errorReport, Exception exception) throws Jsp2EngineException {
        throw new Jsp2EngineException(Localizer.getMessage("jsp.error.unable.compile"), exception);
    }
}

