/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import java.util.Vector;
import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.compiler.DefaultErrorHandler;
import jeus.servlet.jsp2.compiler.ErrorHandler;
import jeus.servlet.jsp2.compiler.JavacErrorDetail;
import jeus.servlet.jsp2.compiler.Localizer;
import jeus.servlet.jsp2.compiler.Mark;
import jeus.servlet.jsp2.compiler.Node;
import org.xml.sax.SAXException;

public class ErrorDispatcher {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("jeus.servlet.jsp2.resources.messages");
    private ErrorHandler errHandler = new DefaultErrorHandler();
    private boolean jspcMode = false;

    public ErrorDispatcher(boolean jspcMode) {
        this.jspcMode = jspcMode;
    }

    public void jspError(String errCode) throws Jsp2EngineException {
        this.dispatch(null, errCode, null, null);
    }

    public void jspError(Mark where, String errCode) throws Jsp2EngineException {
        this.dispatch(where, errCode, null, null);
    }

    public void jspError(Mark where, String errCode, Exception e) throws Jsp2EngineException {
        this.dispatch(where, errCode, null, e);
    }

    public void jspError(Node n, String errCode) throws Jsp2EngineException {
        this.dispatch(n.getStart(), errCode, null, null);
    }

    public void jspError(String errCode, String arg) throws Jsp2EngineException {
        this.dispatch(null, errCode, new Object[]{arg}, null);
    }

    public void jspError(Mark where, String errCode, String arg) throws Jsp2EngineException {
        this.dispatch(where, errCode, new Object[]{arg}, null);
    }

    public void jspError(Node n, String errCode, String arg) throws Jsp2EngineException {
        this.dispatch(n.getStart(), errCode, new Object[]{arg}, null);
    }

    public void jspError(String errCode, String arg1, String arg2) throws Jsp2EngineException {
        this.dispatch(null, errCode, new Object[]{arg1, arg2}, null);
    }

    public void jspError(String errCode, String arg1, String arg2, String arg3) throws Jsp2EngineException {
        this.dispatch(null, errCode, new Object[]{arg1, arg2, arg3}, null);
    }

    public void jspError(Mark where, String errCode, String arg1, String arg2) throws Jsp2EngineException {
        this.dispatch(where, errCode, new Object[]{arg1, arg2}, null);
    }

    public void jspError(Mark where, String errCode, String arg1, String arg2, String arg3) throws Jsp2EngineException {
        this.dispatch(where, errCode, new Object[]{arg1, arg2, arg3}, null);
    }

    public void jspError(Node n, String errCode, String arg1, String arg2) throws Jsp2EngineException {
        this.dispatch(n.getStart(), errCode, new Object[]{arg1, arg2}, null);
    }

    public void jspError(Node n, String errCode, String arg1, String arg2, String arg3) throws Jsp2EngineException {
        this.dispatch(n.getStart(), errCode, new Object[]{arg1, arg2, arg3}, null);
    }

    public void jspError(Exception e) throws Jsp2EngineException {
        this.dispatch(null, null, null, e);
    }

    public void jspError(String errCode, String arg, Exception e) throws Jsp2EngineException {
        this.dispatch(null, errCode, new Object[]{arg}, e);
    }

    public void jspError(Node n, String errCode, String arg, Exception e) throws Jsp2EngineException {
        this.dispatch(n.getStart(), errCode, new Object[]{arg}, e);
    }

    public void throwException(Mark where, Jsp2EngineException je) throws Jsp2EngineException {
        if (where == null) {
            throw je;
        }
        String file = null;
        if (this.jspcMode) {
            try {
                file = where.getURL().toString();
            }
            catch (MalformedURLException me) {
                file = where.getFile();
            }
        } else {
            file = where.getFile();
        }
        Jsp2EngineException newEx = new Jsp2EngineException(file + "(" + where.getLineNumber() + "," + where.getColumnNumber() + ")" + " " + je.getMessage());
        newEx.setStackTrace(je.getStackTrace());
        throw newEx;
    }

    public static JavacErrorDetail[] parseJavacErrors(String errMsg, String fname, Node.Nodes page) throws Jsp2EngineException, IOException {
        return ErrorDispatcher.parseJavacMessage(errMsg, fname, page);
    }

    public void javacError(JavacErrorDetail[] javacErrors) throws Jsp2EngineException {
        this.errHandler.javacError(javacErrors);
    }

    public void javacError(String errorReport, Exception e) throws Jsp2EngineException {
        this.errHandler.javacError(errorReport, e);
    }

    private void dispatch(Mark where, String errCode, Object[] args, Exception e) throws Jsp2EngineException {
        String file = null;
        String errMsg = null;
        int line = -1;
        int column = -1;
        boolean hasLocation = false;
        if (errCode != null) {
            errMsg = Localizer.getMessage(errCode, args);
        } else if (e != null) {
            errMsg = e.getMessage();
        }
        if (where != null) {
            if (this.jspcMode) {
                try {
                    file = where.getURL().toString();
                }
                catch (MalformedURLException me) {
                    file = where.getFile();
                }
            } else {
                file = where.getFile();
            }
            line = where.getLineNumber();
            column = where.getColumnNumber();
            hasLocation = true;
        }
        Exception nestedEx = e;
        if (e instanceof SAXException && ((SAXException)e).getException() != null) {
            nestedEx = ((SAXException)e).getException();
        }
        if (hasLocation) {
            this.errHandler.jspError(file, line, column, errMsg, nestedEx);
        } else {
            this.errHandler.jspError(errMsg, nestedEx);
        }
    }

    private static JavacErrorDetail[] parseJavacMessage(String errMsg, String fname, Node.Nodes page) throws IOException, Jsp2EngineException {
        Vector<JavacErrorDetail> errVec = new Vector<JavacErrorDetail>();
        StringBuffer errMsgBuf = null;
        int lineNum = -1;
        JavacErrorDetail javacError = null;
        BufferedReader reader = new BufferedReader(new StringReader(errMsg));
        String line = null;
        while ((line = reader.readLine()) != null) {
            int beginColon = line.indexOf(58, 2);
            int endColon = line.indexOf(58, beginColon + 1);
            if (beginColon >= 0 && endColon >= 0) {
                if (javacError != null) {
                    errVec.add(javacError);
                }
                String lineNumStr = line.substring(beginColon + 1, endColon);
                try {
                    lineNum = Integer.parseInt(lineNumStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                errMsgBuf = new StringBuffer();
                ErrorVisitor errVisitor = new ErrorVisitor(lineNum);
                page.visit(errVisitor);
                Node errNode = errVisitor.getJspSourceNode();
                javacError = errNode != null && errNode.getStart() != null ? new JavacErrorDetail(fname, lineNum, errNode.getStart().getFile(), errNode.getStart().getLineNumber(), errMsgBuf) : new JavacErrorDetail(fname, lineNum, errMsgBuf);
            }
            if (errMsgBuf == null) continue;
            errMsgBuf.append(line);
            errMsgBuf.append("\n");
        }
        if (javacError != null) {
            errVec.add(javacError);
        }
        reader.close();
        Object[] errDetails = null;
        if (errVec.size() > 0) {
            errDetails = new JavacErrorDetail[errVec.size()];
            errVec.copyInto(errDetails);
        }
        return errDetails;
    }

    static class ErrorVisitor
    extends Node.Visitor {
        private int lineNum;
        Node found;

        public ErrorVisitor(int lineNum) {
            this.lineNum = lineNum;
        }

        public void doVisit(Node n) throws Jsp2EngineException {
            if (this.lineNum >= n.getBeginJavaLine() && this.lineNum < n.getEndJavaLine()) {
                this.found = n;
            }
        }

        public Node getJspSourceNode() {
            return this.found;
        }
    }
}

