/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2.compiler;

import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.Options;
import jeus.servlet.jsp2.compiler.Compiler;
import jeus.servlet.jsp2.compiler.Node;
import jeus.servlet.jsp2.compiler.PageInfo;

public class TextOptimizer {
    public static void concatenate(Compiler compiler, Node.Nodes page) throws Jsp2EngineException {
        TextCatVisitor v = new TextCatVisitor(compiler);
        page.visit(v);
        v.collectText();
    }

    static class TextCatVisitor
    extends Node.Visitor {
        private Options options;
        private PageInfo pageInfo;
        private int textNodeCount = 0;
        private Node.TemplateText firstTextNode = null;
        private StringBuffer textBuffer;
        private final String emptyText = new String("");

        public TextCatVisitor(Compiler compiler) {
            this.options = compiler.getCompilationContext().getOptions();
            this.pageInfo = compiler.getPageInfo();
        }

        public void doVisit(Node n) throws Jsp2EngineException {
            this.collectText();
        }

        public void visit(Node.PageDirective n) throws Jsp2EngineException {
        }

        public void visit(Node.TagDirective n) throws Jsp2EngineException {
        }

        public void visit(Node.TaglibDirective n) throws Jsp2EngineException {
        }

        public void visit(Node.AttributeDirective n) throws Jsp2EngineException {
        }

        public void visit(Node.VariableDirective n) throws Jsp2EngineException {
        }

        public void visitBody(Node n) throws Jsp2EngineException {
            super.visitBody(n);
            this.collectText();
        }

        public void visit(Node.TemplateText n) throws Jsp2EngineException {
            if ((this.options.getTrimSpaces() || this.pageInfo.isTrimDirectiveWhitespaces()) && n.isAllSpace()) {
                n.setText(this.emptyText);
                return;
            }
            if (this.textNodeCount++ == 0) {
                this.firstTextNode = n;
                this.textBuffer = new StringBuffer(n.getText());
            } else {
                this.textBuffer.append(n.getText());
                n.setText(this.emptyText);
            }
        }

        private void collectText() {
            if (this.textNodeCount > 1) {
                this.firstTextNode.setText(this.textBuffer.toString());
            }
            this.textNodeCount = 0;
        }
    }
}

