/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.listener;

import java.util.EventListener;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.loader.ListenerReloader;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer8;

public class ListenerWrapper {
    private ContextLoader contextLoader;
    private ListenerReloader reloader;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.listener");

    ListenerWrapper(ContextLoader contextLoader, String className) {
        this.contextLoader = contextLoader;
        this.reloader = contextLoader.createListenerReloader(className);
    }

    public boolean init() {
        EventListener listener = this.getListener();
        if (listener == null) {
            return false;
        }
        if (logger.isLoggable(JeusMessage_WebContainer8._8201_LEVEL)) {
            logger.log(JeusMessage_WebContainer8._8201_LEVEL, JeusMessage_WebContainer8._8201, (Object)this.reloader.getClassName());
        }
        return true;
    }

    public void destroy() {
        if (this.reloader != null) {
            this.reloader.destroy();
            this.reloader = null;
        }
    }

    private EventListener getListener() {
        EventListener listener = null;
        if (this.reloader == null) {
            return null;
        }
        try {
            listener = (EventListener)this.reloader.getInstance();
            if (!this.checkType(listener)) {
                return null;
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_WebContainer8._8200_LEVEL)) {
                logger.log(JeusMessage_WebContainer8._8200_LEVEL, JeusMessage_WebContainer8._8200, (Object)this.reloader.getClassName(), t);
            }
            return null;
        }
        return listener;
    }

    private boolean checkType(EventListener listener) {
        return listener instanceof ServletContextListener || listener instanceof ServletContextAttributeListener || listener instanceof HttpSessionListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionActivationListener || listener instanceof ServletRequestAttributeListener || listener instanceof ServletRequestListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void contextInitialized(ServletContextEvent sce) {
        EventListener listener = this.getListener();
        if (listener instanceof ServletContextListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((ServletContextListener)listener).contextInitialized(sce);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void contextDestroyed(ServletContextEvent sce) {
        EventListener listener = this.getListener();
        if (listener instanceof ServletContextListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((ServletContextListener)listener).contextDestroyed(sce);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void contextAttributeAdded(ServletContextAttributeEvent scab) {
        EventListener listener = this.getListener();
        if (listener instanceof ServletContextAttributeListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((ServletContextAttributeListener)listener).attributeAdded(scab);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void contextAttributeRemoved(ServletContextAttributeEvent scab) {
        EventListener listener = this.getListener();
        if (listener instanceof ServletContextAttributeListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((ServletContextAttributeListener)listener).attributeRemoved(scab);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void contextAttributeReplaced(ServletContextAttributeEvent scab) {
        EventListener listener = this.getListener();
        if (listener instanceof ServletContextAttributeListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((ServletContextAttributeListener)listener).attributeReplaced(scab);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionCreated(HttpSessionEvent se) {
        EventListener listener = this.getListener();
        if (listener instanceof HttpSessionListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((HttpSessionListener)listener).sessionCreated(se);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionDestroyed(HttpSessionEvent se) {
        EventListener listener = this.getListener();
        if (listener instanceof HttpSessionListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((HttpSessionListener)listener).sessionDestroyed(se);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionAttributeAdded(HttpSessionBindingEvent se) {
        EventListener listener = this.getListener();
        if (listener instanceof HttpSessionAttributeListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((HttpSessionAttributeListener)listener).attributeAdded(se);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestInitialized(ServletRequestEvent sre) {
        EventListener listener = this.getListener();
        if (listener instanceof ServletRequestListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((ServletRequestListener)listener).requestInitialized(sre);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestDestroyed(ServletRequestEvent sre) {
        EventListener listener = this.getListener();
        if (listener instanceof ServletRequestListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((ServletRequestListener)listener).requestDestroyed(sre);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestAttributeAdded(ServletRequestAttributeEvent srae) {
        EventListener listener = this.getListener();
        if (listener instanceof ServletRequestAttributeListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((ServletRequestAttributeListener)listener).attributeAdded(srae);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestAttributeRemoved(ServletRequestAttributeEvent srae) {
        EventListener listener = this.getListener();
        if (listener instanceof ServletRequestAttributeListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((ServletRequestAttributeListener)listener).attributeRemoved(srae);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestAttributeReplaced(ServletRequestAttributeEvent srae) {
        EventListener listener = this.getListener();
        if (listener instanceof ServletRequestAttributeListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((ServletRequestAttributeListener)listener).attributeReplaced(srae);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionAttributeRemoved(HttpSessionBindingEvent se) {
        EventListener listener = this.getListener();
        if (listener instanceof HttpSessionAttributeListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((HttpSessionAttributeListener)listener).attributeRemoved(se);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionAttributeReplaced(HttpSessionBindingEvent se) {
        EventListener listener = this.getListener();
        if (listener instanceof HttpSessionAttributeListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((HttpSessionAttributeListener)listener).attributeReplaced(se);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionDidActivate(HttpSessionEvent se) {
        EventListener listener = this.getListener();
        if (listener instanceof HttpSessionActivationListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((HttpSessionActivationListener)listener).sessionDidActivate(se);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionWillPassivate(HttpSessionEvent se) {
        EventListener listener = this.getListener();
        if (listener instanceof HttpSessionActivationListener) {
            WebAppContextSwitch.preContextSwitch(this.contextLoader);
            try {
                ((HttpSessionActivationListener)listener).sessionWillPassivate(se);
            }
            finally {
                WebAppContextSwitch.postContextSwitch();
            }
        }
    }
}

