/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jeus.servlet.common.Monitor;
import jeus.servlet.engine.Context;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.servlet.util.URLResolver;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer1;

public class ClassLoadManager
extends Monitor {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.loader");
    private ClassLoader parent;
    private URL jeusHome;
    private boolean running = false;
    private ClassLoader systemLoader;
    private URLClassLoader syslibLoader;
    private Vector contextLoaders;
    public static final String[] triggers = new String[]{"javax.servlet.Servlet"};

    public ClassLoadManager(ClassLoader sysloader, URL jeusHome, String engineName, boolean standalone) {
        super("ServletReloadMonitor");
        this.systemLoader = sysloader;
        this.contextLoaders = new Vector();
        this.jeusHome = jeusHome;
        if (standalone) {
            this.initSyslibs();
            this.parent = this.syslibLoader;
        } else {
            this.parent = this.systemLoader;
        }
        this.running = true;
    }

    private void initSyslibs() {
        String protocol = this.jeusHome.getProtocol();
        int port = this.jeusHome.getPort();
        String host = this.jeusHome.getHost();
        String home = this.jeusHome.getFile();
        String syslib = home + "/lib/application";
        File syslibdir = new File(syslib);
        Vector jars = new Vector();
        ClassLoadManager.getJarFiles(jars, syslibdir);
        int size = jars.size();
        URL[] syslibs = new URL[size + 1];
        try {
            URL appdir = URLResolver.resolve(syslib);
            syslibs[0] = new URL(protocol, host, port, appdir.getFile());
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace(System.out);
        }
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                try {
                    String jarFile = (String)jars.elementAt(i);
                    URL jarFileUrl = URLResolver.resolve(jarFile);
                    syslibs[i + 1] = new URL(protocol, host, port, jarFileUrl.getFile());
                    continue;
                }
                catch (MalformedURLException mue) {
                    mue.printStackTrace(System.out);
                }
            }
        }
        this.syslibLoader = new URLClassLoader(syslibs, this.systemLoader);
    }

    public ContextLoader createContextLoader(URL base, Context context) {
        return this.createContextLoader(base, context, this.parent);
    }

    public ContextLoader createContextLoader(URL base, Context context, ClassLoader parent) {
        ArrayList<URL> urls = new ArrayList<URL>();
        String basePath = base.getFile();
        if (!basePath.startsWith(File.separator)) {
            basePath = "/" + basePath;
        }
        try {
            URL classURL = JeusBootstrapPropertyValues.makeUrlFromPath(basePath + "/WEB-INF/classes/");
            urls.add(classURL);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        ContextLoader loader = new ContextLoader(this, this.getURLs(urls), base, parent, context);
        this.contextLoaders.add(loader);
        return loader;
    }

    private URL[] getURLs(ArrayList urls) {
        URL[] arr = new URL[urls.size()];
        urls.toArray(arr);
        return arr;
    }

    public void checkReload() {
        if (!this.running) {
            return;
        }
        Enumeration en = this.contextLoaders.elements();
        while (en.hasMoreElements()) {
            ContextLoader loader = (ContextLoader)en.nextElement();
            if (!loader.isReloadable() || !loader.modified()) continue;
            loader.getContext().execReload();
        }
    }

    public void destroyContextLoader(ContextLoader loader) {
        if (this.contextLoaders.remove(loader)) {
            loader.destroy();
        }
    }

    public void destroy() {
        this.running = false;
        Enumeration enum1 = this.contextLoaders.elements();
        while (enum1.hasMoreElements()) {
            ContextLoader loader = (ContextLoader)enum1.nextElement();
            loader.destroy();
        }
    }

    static void getJarFiles(Vector jars, File f) {
        if (f.exists() && f.isDirectory() && f.isAbsolute()) {
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".jar") && !files[i].endsWith(".war") && !files[i].endsWith(".zip")) continue;
                String path = f.getPath();
                if (!path.endsWith(File.separator)) {
                    path = path + File.separator;
                }
                if (FileUtils.isExploded((String)path)) continue;
                jars.addElement(path + files[i]);
            }
        }
    }

    public void getJarFilesWithValidation(Vector jars, File f) {
        if (f.exists() && f.isDirectory() && f.isAbsolute()) {
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                String fullFilePath;
                block6: {
                    if (!files[i].endsWith(".jar") && !files[i].endsWith(".war") && !files[i].endsWith(".zip")) continue;
                    String path = f.getPath();
                    if (!path.endsWith(File.separator)) {
                        path = path + File.separator;
                    }
                    if (FileUtils.isExploded((String)(fullFilePath = path + files[i]))) continue;
                    try {
                        if (!this.validateJarFile(fullFilePath)) {
                        }
                        break block6;
                    }
                    catch (IOException e) {
                        if (!logger.isLoggable(JeusMessage_WebContainer1._2406_LEVEL)) continue;
                        logger.log(JeusMessage_WebContainer1._2406_LEVEL, JeusMessage_WebContainer1._2406, (Object)fullFilePath, (Throwable)e);
                    }
                    continue;
                }
                jars.addElement(fullFilePath);
            }
        }
    }

    private boolean validateJarFile(String jarfile) throws IOException {
        if (triggers == null) {
            return true;
        }
        WebProperties props = PropertyUtil.getContextProperties();
        boolean isCheckParent = props.ALLOW_LOADING_SERVLET_API_CLASS.value;
        JarFile jarFile = new JarFile(jarfile);
        for (int i = 0; i < triggers.length; ++i) {
            JarEntry jarEntry;
            if (isCheckParent) {
                Class<?> clazz = null;
                try {
                    clazz = this.parent != null ? this.parent.loadClass(triggers[i]) : Class.forName(triggers[i]);
                }
                catch (Throwable t) {
                    clazz = null;
                }
                if (clazz == null) continue;
            }
            String name = triggers[i].replace('.', '/') + ".class";
            if (logger.isLoggable(JeusMessage_WebContainer1._2404_LEVEL)) {
                logger.log(JeusMessage_WebContainer1._2404_LEVEL, JeusMessage_WebContainer1._2404, (Object)name);
            }
            if ((jarEntry = jarFile.getJarEntry(name)) == null) continue;
            if (logger.isLoggable(JeusMessage_WebContainer1._2405_LEVEL)) {
                logger.log(JeusMessage_WebContainer1._2405_LEVEL, JeusMessage_WebContainer1._2405, new Object[]{jarfile, name});
            }
            jarFile.close();
            return false;
        }
        jarFile.close();
        return true;
    }

    public boolean isRequestTimeCheck() {
        return this.period < 0L;
    }

    protected void doJob() {
        this.checkReload();
    }
}

