/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.ServletException;
import jeus.management.j2ee.servlet.ServletInfo;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ServletConfigImpl;
import jeus.servlet.jsp.JspConfig;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspProperty;
import jeus.servlet.jsp.JspServletWrapper;
import jeus.servlet.jsp2.EmbeddedServletOptions;
import jeus.servlet.jsp2.Options;
import jeus.servlet.jsp2.compiler.JspRuntimeContext;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.loader.JspClassLoader;
import jeus.servlet.loader.JspResourceJspReloader;
import jeus.servlet.loader.PrivateClassLoader;
import jeus.servlet.loader.ServletReloader;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.servlet.property.ContextProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer1;

public class JspReloader
extends ServletReloader {
    private JspEngine jspEngine;
    private File jspFile;
    private File classFile;
    private String jspURI;
    private String javaFileName;
    private String classFileName;
    private String classOnlyName;
    private String packageName;
    private boolean checkIncludedJspFile;
    private String[] includedJspFiles;
    private jeus.servlet.jsp2.servlet.JspServletWrapper jspServlerWrapper;
    private Options options;
    private JspRuntimeContext rctxt;
    private JspProperty jspProperty;
    private long prevClassModTime = -1L;
    private boolean recompiled = false;
    private String compileOutputDir;
    private static final boolean[] TRUE_TRUE = new boolean[]{true, true};
    private static final boolean[] TRUE_FALSE = new boolean[]{true, false};
    private static final boolean[] FALSE_TRUE = new boolean[]{false, true};
    private static final boolean[] FALSE_FALSE = new boolean[]{false, false};

    JspReloader(ContextLoader parent, String className, String jspURI, String jspServletName, ServletConfigImpl config, JspConfig jspConfig, JspEngine jspEngine) throws FileNotFoundException {
        super(parent, className);
        this.servletConfig = config;
        this.jspURI = jspURI;
        String realpath = this.contextLoader.getContext().getRealPath(jspURI);
        if (realpath != null) {
            this.jspFile = new File(this.contextLoader.getContext().getCtxDocBase().getFile() + jspURI);
            if (!this.jspFile.exists() && !(this instanceof JspResourceJspReloader)) {
                throw new FileNotFoundException(jspURI);
            }
        } else {
            throw new FileNotFoundException(jspURI);
        }
        this.jspEngine = jspEngine;
        this.compileOutputDir = jspConfig.getCompileOutputDir();
        this.classLoader = new JspClassLoader(parent, this, this.compileOutputDir, className);
        this.jspProperty = jspConfig.getJspPropertyMapper().getJspProperty(jspURI, realpath);
        this.initCompileInfo(jspConfig);
        this.options = new EmbeddedServletOptions(config, config.getServletContext());
        this.rctxt = new JspRuntimeContext(config.getServletContext(), this.options);
        try {
            this.jspServlerWrapper = new jeus.servlet.jsp2.servlet.JspServletWrapper(config, this.options, jspURI, false, this.rctxt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initCompileInfo(JspConfig config) {
        String outputDir = config.getJspWorkDir().toString();
        String classOutputDir = config.getCompileOutputDir();
        String[] result = this.getOutputFileNamesFromFullClassName(this.className, outputDir, classOutputDir);
        this.packageName = result[0];
        this.classOnlyName = result[1];
        this.javaFileName = result[2];
        this.classFileName = result[3];
        this.classFile = new File(this.classFileName);
        this.checkIncludedJspFile = config.checkIncludedJspFile();
    }

    public final void renameCorruptedClassFile(Throwable t) {
        if (t != null && (t instanceof ClassFormatError || t instanceof VerifyError)) {
            this.renameCorruptedClassFile();
        }
    }

    public final void renameCorruptedClassFile() {
        try {
            if (this.classFile.exists()) {
                this.classFile.renameTo(new File(this.classFileName + ".bad"));
                File javaFile = new File(this.javaFileName);
                javaFile.renameTo(new File(this.javaFileName + ".bad"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getJspURI() {
        return this.jspURI;
    }

    public String getJavaFileName() {
        return this.javaFileName;
    }

    public String getClassFileName() {
        return this.classFileName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassOnlyName() {
        return this.classOnlyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getInstance() throws ServletException {
        boolean recompiled = false;
        ContextProperties props = this.jspEngine.getContext().getContextProperties();
        boolean forceRecompile = props.ENFORCE_JSP_RECOMPILE.value;
        int tryCount = 0;
        Object obj = null;
        Object prevInstance = this.instance;
        boolean[] modret = null;
        boolean includedJspModified = false;
        boolean logFine = logger.isLoggable(Level.FINE);
        WebAppContextSwitch.preContextSwitch(this.contextLoader);
        try {
            if (logFine) {
                logger.fine("JspReloader#getInstance() - instance = [" + this.instance + "]");
            }
            while (tryCount < props.JSP_COMPILE_RETRYCOUNT.value) {
                JspReloader jspReloader;
                if (props.JSP_ENABLE_RELOAD.value || this.instance == null) {
                    modret = this.jspModified();
                    recompiled = modret[1];
                    includedJspModified = this.includedJspModified();
                    if (logFine) {
                        logger.fine("JspReloader#getInstance() - #1 : forceRecompile = " + forceRecompile + ", jspModified =  (" + modret[0] + ", " + modret[1] + "), includedJspModified = " + includedJspModified);
                    }
                    if (forceRecompile || modret[0] || includedJspModified) {
                        try {
                            jspReloader = this;
                            synchronized (jspReloader) {
                                modret = this.jspModified();
                                recompiled = modret[1];
                                includedJspModified = this.includedJspModified();
                                if (logFine) {
                                    logger.fine("JspReloader#getInstance() - #2 : forceRecompile = " + forceRecompile + ", jspModified = (" + modret[0] + ", " + modret[1] + "), includedJspModified = " + includedJspModified);
                                }
                                if (forceRecompile || modret[0] || includedJspModified) {
                                    this.jspEngine.parseAndCompile(this);
                                    recompiled = true;
                                    forceRecompile = false;
                                    if (logFine) {
                                        logger.fine("JspReloader#getInstance() - call tryReload()");
                                    }
                                    this.tryReload(recompiled);
                                    this.prevClassModTime = this.classFile.lastModified();
                                }
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer1._2201, (Object)this.jspURI), t);
                        }
                    }
                    if (logFine) {
                        logger.fine("JspReloader#getInstance() - recompiled = " + recompiled);
                    }
                }
                if ((obj = this.instance) != null) break;
                jspReloader = this;
                synchronized (jspReloader) {
                    if (this.instance == null) {
                        try {
                            Class clazz = this.classLoader.loadClass();
                            obj = clazz.newInstance();
                            this.doInitInstance(obj);
                            this.instance = obj;
                            break;
                        }
                        catch (Throwable t) {
                            if (!(t instanceof ClassFormatError) && !(t instanceof VerifyError)) {
                                t.printStackTrace();
                                throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer1._2203, (Object)this.className), t);
                            }
                            if (++tryCount >= props.JSP_COMPILE_RETRYCOUNT.value) {
                                throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer1._2203, (Object)this.className), t);
                            }
                            if (logger.isLoggable(JeusMessage_WebContainer1._2202_LEVEL)) {
                                logger.log(JeusMessage_WebContainer1._2202_LEVEL, JeusMessage_WebContainer1._2202, (Object[])new String[]{t.getMessage(), String.valueOf(tryCount)});
                            }
                            forceRecompile = true;
                            continue;
                        }
                    }
                    obj = this.instance;
                    break;
                }
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
        if (logFine) {
            logger.fine("JspReloader#getInstance() - result instance = " + this.instance);
        }
        return obj;
    }

    protected final void doInitInstance(Object obj) throws ServletException {
        super.doInitInstance(obj);
        if (!this.checkIncludedJspFile) {
            return;
        }
        ContextProperties props = this.jspEngine.getContext().getContextProperties();
        if (!props.JASPER.value) {
            Class<?> clazz = obj.getClass();
            Method method = null;
            try {
                method = clazz.getMethod("__jeusGetIncludedJspFiles", null);
            }
            catch (NoSuchMethodException nme) {
                this.includedJspFiles = null;
                return;
            }
            Object result = null;
            try {
                result = method.invoke(obj, null);
                if (result == null) {
                    this.includedJspFiles = null;
                    return;
                }
                this.includedJspFiles = (String[])result;
            }
            catch (Exception iae) {
                this.includedJspFiles = null;
                return;
            }
        }
        Class<?> clazz = obj.getClass();
        Method method = null;
        try {
            method = clazz.getMethod("getDependants", null);
        }
        catch (NoSuchMethodException nme) {
            this.includedJspFiles = null;
            return;
        }
        Object result = null;
        try {
            result = method.invoke(obj, null);
            if (result == null) {
                this.includedJspFiles = null;
                return;
            }
            List resultList = (List)result;
            this.includedJspFiles = resultList.toArray(new String[resultList.size()]);
        }
        catch (Exception iae) {
            this.includedJspFiles = null;
            return;
        }
    }

    protected PrivateClassLoader createNewClassLoader() {
        return new JspClassLoader(this.contextLoader, this, this.compileOutputDir, this.className);
    }

    protected boolean[] jspModified() {
        long modTime;
        if (this.jspFile == null) {
            String realpath = this.contextLoader.getContext().getRealPath(this.jspURI);
            if (realpath == null) {
                return TRUE_FALSE;
            }
            this.jspFile = new File(realpath);
        }
        if ((modTime = this.jspFile.lastModified()) == 0L) {
            return TRUE_FALSE;
        }
        if (!this.classFile.exists()) {
            return TRUE_FALSE;
        }
        if (modTime > this.classFile.lastModified()) {
            return TRUE_FALSE;
        }
        long classModTime = this.classFile.lastModified();
        if (this.prevClassModTime == -1L) {
            this.prevClassModTime = classModTime;
            return FALSE_FALSE;
        }
        if (classModTime > this.prevClassModTime) {
            this.recompiled = true;
            this.prevClassModTime = classModTime;
            return FALSE_TRUE;
        }
        return FALSE_FALSE;
    }

    private boolean batchTimeJspModified() throws FileNotFoundException, ServletException {
        if (this.jspModified()[0]) {
            return true;
        }
        this.getInstance();
        return this.includedJspModified();
    }

    protected boolean includedJspModified() {
        if (!this.checkIncludedJspFile) {
            return false;
        }
        String[] list = this.includedJspFiles;
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            String realpath = this.contextLoader.getContext().getRealPath(list[i]);
            if (realpath == null) {
                return true;
            }
            File file = new File(realpath);
            if (!file.exists()) {
                return true;
            }
            if (file.lastModified() <= this.classFile.lastModified()) continue;
            return true;
        }
        return false;
    }

    public ServletInfo getServletInfo(String servletName, long count) {
        int state = 0;
        if (this.instance != null) {
            state = 1;
        }
        if (this.suspended) {
            state = 2;
        }
        return new ServletInfo(servletName, this.className, this.jspURI, state, count);
    }

    public void batchCompile() throws ServletException {
        try {
            if (this.batchTimeJspModified()) {
                this.jspEngine.parseAndCompile(this);
            }
        }
        catch (FileNotFoundException fnfe) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer1._2204, (Object)this.jspURI);
            logger.log(JeusMessage_WebContainer1._2204_LEVEL, msg, (Throwable)fnfe);
            throw new ServletException(msg, (Throwable)fnfe);
        }
        catch (Throwable t) {
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer1._2201, (Object)this.jspURI);
            logger.log(JeusMessage_WebContainer1._2201_LEVEL, msg, t);
            throw new ServletException(msg, t);
        }
    }

    public static String generateClassName(Context context, String jspUri, boolean samename) {
        StringBuffer fullName;
        block5: {
            String token;
            int pos;
            char fsc = File.separatorChar;
            String pathName = jspUri;
            Object jspFileName = null;
            String packageDir = "";
            if ((pathName = pathName.replace('-', '_')).charAt(0) == '/') {
                pathName = pathName.substring(1);
            }
            if ((pos = pathName.lastIndexOf(46)) >= 0) {
                String _extension = pathName.substring(pos + 1);
                pathName = _extension != null && _extension.length() != 0 ? pathName.substring(0, pos) + "_" + _extension : pathName.substring(0, pos);
            }
            fullName = new StringBuffer();
            StringTokenizer parser = new StringTokenizer(pathName, "/");
            if (!samename && JspServletWrapper.PKGNAME_PREFIX != null) {
                fullName.append(JspServletWrapper.PKGNAME_PREFIX + ".");
            }
            if (!parser.hasMoreTokens()) break block5;
            while (true) {
                token = parser.nextToken();
                if (!parser.hasMoreTokens()) break;
                token = samename ? token + "." : "_" + JspReloader.convertSpecialCharacter(token) + ".";
                fullName.append(token);
            }
            if (!samename) {
                token = "_600_" + JspReloader.convertSpecialCharacter(token);
            }
            fullName.append(token);
        }
        return fullName.toString();
    }

    private static String getClassFullName(Context context) {
        Hashtable jspConfig = context.getJSPConfig();
        String compileOutputDir = (String)jspConfig.get("CompileOutputDir");
        Boolean useContextGroupDir = (Boolean)jspConfig.get("useContextGroupDir");
        String pkgPrefix = JspServletWrapper.PKGNAME_PREFIX + ".";
        if (compileOutputDir.indexOf(".warjspwork") > 0 || useContextGroupDir == null || !useContextGroupDir.booleanValue()) {
            return pkgPrefix;
        }
        ContextGroup contextGroup = context.getVirtualHost().getContextGroup();
        return pkgPrefix + "_" + contextGroup.getContainerManager().ENGINE_NAME.replace('-', '_') + "." + "_" + contextGroup.getGroupName().replace('-', '_') + "." + "_" + context.getContextName().replace('-', '_') + ".";
    }

    private String[] getOutputFileNamesFromFullClassName(String fullClassName, String outputDir, String classOutputDir) {
        String[] list = new String[4];
        String className2 = fullClassName.replace('.', File.separatorChar);
        list[2] = outputDir + File.separator + className2 + ".java";
        list[3] = classOutputDir + File.separator + className2 + ".class";
        int pos = fullClassName.lastIndexOf(".");
        if (pos <= 0) {
            list[0] = null;
            list[1] = fullClassName;
        } else {
            list[0] = fullClassName.substring(0, pos);
            list[1] = fullClassName.substring(pos + 1);
        }
        return list;
    }

    public static String convertSpecialCharacter(String input) {
        if (input == null || input.equals("")) {
            return input;
        }
        int len = input.length();
        StringBuffer output = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (!(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                char t = ch;
                String tt = Integer.toHexString(t);
                output.append("_" + tt);
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public JspProperty getJspProperty() {
        return this.jspProperty;
    }

    public jeus.servlet.jsp2.servlet.JspServletWrapper getJspServlerWrapper() {
        return this.jspServlerWrapper;
    }

    public void setJspServletWrapper(jeus.servlet.jsp2.servlet.JspServletWrapper wrapper) {
        this.jspServlerWrapper = wrapper;
    }

    protected File getJspFile() {
        return this.jspFile;
    }
}

