/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import jeus.servlet.loader.ApplicationClassReleaser;
import jeus.servlet.loader.PrivateReloader;

class PrivateClassLoader
extends ClassLoader {
    protected ClassLoader parent;
    protected String className;
    protected PrivateReloader reloader;

    PrivateClassLoader(ClassLoader parent, PrivateReloader reloader, String className) {
        super(parent);
        this.parent = parent;
        this.reloader = reloader;
        this.className = className;
    }

    PrivateReloader getReloader() {
        return this.reloader;
    }

    Class loadClass() throws ClassNotFoundException {
        return this.loadClass(this.className);
    }

    final synchronized void destroy() {
        ApplicationClassReleaser.releaseApplicationClasses(this);
        this.reloader = null;
        this.parent = null;
    }

    synchronized PrivateClassLoader getNewClassLoader() {
        return new PrivateClassLoader(this.parent, this.reloader, this.className);
    }

    public String toString() {
        return super.toString() + " for " + this.className;
    }
}

