/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.Vector;
import jeus.servlet.engine.Context;
import jeus.servlet.loader.ResourceCacheDir;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer1;

public class ResourceCache {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.loader");
    private String contextPath;
    private String contextDocBase;
    private long maxCacheMemSize;
    private long maxIdleTime;
    private long totalMemoryUsage;
    private boolean overCaching;
    private String[] dirList;
    private ResourceCacheDir[] cacheDirs;
    private Vector tmpDirs;

    public ResourceCache(int maxMem, long maxIdle, Vector dirs) {
        this.maxCacheMemSize = maxMem * 1024 * 1024;
        this.maxIdleTime = maxIdle;
        this.tmpDirs = dirs;
    }

    public void init(Context context, Hashtable aliasList) {
        int i;
        this.contextPath = context.getContextPath();
        this.contextDocBase = context.getDocBase();
        int dirNum = this.tmpDirs.size();
        Vector<String> sortedList = new Vector<String>(dirNum);
        for (int i2 = 0; i2 < dirNum; ++i2) {
            sortedList.insertElementAt(null, i2);
        }
        Hashtable<String, ResourceCacheDir> tmpCache = new Hashtable<String, ResourceCacheDir>(dirNum);
        block1: for (i = 0; i < this.tmpDirs.size(); ++i) {
            File f;
            String fs;
            String realPath;
            String dir;
            String baseDir = this.contextDocBase;
            String realDir = dir = (String)this.tmpDirs.elementAt(i);
            if (aliasList != null && (realPath = (String)aliasList.get(dir)) != null && (baseDir = realPath).endsWith(fs = System.getProperty("file.separator"))) {
                int pos = baseDir.lastIndexOf(fs);
                baseDir = baseDir.substring(0, pos);
                realDir = fs;
            }
            if (!(f = new File(baseDir + realDir)).exists() || f.isFile()) {
                if (logger.isLoggable(JeusMessage_WebContainer1._2230_LEVEL)) {
                    logger.log(JeusMessage_WebContainer1._2230_LEVEL, JeusMessage_WebContainer1._2230, (Object)(baseDir + dir));
                }
                --dirNum;
                continue;
            }
            ResourceCacheDir cacheDir = new ResourceCacheDir(baseDir, realDir, this.maxIdleTime);
            String searchedPath = null;
            searchedPath = this.contextPath.equals("/") ? dir : this.contextPath + dir;
            tmpCache.put(searchedPath, cacheDir);
            int size = searchedPath.length();
            for (int j = 0; j < dirNum; ++j) {
                String cmpDir = (String)sortedList.elementAt(j);
                if (cmpDir != null && size < cmpDir.length()) continue;
                sortedList.insertElementAt(searchedPath, j);
                continue block1;
            }
        }
        this.dirList = new String[dirNum];
        this.cacheDirs = new ResourceCacheDir[dirNum];
        for (i = 0; i < dirNum; ++i) {
            this.dirList[i] = (String)sortedList.elementAt(i);
            this.cacheDirs[i] = (ResourceCacheDir)tmpCache.get(this.dirList[i]);
        }
        this.tmpDirs = null;
    }

    public byte[] getResourceAsBytes(String path) {
        byte[] res = null;
        if (this.overCaching) {
            return null;
        }
        try {
            for (int i = 0; i < this.dirList.length; ++i) {
                if (path.indexOf(this.dirList[i]) < 0) continue;
                ResourceCacheDir rcDir = this.cacheDirs[i];
                String remainedPath = path.substring(this.dirList[i].length());
                res = rcDir.getResource(remainedPath);
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return res;
    }

    public synchronized void checkIdleResources() {
        this.totalMemoryUsage = 0L;
        for (int i = 0; i < this.cacheDirs.length; ++i) {
            this.cacheDirs[i].checkIdleResources();
            this.totalMemoryUsage += this.cacheDirs[i].getTotalMemoryUsage();
        }
        this.overCaching = this.totalMemoryUsage > this.maxCacheMemSize;
    }
}

