/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import jeus.servlet.engine.ResourceWrapper;
import jeus.sessionmanager.util.SessionManagerUtil;

public class ResourceCacheDir {
    private String baseDir;
    private String rcDir;
    private Hashtable resources;
    private long maxIdleTime;
    private long totalMemoryUsage;

    public ResourceCacheDir(String base, String dir, long maxIdle) {
        this.baseDir = base;
        this.rcDir = dir;
        this.maxIdleTime = maxIdle;
        this.resources = new Hashtable();
    }

    public byte[] getResource(String path) throws FileNotFoundException {
        ResourceWrapper rw = (ResourceWrapper)this.resources.get(path);
        if (rw != null) {
            return rw.getBytes();
        }
        String fullPath = this.baseDir + this.rcDir + path;
        File f = new File(fullPath);
        FileInputStream in = new FileInputStream(f);
        BufferedInputStream bin = new BufferedInputStream(in);
        byte[] bs = new byte[SessionManagerUtil.safeCasting(f.length())];
        try {
            int rdSize = bin.read(bs, 0, bs.length);
            if (rdSize != bs.length) {
                return null;
            }
            rw = new ResourceWrapper(f, bs);
            this.resources.put(path, rw);
            this.totalMemoryUsage += (long)bs.length;
        }
        catch (IOException ioe) {
            bs = null;
        }
        return bs;
    }

    public long getTotalMemoryUsage() {
        return this.totalMemoryUsage;
    }

    public synchronized void checkIdleResources() {
        Enumeration e = this.resources.keys();
        while (e.hasMoreElements()) {
            String path = (String)e.nextElement();
            ResourceWrapper rw = (ResourceWrapper)this.resources.get(path);
            boolean idle = rw.isIdleResource(this.maxIdleTime);
            if (!idle) continue;
            this.totalMemoryUsage -= rw.getResourceSize();
            rw.clear();
            this.resources.remove(path);
        }
    }
}

