/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import java.util.HashMap;
import jeus.servlet.engine.Context;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.loader.ServletReloader;
import jeus.util.ExecutionContext;

public class WebAppContextSwitch {
    static final String EC_WEB_CONTEXT_KEY = "jeus.web.context";

    public static void preContextSwitch(ServletReloader loader) {
        WebAppContextSwitch.preContextSwitch(loader.getParent());
    }

    public static void preContextSwitch(ContextLoader newContextLoader) {
        Context ctx = newContextLoader.getContext();
        HashMap<String, ContextLoader> ctxmap = null;
        if (ctx != null) {
            ctxmap = ctx.getExecutionContextMap();
            ctxmap.put("jeus.contextloader", newContextLoader);
            ctxmap.put(EC_WEB_CONTEXT_KEY, (ContextLoader)((Object)ctx));
        } else {
            ctxmap = new HashMap<String, ContextLoader>();
        }
        ExecutionContext.push(ctxmap);
    }

    public static void postContextSwitch() {
        ExecutionContext.pop();
    }

    public static void postContextSwitchAndClear() {
        ExecutionContext execCtx = ExecutionContext.pop();
        if (execCtx != null) {
            execCtx.put("jeus.contextloader", null);
            execCtx.put(EC_WEB_CONTEXT_KEY, null);
        }
    }

    public static Context getCurrentWebContext() {
        return (Context)ExecutionContext.getExecutionContext().get(EC_WEB_CONTEXT_KEY);
    }
}

