/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.property;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import jeus.servlet.property.InvalidOptionException;
import jeus.servlet.property.PropertyEntry;
import jeus.servlet.property.PropertyScope;
import jeus.servlet.property.WebProperties;
import jeus.xml.binding.jeusDD.PropertiesType;

public class ContainerProperties
extends WebProperties {
    public ContainerProperties() {
        this.currentScope = PropertyScope.SCOPE_CONTAINER;
        this.initDefaultValue();
        Class<?> clazz = this.getClass();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!PropertyEntry.class.isAssignableFrom(fields[i].getType())) continue;
            try {
                Field f = fields[i];
                PropertyEntry pe = (PropertyEntry)fields[i].get(this);
                if (pe == null) continue;
                String key = pe.key;
                nameKeyMap.put(fields[i].getName(), key);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void init(PropertiesType userProperties) {
        for (String key : nameKeyMap.values()) {
            String value = System.getProperty(key);
            if (value == null) continue;
            PropertyEntry entry = (PropertyEntry)this.properties.get(key);
            try {
                entry.setStringValue(value);
            }
            catch (RuntimeException e) {
                throw new InvalidOptionException(key, value, e);
            }
        }
        if (userProperties != null) {
            super.init(userProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String delim = "|||";
        String header = "name|||type|||key|||value|||scope|||deprecated|||open|||description|||insert_query\n";
        StringBuffer csvBuffer = new StringBuffer();
        csvBuffer.append("name|||type|||key|||value|||scope|||deprecated|||open|||description|||insert_query\n");
        String tab = "    ";
        StringBuffer docbookBuffer = new StringBuffer();
        StringBuffer rowsBuffer = new StringBuffer();
        InputStream is = ContainerProperties.class.getClassLoader().getResourceAsStream("jeus/servlet/property/servlet_engine_properties.xml");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (docbookBuffer.length() != 0) {
                    docbookBuffer.append('\n');
                }
                docbookBuffer.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        ContainerProperties props = new ContainerProperties();
        for (String name : nameKeyMap.keySet()) {
            String key = (String)nameKeyMap.get(name);
            PropertyEntry entry = (PropertyEntry)props.properties.get(key);
            csvBuffer.append(name);
            csvBuffer.append("|||");
            csvBuffer.append(entry.getType());
            csvBuffer.append("|||");
            csvBuffer.append(key);
            csvBuffer.append("|||");
            csvBuffer.append(entry.getStringValue());
            csvBuffer.append("|||");
            csvBuffer.append(entry.scope);
            csvBuffer.append("|||");
            csvBuffer.append(entry.deprecated);
            csvBuffer.append("|||");
            csvBuffer.append(entry.open);
            csvBuffer.append("|||");
            csvBuffer.append('\"');
            csvBuffer.append(entry.description);
            csvBuffer.append('\"');
            csvBuffer.append('\n');
            if (!entry.open) continue;
            rowsBuffer.append("<row>");
            rowsBuffer.append('\n');
            rowsBuffer.append(tab);
            rowsBuffer.append("<entry align=\"left\"><property>");
            rowsBuffer.append(entry.key);
            rowsBuffer.append("</property></entry>");
            rowsBuffer.append('\n');
            rowsBuffer.append(tab);
            rowsBuffer.append("<entry>");
            if (entry.deprecated) {
                rowsBuffer.append("<para><emphasis role=\"bold\">DEPRECATED</emphasis></para>");
            }
            rowsBuffer.append(entry.description);
            rowsBuffer.append("</entry>");
            rowsBuffer.append('\n');
            rowsBuffer.append(tab);
            rowsBuffer.append("<entry>");
            rowsBuffer.append(entry.getStringValue());
            rowsBuffer.append("</entry>");
            rowsBuffer.append('\n');
            rowsBuffer.append("</row>");
            rowsBuffer.append('\n');
        }
        System.out.println(csvBuffer.toString());
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(new File("options.txt"));
            writer.write(csvBuffer.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream("servlet_engine_properties.xml");
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            BufferedWriter bw = new BufferedWriter(osw);
            String rows = "${rows}";
            int rowsStart = docbookBuffer.indexOf(rows);
            int rowsEnd = rowsStart + rows.length();
            docbookBuffer.replace(rowsStart, rowsEnd, rowsBuffer.toString());
            bw.write(docbookBuffer.toString());
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

