/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jeus.servlet.reverseproxy.ServerChain;
import jeus.servlet.reverseproxy.model.ServerContainer;
import jeus.servlet.reverseproxy.rules.AcceptEverythingRule;
import jeus.servlet.reverseproxy.rules.DirectoryRule;
import jeus.servlet.reverseproxy.servers.BaseServer;
import jeus.servlet.reverseproxy.servers.RoundRobinCluster;
import jeus.servlet.reverseproxy.servers.ServerContainerBase;
import jeus.util.logging.JeusLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigParser {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.proxy");
    private ServerChain serverChain;

    public ConfigParser(File data) {
        try {
            LinkedList serverContainer = this.createServerList(data);
            if (logger.getLevel() == Level.FINEST) {
                this.debugServers(serverContainer);
            }
            this.serverChain = new ServerChain(serverContainer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void printConfig(Node node, Writer writer) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                Document doc = (Document)node;
                this.printConfig(doc.getDocumentElement(), writer);
                break;
            }
            case 1: {
                NodeList children = node.getChildNodes();
                if (children != null) {
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.printConfig(children.item(i), writer);
                    }
                }
                if (node.getNodeName().equalsIgnoreCase("single-server")) {
                    this.printSingleServerInfo(node, writer);
                    break;
                }
                if (!node.getNodeName().equalsIgnoreCase("cluster-server")) break;
                this.printClusterServerInfo(node, writer);
            }
        }
    }

    private void printSingleServerInfo(Node node, Writer writer) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() == 3) continue;
                try {
                    writer.write("single server children: " + children.item(i).getNodeName() + "\n");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printClusterServerInfo(Node node, Writer writer) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() == 3) continue;
                try {
                    writer.write("cluster server children: " + children.item(i).getNodeName() + "\n");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ServerChain getServerChain() {
        return this.serverChain;
    }

    private BaseServer createSingleServer(Node node) {
        BaseServer server = new BaseServer();
        NodeList values = node.getChildNodes();
        for (int i = 0; i < values.getLength(); ++i) {
            Node sNode = values.item(i);
            if (sNode.getNodeName().equalsIgnoreCase("domain-name")) {
                server.setDomainName(this.getValue(sNode));
                continue;
            }
            if (sNode.getNodeName().equalsIgnoreCase("rewriting")) {
                server.setIsRewriting(this.getValue(sNode));
                continue;
            }
            if (sNode.getNodeName().equalsIgnoreCase("path")) {
                server.setPath(this.getValue(sNode));
                continue;
            }
            if (sNode.getNodeName().equalsIgnoreCase("directory-rule")) {
                server.setRule(this.createDirectoryRule(sNode));
                continue;
            }
            if (!sNode.getNodeName().equalsIgnoreCase("accept-everything-rule")) continue;
            server.setRule(new AcceptEverythingRule());
        }
        return server;
    }

    private String getValue(Node node) {
        return node.getFirstChild().getNodeValue();
    }

    private RoundRobinCluster createClusterServer(Node node) {
        RoundRobinCluster rrCluster = new RoundRobinCluster();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node server = children.item(i);
            if (server.getNodeName().equalsIgnoreCase("server")) {
                String domainName = this.getDomainName(node);
                String path = this.getPath(node);
                rrCluster.addServer(domainName, path);
                continue;
            }
            if (server.getNodeName().equalsIgnoreCase("directory-rule")) {
                rrCluster.setRule(this.createDirectoryRule(server));
                continue;
            }
            if (!server.getNodeName().equalsIgnoreCase("accept-everything-rule")) continue;
            rrCluster.setRule(new AcceptEverythingRule());
        }
        return rrCluster;
    }

    private String getDomainName(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equalsIgnoreCase("domain-name")) continue;
            return this.getValue(children.item(i));
        }
        return "";
    }

    private String getPath(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equalsIgnoreCase("path")) continue;
            return this.getValue(children.item(i));
        }
        return "";
    }

    private DirectoryRule createDirectoryRule(Node node) {
        DirectoryRule rule = new DirectoryRule();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equalsIgnoreCase("path")) continue;
            rule.setDirectory(this.getValue(children.item(i)));
        }
        return rule;
    }

    private LinkedList createServerList(File data) throws Exception {
        LinkedList<ServerContainerBase> serverlist = new LinkedList<ServerContainerBase>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(data);
        Element config = doc.getDocumentElement();
        NodeList servers = config.getChildNodes();
        for (int i = 0; i < servers.getLength(); ++i) {
            if (servers.item(i).getNodeName().equalsIgnoreCase("single-server")) {
                serverlist.add(this.createSingleServer(servers.item(i)));
                continue;
            }
            if (!servers.item(i).getNodeName().equalsIgnoreCase("cluster-server")) continue;
            serverlist.add(this.createClusterServer(servers.item(i)));
        }
        for (ServerContainer serverContainer : serverlist) {
        }
        return serverlist;
    }

    private void debugServers(LinkedList servers) {
        for (ServerContainer container : servers) {
            logger.log(Level.FINEST, container + " mapped to --> " + container.getRule());
        }
    }

    public static void main(String[] args) {
        File file = new File(args[0]);
        ConfigParser configParser = new ConfigParser(file);
    }
}

