/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.UnknownHostException;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.reverseproxy.ConfigParser;
import jeus.servlet.reverseproxy.ServerChain;
import jeus.servlet.reverseproxy.factories.MethodNotAllowedException;
import jeus.servlet.reverseproxy.factories.RequestHandlerFactory;
import jeus.servlet.reverseproxy.factories.ResponseHandlerFactory;
import jeus.servlet.reverseproxy.model.AllowedMethodHandler;
import jeus.servlet.reverseproxy.model.RequestHandler;
import jeus.servlet.reverseproxy.model.ResponseHandler;
import jeus.servlet.reverseproxy.model.Server;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;

public class ProxyFilter
implements Filter {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.proxy");
    public static String servername = "proxyServer";
    private ServerChain serverChain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpURLConnection.setFollowRedirects(false);
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Server server = (Server)httpRequest.getAttribute(servername);
        if (server == null) {
            server = this.serverChain.evaluate(httpRequest);
        }
        if (server == null) {
            filterChain.doFilter(request, response);
        } else {
            String uri = server.getRule().process(this.getURI(httpRequest));
            String url = request.getScheme() + "://" + server.getDomainName() + server.getPath() + uri;
            logger.log(Level.FINEST, "Connecting to " + url);
            ResponseHandler responseHandler = null;
            try {
                httpRequest = server.preExecute(httpRequest);
                responseHandler = this.executeRequest(httpRequest, url, server.getDomainName());
                httpResponse = server.postExecute(httpResponse);
                responseHandler.process(httpResponse);
            }
            catch (UnknownHostException e) {
                if (logger.isLoggable(JeusMessage_WebContainer10._10406_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10406_LEVEL, JeusMessage_WebContainer10._10406, (Throwable)e);
                }
                httpResponse.setStatus(504);
                server.setConnectionExceptionRecieved(e);
            }
            catch (IOException e) {
                if (logger.isLoggable(JeusMessage_WebContainer10._10407_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10407_LEVEL, JeusMessage_WebContainer10._10407);
                }
                logger.log(Level.SEVERE, e.getMessage());
                httpResponse.setStatus(500);
                server.setConnectionExceptionRecieved(e);
            }
            catch (MethodNotAllowedException e) {
                if (logger.isLoggable(JeusMessage_WebContainer10._10408_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10408_LEVEL, JeusMessage_WebContainer10._10408, (Throwable)e);
                }
                httpResponse.setStatus(405);
                httpResponse.setHeader("Allow", e.getAllowedMethods());
            }
            finally {
                if (responseHandler != null) {
                    responseHandler.close();
                }
            }
        }
    }

    private String getURI(HttpServletRequest httpRequest) {
        String contextPath = httpRequest.getContextPath();
        String uri = httpRequest.getRequestURI().substring(contextPath.length());
        if (httpRequest.getQueryString() != null) {
            uri = uri + "?" + httpRequest.getQueryString();
        }
        return uri;
    }

    private ResponseHandler executeRequest(HttpServletRequest httpRequest, String url, String hostName) throws MethodNotAllowedException, IOException {
        RequestHandler requestHandler = RequestHandlerFactory.createRequestMethod(httpRequest.getMethod());
        HttpURLConnection httpURLConnection = requestHandler.process(httpRequest, url, hostName);
        if (httpURLConnection.getResponseCode() == 405) {
            String value = httpURLConnection.getHeaderField("allow");
            throw new MethodNotAllowedException("Status code 405 from server", AllowedMethodHandler.processAllowHeader(value));
        }
        return ResponseHandlerFactory.createResponseHandler(httpURLConnection);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        AllowedMethodHandler.setAllowedMethods("OPTIONS,GET,HEAD,POST,PUT,DELETE,TRACE");
        String data = filterConfig.getInitParameter("dataUrl");
        if (data == null) {
            this.serverChain = null;
        } else {
            try {
                File dataFile = new File(filterConfig.getServletContext().getRealPath(data));
                ConfigParser parser = new ConfigParser(dataFile);
                this.serverChain = parser.getServerChain();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void destroy() {
        this.serverChain = null;
    }
}

