/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jeus.servlet.reverseproxy.ServerChain;
import jeus.servlet.reverseproxy.UrlRewritingOutputStream;
import jeus.servlet.reverseproxy.model.Server;
import jeus.util.logging.JeusLogger;

public final class UrlRewritingResponseWrapper
extends HttpServletResponseWrapper {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.proxy");
    private UrlRewritingOutputStream outStream;
    private PrintWriter outWriter;
    private PrintWriter originalWriter;
    private Server server;
    private String ownHostName;
    private String contextPath;
    private ServerChain serverChain;
    private static Pattern linkPattern = Pattern.compile("\\b([^/]+://)([^/]+)([\\w/]*)", 130);
    private static Pattern pathAndDomainPattern = Pattern.compile("\\b(path=|domain=)([^;\\s]+);?", 130);

    public UrlRewritingResponseWrapper(HttpServletResponse response, Server server, String ownHostName, String contextPath, ServerChain serverChain) throws IOException {
        super(response);
        this.server = server;
        this.ownHostName = ownHostName;
        this.contextPath = contextPath;
        this.serverChain = serverChain;
        this.outStream = new UrlRewritingOutputStream(response.getOutputStream(), ownHostName, contextPath, serverChain);
        this.outWriter = new PrintWriter((OutputStream)((Object)this.outStream));
        this.originalWriter = new PrintWriter((OutputStream)response.getOutputStream());
    }

    public void addHeader(String name, String originalValue) {
        String value = name.equalsIgnoreCase("location") ? this.rewriteLocation(originalValue) : (name.equalsIgnoreCase("set-cookie") ? this.rewriteSetCookie(originalValue) : originalValue);
        super.addHeader(name, value);
    }

    public void setHeader(String name, String originalValue) {
        String value = name.equalsIgnoreCase("location") ? this.rewriteLocation(originalValue) : (name.equalsIgnoreCase("set-cookie") ? this.rewriteSetCookie(originalValue) : originalValue);
        super.setHeader(name, value);
    }

    private String rewriteLocation(String value) {
        StringBuffer header = new StringBuffer();
        Matcher matcher = linkPattern.matcher(value);
        while (matcher.find()) {
            String location;
            Server matchingServer;
            String link = matcher.group(3).replaceAll("\\$", "\\\\$");
            if (link.length() == 0) {
                link = "/";
            }
            if ((matchingServer = this.serverChain.getServerMapped(location = matcher.group(2) + link)) == null) continue;
            link = link.substring(matchingServer.getPath().length());
            link = matchingServer.getRule().revert(link);
            matcher.appendReplacement(header, "$1" + this.ownHostName + this.contextPath + link);
        }
        matcher.appendTail(header);
        logger.log(Level.FINEST, "Location header rewritten " + value + " >> " + header.toString());
        return header.toString();
    }

    private String rewriteSetCookie(String value) {
        StringBuffer header = new StringBuffer();
        Matcher matcher = pathAndDomainPattern.matcher(value);
        while (matcher.find()) {
            if (matcher.group(1).equalsIgnoreCase("path=")) {
                String path = this.server.getRule().revert(matcher.group(2));
                matcher.appendReplacement(header, "$1" + path + ";");
                continue;
            }
            matcher.appendReplacement(header, "");
        }
        matcher.appendTail(header);
        logger.log(Level.FINEST, "Set-Cookie header rewritten \"" + value + "\" >> " + header.toString());
        return header.toString();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.getContentType() != null && this.shouldRewrite(this.getContentType())) {
            return this.outStream;
        }
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.getContentType() != null && this.shouldRewrite(this.getContentType())) {
            return this.outWriter;
        }
        return this.originalWriter;
    }

    public void processStream() throws IOException {
        if (this.getContentType() != null && this.shouldRewrite(this.getContentType())) {
            this.outStream.rewrite(this.server, this.getCharacterEncoding());
        }
        super.getOutputStream().flush();
        super.getOutputStream().close();
        this.outStream.close();
        this.originalWriter.close();
        this.outWriter.close();
    }

    private boolean shouldRewrite(String contentType) {
        String lowerCased = contentType.toLowerCase();
        return lowerCased.indexOf("html") > -1 || lowerCased.indexOf("css") > -1 || lowerCased.indexOf("javascript") > -1;
    }

    public String getCharacterEncoding() {
        return this.getResponse().getCharacterEncoding();
    }
}

