/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.responsehandlers;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.reverseproxy.model.ResponseHandler;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;

public abstract class ResponseHandlerBase
implements ResponseHandler {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.proxy");
    protected HttpURLConnection httpURLConnection;

    public ResponseHandlerBase(HttpURLConnection httpURLConnection) {
        this.httpURLConnection = httpURLConnection;
    }

    public abstract void process(HttpServletResponse var1) throws IOException;

    public void close() {
        this.httpURLConnection.disconnect();
    }

    public int getStatusCode() {
        try {
            return this.httpURLConnection.getResponseCode();
        }
        catch (IOException e) {
            return -1;
        }
    }

    protected void sendStreamToClient(ServletResponse response) throws IOException {
        InputStream streamFromServer = this.httpURLConnection.getInputStream();
        ServletOutputStream responseStream = response.getOutputStream();
        if (streamFromServer != null) {
            byte[] buffer = new byte[1024];
            int read = streamFromServer.read(buffer);
            while (read > 0) {
                responseStream.write(buffer, 0, read);
                read = streamFromServer.read(buffer);
            }
            streamFromServer.close();
        }
        responseStream.flush();
        responseStream.close();
    }

    protected void setHeaders(HttpServletResponse response) {
        int i = 1;
        while (true) {
            String name = this.httpURLConnection.getHeaderFieldKey(i);
            String value = this.httpURLConnection.getHeaderField(i);
            if (name == null || value == null) break;
            boolean contentLength = name.equalsIgnoreCase("content-length");
            boolean connection = name.equalsIgnoreCase("connection");
            if (!contentLength && !connection) {
                response.addHeader(name, value);
            }
            if (name.equalsIgnoreCase("Content-Type")) {
                response.setContentType(value);
            }
            ++i;
        }
        this.setViaHeader(response);
    }

    private void setViaHeader(HttpServletResponse response) {
        String serverHostName = "jEasyReverseProxy";
        try {
            serverHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.log(JeusMessage_WebContainer10._10416_LEVEL, JeusMessage_WebContainer10._10416, (Throwable)e);
        }
        String originalVia = this.httpURLConnection.getHeaderField("via");
        StringBuffer via = new StringBuffer("");
        if (originalVia != null) {
            via.append(originalVia).append(", ");
        }
        via.append(this.getHttpVersion()).append(" ").append(serverHostName);
        response.setHeader("via", via.toString());
    }

    protected String getHttpVersion() {
        StringTokenizer statusLine = new StringTokenizer(this.httpURLConnection.getHeaderField(0));
        String httpVersion = statusLine.nextToken();
        if (httpVersion.startsWith("HTTP")) {
            return httpVersion;
        }
        return "HTTP/1.0";
    }
}

